/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFcFmrc;
import thredds.catalog.InvDatasetFcPoint;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CatalogCollectionManager;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.log.LoggerFactoryImpl;

@ThreadSafe
public abstract class InvDatasetFeatureCollection
extends InvCatalogRef
implements CollectionManager.TriggerListener {
    protected static final String LATEST_DATASET_CATALOG = "latest.xml";
    protected static final String LATEST_SERVICE = "latest";
    protected static final String VARIABLES = "?metadata=variableMap";
    protected static final String FILES = "files";
    protected static final String Virtual_Services = "VirtualServices";
    private static String catalogServletName = "/catalog";
    protected static String context = "/thredds";
    private static String cdmrFeatureServiceUrlPath = "/cdmrFeature";
    private static ucar.nc2.util.log.LoggerFactory loggerFactory = new LoggerFactoryImpl();
    private static Logger classLogger = LoggerFactory.getLogger(InvDatasetFeatureCollection.class);
    protected InvService orgService;
    protected InvService virtualService;
    protected InvService cdmrService;
    protected Logger logger;
    protected final String path;
    protected final FeatureCollectionType fcType;
    protected final FeatureCollectionConfig config;
    protected final String topDirectory;
    protected CollectionManager dcm;
    @GuardedBy(value="lock")
    protected State state;
    protected final Object lock = new Object();
    protected String latestFileName = "Latest File";

    public static void setContext(String c) {
        context = c;
    }

    public static void setCatalogServletName(String catServletName) {
        catalogServletName = catServletName;
    }

    private static String buildCatalogServiceHref(String path) {
        return context + (catalogServletName == null ? "" : catalogServletName) + "/" + path + "/catalog.xml";
    }

    public static void setCdmrFeatureServiceUrlPath(String urlPath) {
        cdmrFeatureServiceUrlPath = urlPath;
    }

    public static void setLoggerFactory(ucar.nc2.util.log.LoggerFactory fac) {
        loggerFactory = fac;
    }

    private static InvService makeCdmrFeatureService() {
        return new InvService("cdmrFeature", "cdmrFeature", context + cdmrFeatureServiceUrlPath, null, null);
    }

    public static InvDatasetFeatureCollection factory(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        InvDatasetFeatureCollection result;
        if (fcType == FeatureCollectionType.FMRC) {
            result = new InvDatasetFcFmrc(parent, name, path, fcType, config);
        } else if (fcType == FeatureCollectionType.GRIB) {
            try {
                Class<?> c = InvDatasetFeatureCollection.class.getClassLoader().loadClass("thredds.catalog.InvDatasetFcGrib");
                Constructor<?> ctor = c.getConstructor(InvDatasetImpl.class, String.class, String.class, FeatureCollectionType.class, FeatureCollectionConfig.class);
                result = (InvDatasetFeatureCollection)ctor.newInstance(new Object[]{parent, name, path, fcType, config});
            }
            catch (Throwable e) {
                classLogger.error("Failed to open " + name + " path=" + path, e);
                return null;
            }
        } else {
            result = new InvDatasetFcPoint(parent, name, path, fcType, config);
        }
        if (result != null) {
            result.finishConstruction();
        }
        return result;
    }

    protected InvDatasetFeatureCollection(InvDatasetImpl parent, String name, String path, FeatureCollectionType fcType, FeatureCollectionConfig config) {
        super(parent, name, InvDatasetFeatureCollection.buildCatalogServiceHref(path));
        String collectionName;
        this.path = path;
        this.fcType = fcType;
        this.getLocalMetadataInheritable().setDataType(fcType.getFeatureType());
        this.config = config;
        if (config.gribConfig.latestNamer != null) {
            this.latestFileName = config.gribConfig.latestNamer;
        }
        config.name = collectionName = CollectionManagerAbstract.cleanName(config.name != null ? config.name : name);
        this.logger = loggerFactory.getLogger("fc." + collectionName);
        Formatter errlog = new Formatter();
        this.dcm = config.spec.startsWith("catalog:") ? new CatalogCollectionManager(config.spec) : new MFileCollectionManager(config, errlog, this.logger);
        this.topDirectory = this.dcm.getRoot();
        this.logger.info("FeatureCollection added = {}", (Object)this.getConfig());
        String errs = errlog.toString();
        if (errs.length() > 0) {
            this.logger.warn("MFileCollectionManager parse error = {} ", (Object)errs);
        }
    }

    protected void finishConstruction() {
        this.dcm.addEventListener(this);
        CollectionUpdater.INSTANCE.scheduleTasks(this.config, this.dcm);
    }

    protected String getCatalogHref(String what) {
        return InvDatasetFeatureCollection.buildCatalogServiceHref(this.path + "/" + what);
    }

    protected void firstInit() {
        this.orgService = this.getServiceDefault();
        if (this.orgService == null) {
            throw new IllegalStateException("No default service for InvDatasetFeatureCollection " + this.name);
        }
        this.virtualService = this.makeVirtualService(this.orgService);
        this.cdmrService = InvDatasetFeatureCollection.makeCdmrFeatureService();
    }

    @Override
    public void handleCollectionEvent(CollectionManager.TriggerEvent event) {
        boolean tdsUsingTdm;
        boolean bl = tdsUsingTdm = !CollectionUpdater.INSTANCE.isTdm() && this.config.tdmConfig != null;
        if (event.getType() == CollectionManager.TriggerType.updateNocheck) {
            this.update(CollectionManager.Force.nocheck);
        } else if (event.getType() == CollectionManager.TriggerType.update) {
            this.update(CollectionManager.Force.always);
        } else if (event.getType() == CollectionManager.TriggerType.proto) {
            this.updateProto();
        }
    }

    public abstract void update(CollectionManager.Force var1);

    public abstract void updateProto();

    protected abstract State checkState() throws IOException;

    public String getPath() {
        return this.path;
    }

    public String getLatestFileName() {
        return this.latestFileName;
    }

    public String getTopDirectoryLocation() {
        return this.topDirectory;
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public CollectionManager getDatasetCollectionManager() {
        return this.dcm;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public List<InvDataset> getDatasets() {
        try {
            this.checkState();
        }
        catch (Exception e) {
            this.logger.error("Error in checkState", (Throwable)e);
        }
        return this.state.datasets;
    }

    protected InvService makeVirtualService(InvService org) {
        if (org.getServiceType() != ServiceType.COMPOUND) {
            return org;
        }
        InvService result = new InvService(Virtual_Services, ServiceType.COMPOUND.toString(), null, null, null);
        for (InvService service : org.getServices()) {
            if (service.getServiceType() == ServiceType.HTTPServer) continue;
            result.addService(service);
        }
        return result;
    }

    public abstract InvCatalogImpl makeCatalog(String var1, String var2, URI var3);

    protected InvCatalogImpl makeCatalogTop(URI catURI, State localState) throws IOException, URISyntaxException {
        String id;
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            top.transferMetadata(parent, true);
        }
        if ((id = this.getID()) == null) {
            id = this.getPath();
        }
        top.setID(id);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        mainCatalog.addDataset(top);
        for (InvDataset ds : this.getDatasets()) {
            top.addDataset((InvDatasetImpl)ds);
        }
        mainCatalog.finish();
        return mainCatalog;
    }

    protected InvCatalogImpl makeCatalogFiles(URI catURI, State localState, List<String> filenames, boolean addLatest) throws IOException {
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(FILES);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.coverage != null) {
            tmi.setGeospatialCoverage(localState.coverage);
        }
        result.addDataset(top);
        result.addService(this.orgService);
        top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        if (addLatest) {
            InvDatasetImpl ds = new InvDatasetImpl(this, this.getLatestFileName());
            ds.setUrlPath(LATEST_DATASET_CATALOG);
            ds.setServiceName(LATEST_SERVICE);
            ds.finish();
            top.addDataset(ds);
            result.addService(InvService.latest);
        }
        ArrayList<String> sortedFilenames = new ArrayList<String>(filenames);
        if (this.config.gribConfig != null && !this.config.gribConfig.filesSortIncreasing.booleanValue()) {
            Collections.reverse(sortedFilenames);
        } else {
            Collections.sort(sortedFilenames, String.CASE_INSENSITIVE_ORDER);
        }
        for (String f : sortedFilenames) {
            if (!f.startsWith(this.topDirectory)) {
                this.logger.warn("File {} doesnt start with topDir {}", (Object)f, (Object)this.topDirectory);
            }
            String fname = f.substring(this.topDirectory.length() + 1);
            InvDatasetImpl ds = new InvDatasetImpl(this, fname);
            String lpath = this.getPath() + "/" + FILES + "/" + fname;
            ds.setUrlPath(lpath);
            ds.setID(lpath);
            ds.tmi.addVariableMapLink(this.makeMetadataLink(lpath, VARIABLES));
            File file = new File(f);
            ds.tm.setDataSize(file.length());
            ds.finish();
            top.addDataset(ds);
        }
        result.finish();
        return result;
    }

    protected String makeMetadataLink(String datasetName, String metadata) {
        return context + "/metadata/" + datasetName + metadata;
    }

    public InvCatalogImpl makeLatest(String matchPath, String reqPath, URI catURI) {
        MFile mfile;
        String mpath;
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), catURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(this.getLatestFileName());
        result.addDataset(top);
        if (this.orgService != null) {
            result.addService(this.orgService);
            top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        }
        if (!(mpath = (mfile = this.dcm.getLatestFile()).getPath()).startsWith(this.topDirectory)) {
            this.logger.warn("File {} doesnt start with topDir {}", (Object)mpath, (Object)this.topDirectory);
        }
        String fname = mpath.substring(this.topDirectory.length() + 1);
        String path = "files/" + fname;
        top.setUrlPath(this.path + "/" + path);
        top.setID(this.path + "/" + path);
        top.tmi.addVariableMapLink(this.makeMetadataLink(this.path + "/" + path, VARIABLES));
        top.tm.setDataSize(mfile.getLength());
        result.finish();
        return result;
    }

    public ucar.nc2.dt.GridDataset getGridDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            NetcdfDataset ncd = NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
            return new GridDataset(ncd);
        }
        return null;
    }

    public FeatureDatasetPoint getFeatureDatasetPoint() {
        return null;
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            return NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
        }
        ucar.nc2.dt.GridDataset gds = this.getGridDataset(matchPath);
        return gds == null ? null : (NetcdfDataset)gds.getNetcdfFile();
    }

    public File getFile(String remaining) {
        if (null == this.topDirectory) {
            return null;
        }
        int pos = remaining.indexOf(FILES);
        StringBuilder fname = new StringBuilder(this.topDirectory);
        if (!this.topDirectory.endsWith("/")) {
            fname.append("/");
        }
        fname.append(pos > -1 ? remaining.substring(pos + FILES.length() + 1) : remaining);
        return new File(fname.toString());
    }

    static class ScanFilter
    implements CrawlableDatasetFilter {
        private final Pattern p;
        private final long olderThan;

        public ScanFilter(Pattern p, long olderThan) {
            this.p = p;
            this.olderThan = olderThan;
        }

        @Override
        public boolean accept(CrawlableDataset dataset) {
            long now;
            Date lastModDate;
            Matcher matcher;
            if (dataset.isCollection()) {
                return true;
            }
            if (this.p != null && !(matcher = this.p.matcher(dataset.getName())).matches()) {
                return false;
            }
            return this.olderThan <= 0L || (lastModDate = dataset.lastModified()) == null || (now = System.currentTimeMillis()) - lastModDate.getTime() > this.olderThan;
        }

        @Override
        public Object getConfigObject() {
            return null;
        }
    }

    protected class State {
        protected ThreddsMetadata.Variables vars;
        protected ThreddsMetadata.GeospatialCoverage coverage;
        protected CalendarDateRange dateRange;
        protected List<InvDataset> datasets;
        protected long lastInvChange;
        protected long lastProtoChange;

        protected State(State from) {
            if (from != null) {
                this.vars = from.vars;
                this.coverage = from.coverage;
                this.dateRange = from.dateRange;
                this.lastProtoChange = from.lastProtoChange;
                this.datasets = from.datasets;
                this.lastInvChange = from.lastInvChange;
            }
        }
    }
}

