/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import bak.pcj.map.ObjectKeyIntMapIterator;
import bak.pcj.map.ObjectKeyIntOpenHashMap;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.csw.common.exceptions.OperationNotSupportedEx;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.csw.services.getrecords.CatalogSearcher;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.LuceneUtils;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SummaryComparator;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="CswService.GetDomain")
public class GetDomain
extends AbstractOperation
implements CatalogService {
    static final String NAME = "GetDomain";
    @Autowired
    private LuceneConfig _luceneConfig;
    @Autowired
    private ApplicationContext springAppContext;
    @Autowired
    private CatalogConfiguration _catalogConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Element> handlePropertyName(CatalogConfiguration catalogConfig, String[] propertyNames, ServiceContext context, boolean freq, int maxRecords, String cswServiceSpecificConstraint, LuceneConfig luceneConfig) throws Exception {
        ArrayList<Element> domainValuesList = new ArrayList<Element>();
        if (Log.isDebugEnabled((String)"geonetwork.csw")) {
            Log.debug((String)"geonetwork.csw", (Object)("Handling property names '" + Arrays.toString(propertyNames) + "' with max records of " + maxRecords));
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            Element listOfValues = null;
            Element domainValues = new Element("DomainValues", Csw.NAMESPACE_CSW);
            domainValues.setAttribute("type", "csw:Record");
            String property = propertyNames[i].trim();
            Element pn = new Element("PropertyName", Csw.NAMESPACE_CSW);
            domainValues.addContent((Content)pn.setText(property));
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            SearchManager sm = (SearchManager)gc.getBean(SearchManager.class);
            IndexAndTaxonomy indexAndTaxonomy = sm.getNewIndexReader(null);
            try {
                block22: {
                    TreeSet<Object> sortedValues;
                    boolean isRange;
                    block20: {
                        List<Element> list;
                        block21: {
                            TopDocs hits;
                            GeonetworkMultiReader reader;
                            block18: {
                                block19: {
                                    FieldInfos fi;
                                    reader = indexAndTaxonomy.indexReader;
                                    BooleanQuery groupsQuery = (BooleanQuery)CatalogSearcher.getGroupsQuery(context);
                                    BooleanQuery query = null;
                                    if (StringUtils.isNotEmpty((String)cswServiceSpecificConstraint)) {
                                        Query constraintQuery = LuceneSearcher.parseLuceneQuery((String)cswServiceSpecificConstraint, (LuceneConfig)luceneConfig);
                                        query = new BooleanQuery();
                                        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur((boolean)true, (boolean)false);
                                        query.add((Query)groupsQuery, occur);
                                        query.add(constraintQuery, occur);
                                    } else {
                                        query = groupsQuery;
                                    }
                                    List<Pair> sortFields = Collections.singletonList(Pair.read((Object)"relevance", (Object)true));
                                    Sort sort = LuceneSearcher.makeSort(sortFields, (String)context.getLanguage(), (boolean)false);
                                    Filter filter = null;
                                    Pair searchResults = LuceneSearcher.doSearchAndMakeSummary((int)maxRecords, (int)0, (int)maxRecords, (String)context.getLanguage(), null, (LuceneConfig)luceneConfig, (IndexReader)reader, (Query)query, filter, (Sort)sort, null, (boolean)false);
                                    hits = (TopDocs)searchResults.one();
                                    String indexField = catalogConfig.getFieldMapping().get(property.toLowerCase());
                                    if (indexField != null) {
                                        property = indexField;
                                    }
                                    if ((fi = SlowCompositeReaderWrapper.wrap((IndexReader)reader).getFieldInfos()).fieldInfo(property) != null) break block18;
                                    if (listOfValues == null || listOfValues.getChildren().size() == 0) break block19;
                                    domainValues.addContent(listOfValues);
                                }
                                domainValuesList.add(domainValues);
                                continue;
                            }
                            try {
                                isRange = false;
                                if (catalogConfig.getGetRecordsRangeFields().contains(property)) {
                                    isRange = true;
                                }
                                listOfValues = isRange ? new Element("RangeOfValues", Csw.NAMESPACE_CSW) : new Element("ListOfValues", Csw.NAMESPACE_CSW);
                                HashSet<String> fields = new HashSet<String>();
                                fields.add(property);
                                fields.add("_isTemplate");
                                Collator stringCollator = Collator.getInstance();
                                stringCollator.setStrength(0);
                                sortedValues = new TreeSet<Object>(stringCollator);
                                ObjectKeyIntOpenHashMap duplicateValues = new ObjectKeyIntOpenHashMap();
                                for (int j = 0; j < hits.scoreDocs.length; ++j) {
                                    String[] fieldValues;
                                    DocumentStoredFieldVisitor selector = new DocumentStoredFieldVisitor(fields);
                                    reader.document(hits.scoreDocs[j].doc, (StoredFieldVisitor)selector);
                                    Document doc = selector.getDocument();
                                    String[] isTemplate = doc.getValues("_isTemplate");
                                    if (isTemplate[0] != null && !isTemplate[0].equals("n") || (fieldValues = doc.getValues(property)) == null) continue;
                                    GetDomain.addtoSortedSet(sortedValues, fieldValues, duplicateValues);
                                }
                                SummaryComparator valuesComparator = new SummaryComparator(SummaryComparator.SortOption.FREQUENCY, SummaryComparator.Type.STRING, context.getLanguage(), null);
                                TreeSet<SummaryComparator.SummaryElement> sortedValuesFrequency = new TreeSet<SummaryComparator.SummaryElement>((Comparator<SummaryComparator.SummaryElement>)valuesComparator);
                                ObjectKeyIntMapIterator entries = duplicateValues.entries();
                                while (entries.hasNext()) {
                                    entries.next();
                                    sortedValuesFrequency.add(new SummaryComparator.SummaryElement(entries));
                                }
                                if (!freq) break block20;
                                list = GetDomain.createValuesByFrequency(sortedValuesFrequency);
                                if (listOfValues == null || listOfValues.getChildren().size() == 0) break block21;
                            }
                            catch (Throwable throwable) {
                                if (listOfValues != null && listOfValues.getChildren().size() != 0) {
                                    domainValues.addContent(listOfValues);
                                }
                                domainValuesList.add(domainValues);
                                throw throwable;
                            }
                            domainValues.addContent((Content)listOfValues);
                        }
                        domainValuesList.add(domainValues);
                        return list;
                    }
                    listOfValues.addContent(GetDomain.createValuesElement(sortedValues, isRange));
                    if (listOfValues == null || listOfValues.getChildren().size() == 0) break block22;
                    domainValues.addContent((Content)listOfValues);
                }
                domainValuesList.add(domainValues);
                continue;
            }
            finally {
                sm.releaseIndexReader(indexAndTaxonomy);
            }
        }
        return domainValuesList;
    }

    private static void addtoSortedSet(SortedSet<String> sortedValues, String[] fieldValues, ObjectKeyIntOpenHashMap duplicateValues) {
        for (String value : fieldValues) {
            sortedValues.add(value);
            if (duplicateValues.containsKey((Object)value)) {
                int nb = duplicateValues.get((Object)value);
                duplicateValues.remove((Object)value);
                duplicateValues.put((Object)value, nb + 1);
                continue;
            }
            duplicateValues.put((Object)value, 1);
        }
    }

    private static List<Element> createValuesElement(SortedSet<String> sortedValues, boolean isRange) {
        ArrayList<Element> valuesList = new ArrayList<Element>();
        if (!isRange) {
            for (String value : sortedValues) {
                valuesList.add(new Element("Value", Csw.NAMESPACE_CSW).setText(value));
            }
        } else {
            valuesList.add(new Element("MinValue", Csw.NAMESPACE_CSW).setText(sortedValues.first()));
            valuesList.add(new Element("MaxValue", Csw.NAMESPACE_CSW).setText(sortedValues.last()));
        }
        return valuesList;
    }

    private static List<Element> createValuesByFrequency(TreeSet<SummaryComparator.SummaryElement> sortedValuesFrequency) {
        ArrayList<Element> values = new ArrayList<Element>();
        for (SummaryComparator.SummaryElement element : sortedValuesFrequency) {
            Element value = new Element("Value", Csw.NAMESPACE_CSW);
            value.setAttribute("count", Integer.toString(element.count));
            value.setText(element.name);
            values.add(value);
        }
        return values;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        this.checkService(request);
        this.checkVersion(request);
        Element response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
        String[] propertyNames = this.getParameters(request, "PropertyName");
        String[] parameterNames = this.getParameters(request, "ParameterName");
        String cswServiceSpecificConstraint = request.getChildText("filter");
        if (propertyNames != null) {
            List<Element> domainValues;
            try {
                int maxNumberOfRecordsForPropertyNames = this._catalogConfig.getMaxNumberOfRecordsForPropertyNames();
                domainValues = GetDomain.handlePropertyName(this._catalogConfig, propertyNames, context, false, maxNumberOfRecordsForPropertyNames, cswServiceSpecificConstraint, this._luceneConfig);
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.csw", (Object)("Error getting domain value for specified PropertyName : " + e));
                throw new NoApplicableCodeEx("Raised exception while getting domain value for specified PropertyName  : " + e);
            }
            response.addContent(domainValues);
            return response;
        }
        if (parameterNames != null) {
            List<Element> domainValues = this.handleParameterName(parameterNames);
            response.addContent(domainValues);
        }
        return response;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) {
        String service = params.get("service");
        String version = params.get("version");
        String parameterName = params.get("parametername");
        String propertyName = params.get("propertyname");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "version", version);
        Element propName = new Element("PropertyName", Csw.NAMESPACE_CSW).setText(propertyName);
        Element paramName = new Element("ParameterName", Csw.NAMESPACE_CSW).setText(parameterName);
        if (propertyName != null && !propertyName.equals("")) {
            request.addContent((Content)propName);
        } else if (parameterName != null && !parameterName.equals("")) {
            request.addContent((Content)paramName);
        }
        return request;
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        return null;
    }

    private List<Element> handleParameterName(String[] parameterNames) throws CatalogException {
        ArrayList<Element> domainValuesList = null;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (i == 0) {
                domainValuesList = new ArrayList<Element>();
            }
            Element domainValues = new Element("DomainValues", Csw.NAMESPACE_CSW);
            domainValues.setAttribute("type", "csw:Record");
            String paramName = parameterNames[i];
            Element pn = new Element("ParameterName", Csw.NAMESPACE_CSW);
            domainValues.addContent((Content)pn.setText(paramName));
            String operationName = paramName.substring(0, paramName.indexOf(46));
            String parameterName = paramName.substring(paramName.indexOf(46) + 1);
            CatalogService cs = this.checkOperation(operationName);
            Element values = cs.retrieveValues(parameterName);
            if (values != null) {
                domainValues.addContent((Content)values);
            }
            domainValuesList.add(domainValues);
        }
        return domainValuesList;
    }

    private CatalogService checkOperation(String operationName) throws CatalogException {
        CatalogService cs = (CatalogService)this.springAppContext.getBean("CswService." + operationName, CatalogService.class);
        if (cs == null) {
            throw new OperationNotSupportedEx(operationName);
        }
        return cs;
    }

    private String[] getParameters(Element request, String parameter) {
        if (request == null) {
            return null;
        }
        Element paramElt = request.getChild(parameter, Csw.NAMESPACE_CSW);
        if (paramElt == null) {
            return null;
        }
        String parameterName = paramElt.getText();
        return parameterName.split(",");
    }
}

