/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.leveldb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.activemq.util.LRUCache;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferEditor;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.BaseRetained;
import org.fusesource.mq.leveldb.LevelDBClient$;
import org.fusesource.mq.leveldb.RecordLog$;
import org.fusesource.mq.leveldb.RecordLog$LogReader$;
import org.fusesource.mq.leveldb.RecordLog$log_mutex$;
import org.fusesource.mq.leveldb.util.FileSupport$;
import org.fusesource.mq.leveldb.util.TimeMetric;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011uw!B\u0001\u0003\u0011\u000bY\u0011!\u0003*fG>\u0014H\rT8h\u0015\t\u0019A!A\u0004mKZ,G\u000e\u001a2\u000b\u0005\u00151\u0011AA7r\u0015\t9\u0001\"\u0001\u0006gkN,7o\\;sG\u0016T\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA)a\u0004\u0002\n%\u0016\u001cwN\u001d3M_\u001e\u001cR!\u0004\t\u0019=\u0011\u0002\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00037\t\tA!\u001e;jY&\u0011QD\u0007\u0002\u0004\u0019><\u0007CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aC*dC2\fwJ\u00196fGR\u0004\"aH\u0013\n\u0005\u0019\u0002#\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0015\u000e\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001dYSB1A\u0005\u00021\n\u0011\u0003T(H?\"+\u0015\tR#S?B\u0013VIR%Y+\u0005i\u0003CA\u0010/\u0013\ty\u0003E\u0001\u0003CsR,\u0007BB\u0019\u000eA\u0003%Q&\u0001\nM\u001f\u001e{\u0006*R!E\u000bJ{\u0006KU#G\u0013b\u0003\u0003bB\u001a\u000e\u0005\u0004%\t\u0001L\u0001\u000f+>;v,\u0012(E?J+5i\u0014*E\u0011\u0019)T\u0002)A\u0005[\u0005yQkT,`\u000b:#uLU#D\u001fJ#\u0005\u0005C\u00048\u001b\t\u0007I\u0011\u0001\u001d\u0002\u001f1{ui\u0018%F\u0003\u0012+%kX*J5\u0016+\u0012!\u000f\t\u0003?iJ!a\u000f\u0011\u0003\u0007%sG\u000f\u0003\u0004>\u001b\u0001\u0006I!O\u0001\u0011\u0019>;u\fS#B\t\u0016\u0013vlU%[\u000b\u0002BqaP\u0007C\u0002\u0013\u0005\u0001(A\u0006C+\u001a3UIU0T\u0013j+\u0005BB!\u000eA\u0003%\u0011(\u0001\u0007C+\u001a3UIU0T\u0013j+\u0005\u0005C\u0004D\u001b\t\u0007I\u0011\u0001\u001d\u0002%\tK\u0006+Q*T?\n+fIR#S?NK%,\u0012\u0005\u0007\u000b6\u0001\u000b\u0011B\u001d\u0002'\tK\u0006+Q*T?\n+fIR#S?NK%,\u0012\u0011\u0007\t\u001dk\u0001\t\u0013\u0002\b\u0019><\u0017J\u001c4p'\u00151\u0005CH%%!\ty\"*\u0003\u0002LA\t9\u0001K]8ek\u000e$\b\u0002C'G\u0005+\u0007I\u0011\u0001(\u0002\t\u0019LG.Z\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!\u000bF\u0001\u0003S>L!\u0001V)\u0003\t\u0019KG.\u001a\u0005\t-\u001a\u0013\t\u0012)A\u0005\u001f\u0006)a-\u001b7fA!A\u0001L\u0012BK\u0002\u0013\u0005\u0011,\u0001\u0005q_NLG/[8o+\u0005Q\u0006CA\u0010\\\u0013\ta\u0006E\u0001\u0003M_:<\u0007\u0002\u00030G\u0005#\u0005\u000b\u0011\u0002.\u0002\u0013A|7/\u001b;j_:\u0004\u0003\u0002\u00031G\u0005+\u0007I\u0011A-\u0002\r1,gn\u001a;i\u0011!\u0011gI!E!\u0002\u0013Q\u0016a\u00027f]\u001e$\b\u000e\t\u0005\u0006Q\u0019#\t\u0001\u001a\u000b\u0005K\u001eD\u0017\u000e\u0005\u0002g\r6\tQ\u0002C\u0003NG\u0002\u0007q\nC\u0003YG\u0002\u0007!\fC\u0003aG\u0002\u0007!\fC\u0003l\r\u0012\u0005\u0011,A\u0003mS6LG\u000fC\u0004n\r\u0006\u0005I\u0011\u00018\u0002\t\r|\u0007/\u001f\u000b\u0005K>\u0004\u0018\u000fC\u0004NYB\u0005\t\u0019A(\t\u000fac\u0007\u0013!a\u00015\"9\u0001\r\u001cI\u0001\u0002\u0004Q\u0006bB:G#\u0003%\t\u0001^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005)(FA(wW\u00059\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003%)hn\u00195fG.,GM\u0003\u0002}A\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yL(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0001$\u0012\u0002\u0013\u0005\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)A\u000b\u0002[m\"I\u0011\u0011\u0002$\u0012\u0002\u0013\u0005\u00111A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011\u001d\tiA\u0012C!\u0003\u001f\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002s!9\u00111\u0003$\u0005B\u0005U\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0001\u0003BA\r\u0003?q1aHA\u000e\u0013\r\ti\u0002I\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0001\u0005C\u0004\u0002(\u0019#\t%!\u000b\u0002\r\u0015\fX/\u00197t)\u0011\tY#!\r\u0011\u0007}\ti#C\u0002\u00020\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u00024\u0005\u0015\u0012\u0011!a\u0001\u0003k\t1\u0001\u001f\u00132!\ry\u0012qG\u0005\u0004\u0003s\u0001#aA!os\"9\u0011Q\b$\u0005B\u0005}\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002BA\u0019\u0011#a\u0011\n\u0007\u0005\u0005\"\u0003\u0003\u0004\u0002H\u0019#\t\u0005O\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\b\u0003\u00172E\u0011IA'\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002P!I\u00111GA%\u0003\u0003\u0005\r!\u000f\u0005\b\u0003'2E\u0011IA+\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0016\u0003/B!\"a\r\u0002R\u0005\u0005\t\u0019AA\u001b\u000f%\tY&DA\u0001\u0012\u000b\ti&A\u0004M_\u001eLeNZ8\u0011\u0007\u0019\fyF\u0002\u0005H\u001b\u0005\u0005\tRAA1'\u0019\ty&a\u0019\u001fIAA\u0011QMA6\u001fjSV-\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u0011\u0002\u000fI,h\u000e^5nK&!\u0011QNA4\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\bQ\u0005}C\u0011AA9)\t\ti\u0006\u0003\u0005\u0002\u0014\u0005}CQIA;)\t\t\t\u0005\u0003\u0006\u0002z\u0005}\u0013\u0011!CA\u0003w\nQ!\u00199qYf$r!ZA?\u0003\u007f\n\t\t\u0003\u0004N\u0003o\u0002\ra\u0014\u0005\u00071\u0006]\u0004\u0019\u0001.\t\r\u0001\f9\b1\u0001[\u0011)\t))a\u0018\u0002\u0002\u0013\u0005\u0015qQ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI)!&\u0011\u000b}\tY)a$\n\u0007\u00055\u0005E\u0001\u0004PaRLwN\u001c\t\u0007?\u0005EuJ\u0017.\n\u0007\u0005M\u0005E\u0001\u0004UkBdWm\r\u0005\b\u0003/\u000b\u0019\t1\u0001f\u0003\rAH\u0005\r\u0005\t\u00037\u000by\u0006\"\u0005\u0002\u001e\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0001\u0002bBAQ\u001b\u0011\u0005\u00111U\u0001\fK:\u001cw\u000eZ3`Y>tw\r\u0006\u0003\u0002&\u0006E\u0006\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-f!A\u0004iC^$(-\u001e4\n\t\u0005=\u0016\u0011\u0016\u0002\u0007\u0005V4g-\u001a:\t\u000f\u0005M\u0016q\u0014a\u00015\u0006\u0011\u0011-\r\u0005\b\u0003okA\u0011AA]\u0003-!WmY8eK~cwN\\4\u0015\u0007i\u000bY\f\u0003\u0005\u0002>\u0006U\u0006\u0019AAS\u0003\u00151\u0018\r\\;f\u0011%\t\t-Db\u0001\n\u0003\t\u0019-\u0001\n%K:\f'\r\\3`CN\u001cXM\u001d;j_:\u001cXCAA\u0016\u0011!\t9-\u0004Q\u0001\n\u0005-\u0012a\u0005\u0013f]\u0006\u0014G.Z0bgN,'\u000f^5p]N\u0004\u0003\"CA=\u001b\u0005\u0005I\u0011QAf)\u0019\ti\r\"4\u0005PB\u0019A\"a4\u0007\u000b9\u0011\u0001)!5\u0014\r\u0005=\u0007CH%%\u0011)\t).a4\u0003\u0016\u0004%\tAT\u0001\nI&\u0014Xm\u0019;pefD!\"!7\u0002P\nE\t\u0015!\u0003P\u0003)!\u0017N]3di>\u0014\u0018\u0010\t\u0005\f\u0003;\fyM!f\u0001\n\u0003\ty.A\u0005m_\u001e\u001cVO\u001a4jqV\u0011\u0011q\u0003\u0005\f\u0003G\fyM!E!\u0002\u0013\t9\"\u0001\u0006m_\u001e\u001cVO\u001a4jq\u0002Bq\u0001KAh\t\u0003\t9\u000f\u0006\u0004\u0002N\u0006%\u00181\u001e\u0005\b\u0003+\f)\u000f1\u0001P\u0011!\ti.!:A\u0002\u0005]\u0001\"CAx\u0003\u001f\u0004\r\u0011\"\u0001Z\u0003\u001dawnZ*ju\u0016D!\"a=\u0002P\u0002\u0007I\u0011AA{\u0003-awnZ*ju\u0016|F%Z9\u0015\t\u0005]\u0018Q \t\u0004?\u0005e\u0018bAA~A\t!QK\\5u\u0011%\t\u0019$!=\u0002\u0002\u0003\u0007!\f\u0003\u0005\u0003\u0002\u0005=\u0007\u0015)\u0003[\u0003!awnZ*ju\u0016\u0004\u0003B\u0003B\u0003\u0003\u001f\u0004\r\u0011\"\u0001\u0003\b\u0005\u00012-\u001e:sK:$x,\u00199qK:$WM]\u000b\u0003\u0005\u0013\u0001BAa\u0003\u0003\u000e5\u0011\u0011q\u001a\u0004\b\u0005\u001f\ty\r\u0001B\t\u0005-aunZ!qa\u0016tG-\u001a:\u0014\u000b\t5!1\u0003\u0010\u0011\t\t-!Q\u0003\u0004\b\u0005/\ty\r\u0011B\r\u0005%aun\u001a*fC\u0012,'oE\u0004\u0003\u0016\tma$\u0013\u0013\u0011\t\tu!1E\u0007\u0003\u0005?Q1A!\t\u0007\u00031A\u0017m\u001e;eSN\u0004\u0018\r^2i\u0013\u0011\u0011)Ca\b\u0003\u0019\t\u000b7/\u001a*fi\u0006Lg.\u001a3\t\u00135\u0013)B!f\u0001\n\u0003q\u0005\"\u0003,\u0003\u0016\tE\t\u0015!\u0003P\u0011%A&Q\u0003BK\u0002\u0013\u0005\u0011\fC\u0005_\u0005+\u0011\t\u0012)A\u00055\"9\u0001F!\u0006\u0005\u0002\tEBC\u0002B\n\u0005g\u0011)\u0004\u0003\u0004N\u0005_\u0001\ra\u0014\u0005\u00071\n=\u0002\u0019\u0001.\t\u0011\te\"Q\u0003C\u0001\u0005w\tAa\u001c9f]V\u0011!Q\b\t\u0004!\n}\u0012b\u0001B!#\n\u0001\"+\u00198e_6\f5mY3tg\u001aKG.\u001a\u0005\u000b\u0005\u000b\u0012)B1A\u0005\u0002\tm\u0012A\u00014e\u0011%\u0011IE!\u0006!\u0002\u0013\u0011i$A\u0002gI\u0002B!B!\u0014\u0003\u0016\t\u0007I\u0011\u0001B(\u0003\u001d\u0019\u0007.\u00198oK2,\"A!\u0015\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005A1\r[1o]\u0016d7OC\u0002\u0003\\Q\t1A\\5p\u0013\u0011\u0011yF!\u0016\u0003\u0017\u0019KG.Z\"iC:tW\r\u001c\u0005\n\u0005G\u0012)\u0002)A\u0005\u0005#\n\u0001b\u00195b]:,G\u000e\t\u0005\t\u0005O\u0012)\u0002\"\u0011\u0003j\u00059A-[:q_N,GCAA|\u0011!\u0011iG!\u0006\u0005\u0002\t=\u0014\u0001E2iK\u000e\\wL]3bI~3G.^:i)\u0011\t9P!\u001d\t\u000f\tM$1\u000ea\u00015\u0006QQM\u001c3`_\u001a47/\u001a;\t\u0011\t]$Q\u0003C\u0001\u0005s\nAA]3bIR1\u0011Q\u0015B>\u0005\u007fBqA! \u0003v\u0001\u0007!,A\bsK\u000e|'\u000fZ0q_NLG/[8o\u0011\u0019\u0001'Q\u000fa\u0001s!A!q\u000fB\u000b\t\u0003\u0011\u0019\t\u0006\u0003\u0003\u0006\n\u001d\u0005cB\u0010\u0002\u00126\n)K\u0017\u0005\b\u0005{\u0012\t\t1\u0001[\u0011!\u0011YI!\u0006\u0005\u0002\t5\u0015!B2iK\u000e\\G\u0003\u0002BH\u00053\u0003RaHAF\u0005#\u0003ba\bBJ5\n]\u0015b\u0001BKA\t1A+\u001e9mKJ\u0002BaHAF5\"9!Q\u0010BE\u0001\u0004Q\u0006b\u0002BO\u0005+!\t!W\u0001\u0018m\u0016\u0014\u0018NZ=B]\u0012<U\r^#oIB{7/\u001b;j_:D\u0011\"\u001cB\u000b\u0003\u0003%\tA!)\u0015\r\tM!1\u0015BS\u0011!i%q\u0014I\u0001\u0002\u0004y\u0005\u0002\u0003-\u0003 B\u0005\t\u0019\u0001.\t\u0011M\u0014)\"%A\u0005\u0002QD!\"!\u0001\u0003\u0016E\u0005I\u0011AA\u0002\u0011!\tiA!\u0006\u0005B\u0005=\u0001\u0002CA\n\u0005+!\t%!\u0006\t\u0011\u0005\u001d\"Q\u0003C!\u0005c#B!a\u000b\u00034\"Q\u00111\u0007BX\u0003\u0003\u0005\r!!\u000e\t\u0011\u0005u\"Q\u0003C!\u0003\u007fAq!a\u0012\u0003\u0016\u0011\u0005\u0003\b\u0003\u0005\u0002L\tUA\u0011\tB^)\u0011\t)D!0\t\u0013\u0005M\"\u0011XA\u0001\u0002\u0004I\u0004\u0002CA*\u0005+!\tE!1\u0015\t\u0005-\"1\u0019\u0005\u000b\u0003g\u0011y,!AA\u0002\u0005U\u0002bC'\u0003\u000e\t\u0005\t\u0015!\u0003P\u0005OA1\u0002\u0017B\u0007\u0005\u0003\u0005\u000b\u0011\u0002.\u0003,!9\u0001F!\u0004\u0005\u0002\t-GC\u0002B\u0005\u0005\u001b\u0014y\r\u0003\u0004N\u0005\u0013\u0004\ra\u0014\u0005\u00071\n%\u0007\u0019\u0001.\t\u0015\tM'Q\u0002b\u0001\n\u0003\u0011).\u0001\u0003j]\u001a|WC\u0001Bl!\r\u0011IN\u0012\b\u0003\u0019\u0001A\u0011B!8\u0003\u000e\u0001\u0006IAa6\u0002\u000b%tgm\u001c\u0011\t\u0011\te\"Q\u0002C!\u0005wA\u0001Ba\u001a\u0003\u000e\u0011\u0005#\u0011\u000e\u0005\n\u0005K\u0014i\u00011A\u0005\u0002e\u000bQ\"\u00199qK:$wl\u001c4gg\u0016$\bB\u0003Bu\u0005\u001b\u0001\r\u0011\"\u0001\u0003l\u0006\t\u0012\r\u001d9f]\u0012|vN\u001a4tKR|F%Z9\u0015\t\u0005](Q\u001e\u0005\n\u0003g\u00119/!AA\u0002iC\u0001B!=\u0003\u000e\u0001\u0006KAW\u0001\u000fCB\u0004XM\u001c3`_\u001a47/\u001a;!\u0011)\u0011)P!\u0004C\u0002\u0013\u0005!q_\u0001\u000fM2,8\u000f[3e?>4gm]3u+\t\u0011I\u0010\u0005\u0003\u0003|\u000e\u001dQB\u0001B\u007f\u0015\u0011\u0011yp!\u0001\u0002\r\u0005$x.\\5d\u0015\u0011\u0019\u0019a!\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u001c)%!1\u0011\u0002B\u007f\u0005)\tEo\\7jG2{gn\u001a\u0005\n\u0007\u001b\u0011i\u0001)A\u0005\u0005s\fqB\u001a7vg\",GmX8gMN,G\u000f\t\u0005\b\u0007#\u0011i\u0001\"\u0001Z\u0003=\t\u0007\u000f]3oI~\u0003xn]5uS>t\u0007BCB\u000b\u0005\u001b\u0011\r\u0011\"\u0001\u0004\u0018\u0005aqO]5uK~\u0013WO\u001a4feV\u00111\u0011\u0004\t\u0005\u0003O\u001bY\"\u0003\u0003\u0004\u001e\u0005%&!\u0007#bi\u0006\u0014\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6D\u0011b!\t\u0003\u000e\u0001\u0006Ia!\u0007\u0002\u001b]\u0014\u0018\u000e^3`EV4g-\u001a:!\u0011!\u0019)C!\u0004\u0005\u0002\r\u001d\u0012!\u00024pe\u000e,WCAA|\u0011!\u0019YC!\u0004\u0005\u0002\r5\u0012AB1qa\u0016tG\r\u0006\u0004\u00040\rE2Q\u0007\t\u0007?\tM%La6\t\u000f\rM2\u0011\u0006a\u0001[\u0005\u0011\u0011\u000e\u001a\u0005\t\u0007o\u0019I\u00031\u0001\u0002&\u0006!A-\u0019;b\u0011!\u0019YD!\u0004\u0005\u0002\r\u001d\u0012!\u00024mkND\u0007\u0002\u0003B7\u0005\u001b!\tea\u0010\u0015\t\u0005]8\u0011\t\u0005\b\u0005g\u001ai\u00041\u0001[\u0011)\u0019)%a4A\u0002\u0013\u00051qI\u0001\u0015GV\u0014(/\u001a8u?\u0006\u0004\b/\u001a8eKJ|F%Z9\u0015\t\u0005]8\u0011\n\u0005\u000b\u0003g\u0019\u0019%!AA\u0002\t%\u0001\"CB'\u0003\u001f\u0004\u000b\u0015\u0002B\u0005\u0003E\u0019WO\u001d:f]R|\u0016\r\u001d9f]\u0012,'\u000f\t\u0005\u000b\u0007#\ny\r1A\u0005\u0002\u0005\r\u0017\u0001\u0005<fe&4\u0017pX2iK\u000e\\7/^7t\u0011)\u0019)&a4A\u0002\u0013\u00051qK\u0001\u0015m\u0016\u0014\u0018NZ=`G\",7m[:v[N|F%Z9\u0015\t\u0005]8\u0011\f\u0005\u000b\u0003g\u0019\u0019&!AA\u0002\u0005-\u0002\"CB/\u0003\u001f\u0004\u000b\u0015BA\u0016\u0003E1XM]5gs~\u001b\u0007.Z2lgVl7\u000f\t\u0005\u000b\u0007C\ny\r1A\u0005\u0002\u0005\r\u0017\u0001B:z]\u000eD!b!\u001a\u0002P\u0002\u0007I\u0011AB4\u0003!\u0019\u0018P\\2`I\u0015\fH\u0003BA|\u0007SB!\"a\r\u0004d\u0005\u0005\t\u0019AA\u0016\u0011%\u0019i'a4!B\u0013\tY#A\u0003ts:\u001c\u0007\u0005\u0003\u0006\u0004r\u0005='\u0019!C\u0001\u0007g\n\u0011\u0002\\8h?&tgm\\:\u0016\u0005\rU\u0004cBB<\u0007sR&q[\u0007\u0003\u0007\u000bIAaa\u001f\u0004\u0006\t9AK]3f\u001b\u0006\u0004\b\"CB@\u0003\u001f\u0004\u000b\u0011BB;\u0003)awnZ0j]\u001a|7\u000fI\u0004\t\u0007\u0007\u000by\r#\u0002\u0004\u0006\u0006IAn\\4`[V$X\r\u001f\t\u0005\u0005\u0017\u00199I\u0002\u0005\u0004\n\u0006=\u0007RABF\u0005%awnZ0nkR,\u0007p\u0005\u0003\u0004\bBq\u0002b\u0002\u0015\u0004\b\u0012\u00051q\u0012\u000b\u0003\u0007\u000bC\u0001ba%\u0002P\u0012\u00051QS\u0001\u0007I\u0016dW\r^3\u0015\t\u0005]8q\u0013\u0005\b\u0007g\u0019\t\n1\u0001[\u0011!\u0019Y*a4\u0005\u0012\ru\u0015\u0001C8o\t\u0016dW\r^3\u0015\t\u0005-2q\u0014\u0005\u0007\u001b\u000ee\u0005\u0019A(\t\u0011\r\r\u0016q\u001aC\u0001\u0007K\u000b\u0001b\u00195fG.\u001cX/\u001c\u000b\u0004s\r\u001d\u0006\u0002CB\u001c\u0007C\u0003\r!!*\b\u0015\r-\u0016qZA\u0001\u0012\u000b\u0019i+A\u0005M_\u001e\u0014V-\u00193feB!!1BBX\r)\u00119\"a4\u0002\u0002#\u00151\u0011W\n\u0007\u0007_\u001b\u0019L\b\u0013\u0011\u0011\u0005\u00154QW([\u0005'IAaa.\u0002h\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f!\u001ay\u000b\"\u0001\u0004<R\u00111Q\u0016\u0005\t\u0003'\u0019y\u000b\"\u0012\u0002v!Q\u0011\u0011PBX\u0003\u0003%\ti!1\u0015\r\tM11YBc\u0011\u0019i5q\u0018a\u0001\u001f\"1\u0001la0A\u0002iC!\"!\"\u00040\u0006\u0005I\u0011QBe)\u0011\u0019Yma4\u0011\u000b}\tYi!4\u0011\u000b}\u0011\u0019j\u0014.\t\u0011\u0005]5q\u0019a\u0001\u0005'A\u0001ba5\u0002P\u0012\u00051Q[\u0001\u0014GJ,\u0017\r^3`Y><w,\u00199qK:$WM\u001d\u000b\u0005\u0005\u0013\u00199\u000e\u0003\u0004Y\u0007#\u0004\rA\u0017\u0005\t\u00077\fy\r\"\u0001\u0004^\u0006y1M]3bi\u0016|\u0016\r\u001d9f]\u0012,'\u000f\u0006\u0003\u00026\r}\u0007B\u0002-\u0004Z\u0002\u0007!\f\u0003\u0006\u0004d\u0006='\u0019!C\u0001\u0007K\fQ#\\1y?2|wmX<sSR,w\f\\1uK:\u001c\u00170\u0006\u0002\u0004hB\u0019\u0011d!;\n\u0007\r-(D\u0001\u0006US6,W*\u001a;sS\u000eD\u0011ba<\u0002P\u0002\u0006Iaa:\u0002-5\f\u0007p\u00187pO~;(/\u001b;f?2\fG/\u001a8ds\u0002B!ba=\u0002P\n\u0007I\u0011ABs\u0003Ui\u0017\r_0m_\u001e|f\r\\;tQ~c\u0017\r^3oGfD\u0011ba>\u0002P\u0002\u0006Iaa:\u0002-5\f\u0007p\u00187pO~3G.^:i?2\fG/\u001a8ds\u0002B!ba?\u0002P\n\u0007I\u0011ABs\u0003Yi\u0017\r_0m_\u001e|&o\u001c;bi\u0016|F.\u0019;f]\u000eL\b\"CB\u0000\u0003\u001f\u0004\u000b\u0011BBt\u0003]i\u0017\r_0m_\u001e|&o\u001c;bi\u0016|F.\u0019;f]\u000eL\b\u0005\u0003\u0005\u0003:\u0005=G\u0011\u0001C\u0002+\t\t)\u0004\u0003\u0005\u0005\b\u0005=G\u0011AB\u0014\u0003\u0015\u0019Gn\\:f\u0011\u001d!Y!a4\u0005\u0002e\u000ba\"\u00199qK:$WM]0mS6LG\u000fC\u0004\u0005\u0010\u0005=G\u0011A-\u0002\u001d\u0005\u0004\b/\u001a8eKJ|6\u000f^1si\"AA1CAh\t\u0003!)\"\u0001\u0005oKb$x\f\\8h)\ryEq\u0003\u0005\u00071\u0012E\u0001\u0019\u0001.\t\u0011\u0011m\u0011q\u001aC\u0001\t;\t\u0001\"\u00199qK:$WM]\u000b\u0005\t?!)\u0003\u0006\u0003\u0005\"\u0011E\u0002\u0003\u0002C\u0012\tKa\u0001\u0001\u0002\u0005\u0005(\u0011e!\u0019\u0001C\u0015\u0005\u0005!\u0016\u0003\u0002C\u0016\u0003k\u00012a\bC\u0017\u0013\r!y\u0003\t\u0002\b\u001d>$\b.\u001b8h\u0011!!\u0019\u0004\"\u0007A\u0002\u0011U\u0012\u0001\u00024v]\u000e\u0004ra\bC\u001c\u0005\u0013!\t#C\u0002\u0005:\u0001\u0012\u0011BR;oGRLwN\\\u0019\t\u0015\u0011u\u0012q\u001aa\u0001\n\u0003!y$A\u0007p]~cwnZ0s_R\fG/Z\u000b\u0003\t\u0003\u0002Ra\bC\"\u0003oL1\u0001\"\u0012!\u0005%1UO\\2uS>t\u0007\u0007\u0003\u0006\u0005J\u0005=\u0007\u0019!C\u0001\t\u0017\n\u0011c\u001c8`Y><wL]8uCR,w\fJ3r)\u0011\t9\u0010\"\u0014\t\u0015\u0005MBqIA\u0001\u0002\u0004!\t\u0005C\u0005\u0005R\u0005=\u0007\u0015)\u0003\u0005B\u0005qqN\\0m_\u001e|&o\u001c;bi\u0016\u0004\u0003B\u0003C+\u0003\u001f\u0014\r\u0011\"\u0003\u0005X\u0005a!/Z1eKJ|6-Y2iKV\u0011A\u0011\f\t\b\t7\"9g\u0014B\n\u001b\t!iFC\u0002\u001c\t?RA\u0001\"\u0019\u0005d\u0005A\u0011m\u0019;jm\u0016l\u0017OC\u0002\u0005f!\ta!\u00199bG\",\u0017\u0002\u0002C5\t;\u0012\u0001\u0002\u0014*V\u0007\u0006\u001c\u0007.\u001a\u0005\n\t[\ny\r)A\u0005\t3\nQB]3bI\u0016\u0014xlY1dQ\u0016\u0004\u0003\u0002\u0003C9\u0003\u001f$\t\u0001b\u001d\u0002\u00111|wmX5oM>$B\u0001\"\u001e\u0005xA)q$a#\u0003X\"9A\u0011\u0010C8\u0001\u0004Q\u0016a\u00019pg\"AAQPAh\t\u0013!y(\u0001\u0006hKR|&/Z1eKJ,B\u0001\"!\u0005\nR!A1\u0011CH)\u0011!)\tb#\u0011\u000b}\tY\tb\"\u0011\t\u0011\rB\u0011\u0012\u0003\t\tO!YH1\u0001\u0005*!AA1\u0007C>\u0001\u0004!i\tE\u0004 \to\u0011\u0019\u0002b\"\t\u000f\tuD1\u0010a\u00015\"A!qOAh\t\u0003!\u0019\n\u0006\u0003\u0005\u0016\u0012]\u0005#B\u0010\u0002\f\n\u0015\u0005b\u0002C=\t#\u0003\rA\u0017\u0005\t\u0005o\ny\r\"\u0001\u0005\u001cR1AQ\u0014CP\tC\u0003RaHAF\u0003KCq\u0001\"\u001f\u0005\u001a\u0002\u0007!\f\u0003\u0004a\t3\u0003\r!\u000f\u0005\n[\u0006=\u0017\u0011!C\u0001\tK#b!!4\u0005(\u0012%\u0006\"CAk\tG\u0003\n\u00111\u0001P\u0011)\ti\u000eb)\u0011\u0002\u0003\u0007\u0011q\u0003\u0005\tg\u0006=\u0017\u0013!C\u0001i\"Q\u0011\u0011AAh#\u0003%\t\u0001b,\u0016\u0005\u0011E&fAA\fm\"A\u0011QBAh\t\u0003\ny\u0001\u0003\u0005\u0002\u0014\u0005=G\u0011IA\u000b\u0011!\t9#a4\u0005B\u0011eF\u0003BA\u0016\twC!\"a\r\u00058\u0006\u0005\t\u0019AA\u001b\u0011!\ti$a4\u0005B\u0005}\u0002bBA$\u0003\u001f$\t\u0005\u000f\u0005\t\u0003\u0017\ny\r\"\u0011\u0005DR!\u0011Q\u0007Cc\u0011%\t\u0019\u0004\"1\u0002\u0002\u0003\u0007\u0011\b\u0003\u0005\u0002T\u0005=G\u0011\tCe)\u0011\tY\u0003b3\t\u0015\u0005MBqYA\u0001\u0002\u0004\t)\u0004C\u0004\u0002V\u0006%\u0007\u0019A(\t\u0011\u0005u\u0017\u0011\u001aa\u0001\u0003/A\u0011\"!\"\u000e\u0003\u0003%\t\tb5\u0015\t\u0011UG\u0011\u001c\t\u0006?\u0005-Eq\u001b\t\u0007?\tMu*a\u0006\t\u0011\u0005]E\u0011\u001ba\u0001\u0003\u001bDq!a'\u000e\t#\ti\n")
public class RecordLog
implements ScalaObject,
Product,
Serializable {
    private final File directory;
    private final String logSuffix;
    private long logSize;
    private LogAppender current_appender;
    private boolean verify_checksums;
    private boolean sync;
    private final TreeMap<Object, LogInfo> log_infos;
    private final TimeMetric max_log_write_latency;
    private final TimeMetric max_log_flush_latency;
    private final TimeMetric max_log_rotate_latency;
    private Function0<BoxedUnit> on_log_rotate;
    private final LRUCache<File, LogReader> org$fusesource$mq$leveldb$RecordLog$$reader_cache;
    private volatile RecordLog$log_mutex$ log_mutex$module;
    private volatile RecordLog$LogReader$ LogReader$module;

    public static final void trace(Throwable throwable) {
        RecordLog$.MODULE$.trace(throwable);
    }

    public static final void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.trace(throwable, function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Throwable throwable) {
        RecordLog$.MODULE$.debug(throwable);
    }

    public static final void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.debug(throwable, function0, seq);
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.debug(function0, seq);
    }

    public static final void info(Throwable throwable) {
        RecordLog$.MODULE$.info(throwable);
    }

    public static final void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.info(throwable, function0, seq);
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.info(function0, seq);
    }

    public static final void warn(Throwable throwable) {
        RecordLog$.MODULE$.warn(throwable);
    }

    public static final void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.warn(throwable, function0, seq);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.warn(function0, seq);
    }

    public static final void error(Throwable throwable) {
        RecordLog$.MODULE$.error(throwable);
    }

    public static final void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.error(throwable, function0, seq);
    }

    public static final void error(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.error(function0, seq);
    }

    public static final void org$fusesource$mq$leveldb$util$Log$_setter_$log_$eq(Logger logger) {
        RecordLog$.MODULE$.org$fusesource$mq$leveldb$util$Log$_setter_$log_$eq(logger);
    }

    public static final Logger log() {
        return RecordLog$.MODULE$.log();
    }

    public static final boolean $enable_assertions() {
        return RecordLog$.MODULE$.$enable_assertions();
    }

    public static final long decode_long(Buffer buffer) {
        return RecordLog$.MODULE$.decode_long(buffer);
    }

    public static final Buffer encode_long(long l) {
        return RecordLog$.MODULE$.encode_long(l);
    }

    public static final int BYPASS_BUFFER_SIZE() {
        return RecordLog$.MODULE$.BYPASS_BUFFER_SIZE();
    }

    public static final int BUFFER_SIZE() {
        return RecordLog$.MODULE$.BUFFER_SIZE();
    }

    public static final int LOG_HEADER_SIZE() {
        return RecordLog$.MODULE$.LOG_HEADER_SIZE();
    }

    public static final byte UOW_END_RECORD() {
        return RecordLog$.MODULE$.UOW_END_RECORD();
    }

    public static final byte LOG_HEADER_PREFIX() {
        return RecordLog$.MODULE$.LOG_HEADER_PREFIX();
    }

    public File directory() {
        return this.directory;
    }

    public String logSuffix() {
        return this.logSuffix;
    }

    public long logSize() {
        return this.logSize;
    }

    public void logSize_$eq(long l) {
        this.logSize = l;
    }

    public LogAppender current_appender() {
        return this.current_appender;
    }

    public void current_appender_$eq(LogAppender logAppender) {
        this.current_appender = logAppender;
    }

    public boolean verify_checksums() {
        return this.verify_checksums;
    }

    public void verify_checksums_$eq(boolean bl) {
        this.verify_checksums = bl;
    }

    public boolean sync() {
        return this.sync;
    }

    public void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    public TreeMap<Object, LogInfo> log_infos() {
        return this.log_infos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final RecordLog$log_mutex$ log_mutex() {
        if (this.log_mutex$module != null) return this.log_mutex$module;
        RecordLog recordLog = this;
        synchronized (recordLog) {
            if (this.log_mutex$module == null) {
                this.log_mutex$module = new RecordLog$log_mutex$(this);
            }
            return this.log_mutex$module;
        }
    }

    public void delete(long id$1) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            BoxedUnit boxedUnit;
            if (this.current_appender().position() != id$1) {
                Option$.MODULE$.apply((Object)this.log_infos().get(BoxesRunTime.boxToLong((long)id$1))).foreach((Function1)new Serializable(this, id$1){
                    public static final long serialVersionUID;
                    private final RecordLog $outer;
                    private final long id$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final LogInfo apply(LogInfo info2) {
                        this.$outer.onDelete(info2.file());
                        return this.$outer.log_infos().remove(BoxesRunTime.boxToLong((long)this.id$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.id$1 = l;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean onDelete(File file) {
        return file.delete();
    }

    public int checksum(Buffer data) {
        CRC32 checksum = new CRC32();
        checksum.update(data.data, data.offset, data.length);
        return (int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final RecordLog$LogReader$ LogReader() {
        if (this.LogReader$module != null) return this.LogReader$module;
        RecordLog recordLog = this;
        synchronized (recordLog) {
            if (this.LogReader$module == null) {
                this.LogReader$module = new RecordLog$LogReader$(this);
            }
            return this.LogReader$module;
        }
    }

    public LogAppender create_log_appender(long position) {
        return new LogAppender(this, this.next_log(position), position);
    }

    public Object create_appender(long position) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Object object = this.current_appender() == null ? BoxedUnit.UNIT : this.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(this.current_appender().file(), this.current_appender().position(), this.current_appender().append_offset()));
            this.current_appender_$eq(this.create_log_appender(position));
            LogInfo logInfo = this.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(this.current_appender().file(), position, 0L));
            return logInfo;
        }
    }

    public TimeMetric max_log_write_latency() {
        return this.max_log_write_latency;
    }

    public TimeMetric max_log_flush_latency() {
        return this.max_log_flush_latency;
    }

    public TimeMetric max_log_rotate_latency() {
        return this.max_log_rotate_latency;
    }

    public Object open() {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            long l;
            this.log_infos().clear();
            LevelDBClient$.MODULE$.find_sequence_files(this.directory(), this.logSuffix()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final LogInfo apply(Tuple2<Object, File> tuple2) {
                    Tuple2<Object, File> tuple22 = tuple2;
                    if (tuple22 != null) {
                        long l = BoxesRunTime.unboxToLong((Object)tuple22._1());
                        File file = (File)tuple22._2();
                        long position = l;
                        File file2 = file;
                        return this.$outer.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(file2, position, file2.length()));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (this.log_infos().isEmpty()) {
                l = 0L;
            } else {
                LogInfo file$3 = this.log_infos().lastEntry().getValue();
                LogReader r$1 = new LogReader(this, file$3.file(), file$3.position());
                l = this.liftedTree1$1(file$3, r$1);
            }
            long appendPos = l;
            Object object = this.create_appender(appendPos);
            return object;
        }
    }

    public void close() {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            this.current_appender().release();
            return;
        }
    }

    public long appender_limit() {
        return this.current_appender().append_position();
    }

    public long appender_start() {
        return this.current_appender().position();
    }

    public File next_log(long position) {
        return LevelDBClient$.MODULE$.create_sequence_file(this.directory(), position, this.logSuffix());
    }

    public <T> T appender(Function1<LogAppender, T> func$2) {
        long intial_position$1 = this.current_appender().append_position();
        T exceptionResult1 = null;
        try {
            exceptionResult1 = this.max_log_write_latency().apply(new Serializable(this, func$2, intial_position$1){
                public static final long serialVersionUID;
                private final RecordLog $outer;
                private final Function1 func$2;
                private final long intial_position$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                public final T apply() {
                    void var1_1;
                    Object rc = this.func$2.apply((Object)((Object)this.$outer.current_appender()));
                    Tuple2<Object, LogInfo> tuple2 = this.$outer.current_appender().append_position() != this.intial_position$1 ? this.$outer.current_appender().append(RecordLog$.MODULE$.UOW_END_RECORD(), RecordLog$.MODULE$.encode_long(this.intial_position$1)) : BoxedUnit.UNIT;
                    return var1_1;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.func$2 = function1;
                    this.intial_position$1 = l;
                }
            });
            this.current_appender().flush();
            this.max_log_rotate_latency().apply(new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply() {
                    RecordLog$log_mutex$ recordLog$log_mutex$ = this.$outer.log_mutex();
                    synchronized (recordLog$log_mutex$) {
                        Object object;
                        if (this.$outer.current_appender().append_offset() >= this.$outer.logSize()) {
                            this.$outer.current_appender().release();
                            this.$outer.on_log_rotate().apply$mcV$sp();
                            object = this.$outer.create_appender(this.$outer.current_appender().append_position());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = object;
                        return boxedUnit;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            this.current_appender().flush();
            this.max_log_rotate_latency().apply(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        return exceptionResult1;
    }

    public Function0<BoxedUnit> on_log_rotate() {
        return this.on_log_rotate;
    }

    public void on_log_rotate_$eq(Function0<BoxedUnit> function0) {
        this.on_log_rotate = function0;
    }

    public final LRUCache<File, LogReader> org$fusesource$mq$leveldb$RecordLog$$reader_cache() {
        return this.org$fusesource$mq$leveldb$RecordLog$$reader_cache;
    }

    public Option<LogInfo> log_info(long pos) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Option option = Option$.MODULE$.apply(this.log_infos().floorEntry(BoxesRunTime.boxToLong((long)pos))).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final LogInfo apply(Map.Entry<Object, LogInfo> entry) {
                    return entry.getValue();
                }
            });
            return option;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Option<T> get_reader(long record_position, Function1<LogReader, T> func$1) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Option<LogInfo> info2 = this.log_info(record_position);
            Option option = info2.map((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<LogInfo, LogAppender> apply(LogInfo info2) {
                    Tuple2 tuple2;
                    if (info2.position() == this.$outer.current_appender().position()) {
                        this.$outer.current_appender().retain();
                        tuple2 = new Tuple2((Object)info2, (Object)((Object)this.$outer.current_appender()));
                    } else {
                        tuple2 = new Tuple2((Object)info2, null);
                    }
                    return tuple2;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : recordLog$log_mutex$
            Option lookup = option;
            return lookup.map((Function1)new Serializable(this, func$1){
                public static final long serialVersionUID;
                private final RecordLog $outer;
                private final Function1 func$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final T apply(Tuple2<LogInfo, LogAppender> tuple2) {
                    LogReader logReader;
                    Tuple2<LogInfo, LogAppender> tuple22 = tuple2;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    LogInfo logInfo = (LogInfo)tuple22._1();
                    LogAppender logAppender = (LogAppender)((Object)tuple22._2());
                    LogInfo info2 = logInfo;
                    LogAppender appender2 = logAppender;
                    if (appender2 == null) {
                        LRUCache<File, LogReader> lRUCache = this.$outer.org$fusesource$mq$leveldb$RecordLog$$reader_cache();
                        synchronized (lRUCache) {
                            Object object;
                            LogReader reader2 = (LogReader)((Object)this.$outer.org$fusesource$mq$leveldb$RecordLog$$reader_cache().get((Object)info2.file()));
                            if (reader2 == null) {
                                reader2 = new LogReader(this.$outer, info2.file(), info2.position());
                                object = this.$outer.org$fusesource$mq$leveldb$RecordLog$$reader_cache().put((Object)info2.file(), (Object)((Object)reader2));
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            reader2.retain();
                            LogReader logReader2 = reader2;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 9] lbl19 : MonitorExitStatement: MONITOREXIT : lRUCache
                            logReader = logReader2;
                        }
                    } else {
                        logReader = appender2;
                    }
                    LogAppender reader = logReader;
                    Object exceptionResult4 = null;
                    try {
                        exceptionResult4 = this.func$1.apply((Object)((Object)reader));
                        return (T)exceptionResult4;
                    }
                    finally {
                        reader.release();
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.func$1 = function1;
                }
            });
        }
    }

    public Option<Tuple3<Object, Buffer, Object>> read(long pos$2) {
        return this.get_reader(pos$2, (Function1)new Serializable(this, pos$2){
            public static final long serialVersionUID;
            private final long pos$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple3<Object, Buffer, Object> apply(LogReader logReader) {
                return logReader.read(this.pos$2);
            }
            {
                this.pos$2 = l;
            }
        });
    }

    public Option<Buffer> read(long pos$1, int length$2) {
        return this.get_reader(pos$1, (Function1)new Serializable(this, pos$1, length$2){
            public static final long serialVersionUID;
            private final long pos$1;
            private final int length$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer apply(LogReader logReader) {
                return logReader.read(this.pos$1, this.length$2);
            }
            {
                this.pos$1 = l;
                this.length$2 = n;
            }
        });
    }

    public RecordLog copy(File directory, String logSuffix) {
        return new RecordLog(directory, logSuffix);
    }

    public String copy$default$2() {
        return this.logSuffix();
    }

    public File copy$default$1() {
        return this.directory();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        String string;
        String logSuffix$1;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof RecordLog)) return false;
        RecordLog recordLog = (RecordLog)object2;
        File file = recordLog.directory();
        File directory$1 = file;
        if (!this.gd3$1(directory$1, logSuffix$1 = (string = recordLog.logSuffix()))) return false;
        boolean bl = ((RecordLog)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String productPrefix() {
        return "RecordLog";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            case 0: {
                object = this.directory();
                break;
            }
            case 1: {
                object = this.logSuffix();
            }
        }
        return object;
    }

    public boolean canEqual(Object object) {
        return object instanceof RecordLog;
    }

    private final long liftedTree1$1(LogInfo logInfo, LogReader logReader) {
        long exceptionResult2 = 0L;
        try {
            long actualLength = logReader.verifyAndGetEndPosition();
            long x$5 = actualLength - logInfo.position();
            File x$6 = logInfo.copy$default$1();
            long x$7 = logInfo.copy$default$2();
            LogInfo updated$1 = logInfo.copy(x$6, x$7, x$5);
            this.log_infos().put(BoxesRunTime.boxToLong((long)updated$1.position()), updated$1);
            Object object = updated$1.file().length() != logInfo.length() ? FileSupport$.MODULE$.using(new RandomAccessFile(logInfo.file(), "rw"), new Serializable(this, updated$1){
                public static final long serialVersionUID;
                private final LogInfo updated$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(RandomAccessFile randomAccessFile) {
                    randomAccessFile.setLength(this.updated$1.length());
                }
                {
                    this.updated$1 = logInfo;
                }
            }) : BoxedUnit.UNIT;
            exceptionResult2 = actualLength;
            return exceptionResult2;
        }
        finally {
            logReader.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gd3$1(File file, String string) {
        File file2 = file;
        File file3 = this.directory();
        if (file2 == null) {
            if (file3 != null) {
                return false;
            }
        } else if (!((Object)file2).equals(file3)) return false;
        String string2 = string;
        String string3 = this.logSuffix();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    public RecordLog(File directory, String logSuffix) {
        this.directory = directory;
        this.logSuffix = logSuffix;
        Product.class.$init$((Product)this);
        directory.mkdirs();
        this.logSize = 0x6400000L;
        this.verify_checksums = false;
        this.sync = false;
        this.log_infos = new TreeMap();
        this.max_log_write_latency = new TimeMetric();
        this.max_log_flush_latency = new TimeMetric();
        this.max_log_rotate_latency = new TimeMetric();
        this.on_log_rotate = new $anonfun$1(this);
        this.org$fusesource$mq$leveldb$RecordLog$$reader_cache = new $anon$1(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogInfo
    implements ScalaObject,
    Product,
    Serializable {
        private final File file;
        private final long position;
        private final long length;

        public File file() {
            return this.file;
        }

        public long position() {
            return this.position;
        }

        public long length() {
            return this.length;
        }

        public long limit() {
            return this.position() + this.length();
        }

        public long copy$default$3() {
            return this.length();
        }

        public long copy$default$2() {
            return this.position();
        }

        public File copy$default$1() {
            return this.file();
        }

        public LogInfo copy(File file, long position, long length) {
            return new LogInfo(file, position, length);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long l;
            long length$1;
            long l2;
            long position$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof LogInfo)) return false;
            LogInfo logInfo = (LogInfo)object2;
            File file = logInfo.file();
            File file$1 = file;
            if (!this.gd1$1(file$1, position$1 = (l2 = logInfo.position()), length$1 = (l = logInfo.length()))) return false;
            boolean bl = ((LogInfo)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "LogInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int n) {
            Comparable<File> comparable;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    comparable = this.file();
                    break;
                }
                case 2: {
                    comparable = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToLong((long)this.position());
                }
            }
            return comparable;
        }

        public boolean canEqual(Object object) {
            return object instanceof LogInfo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(File file, long l, long l2) {
            File file2 = file;
            File file3 = this.file();
            if (file2 == null) {
                if (file3 != null) {
                    return false;
                }
            } else if (!((Object)file2).equals(file3)) return false;
            if (l != this.position()) return false;
            if (l2 != this.length()) return false;
            return true;
        }

        public LogInfo(File file, long position, long length) {
            this.file = file;
            this.position = position;
            this.length = length;
            Product.class.$init$((Product)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogReader
    extends BaseRetained
    implements ScalaObject,
    Product,
    Serializable {
        private final File file;
        private final long position;
        private final RandomAccessFile fd;
        private final FileChannel channel;
        public final RecordLog $outer;

        public File file() {
            return this.file;
        }

        public long position() {
            return this.position;
        }

        public RandomAccessFile open() {
            return new RandomAccessFile(this.file(), "r");
        }

        public RandomAccessFile fd() {
            return this.fd;
        }

        public FileChannel channel() {
            return this.channel;
        }

        public void dispose() {
            this.fd().close();
        }

        public void check_read_flush(long end_offset) {
        }

        public Buffer read(long record_position, int length$3) {
            Buffer buffer;
            long offset$1 = record_position - this.position();
            if (RecordLog$.MODULE$.$enable_assertions()) {
                Predef$.MODULE$.assert(offset$1 >= 0L);
            }
            this.check_read_flush(offset$1 + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length$3);
            if (this.org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer().verify_checksums()) {
                Buffer record$1 = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE() + length$3);
                if (this.channel().read(record$1.toByteBuffer(), offset$1) != record$1.length) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1));
                    }
                    throw new IOException(new StringBuilder().append((Object)"short record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                DataByteArrayInputStream is = new DataByteArrayInputStream(record$1);
                byte prefix = is.readByte();
                if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1));
                    }
                    throw new IOException(new StringBuilder().append((Object)"invalid record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                byte id = is.readByte();
                int expectedChecksum = is.readInt();
                int expectedLength = is.readInt();
                Buffer data = is.readBuffer(length$3);
                if (expectedLength == length$3 && expectedChecksum != this.org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer().checksum(data)) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1));
                    }
                    throw new IOException(new StringBuilder().append((Object)"checksum does not match at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                buffer = data;
            } else {
                Buffer data = new Buffer(length$3);
                if (this.channel().read(data.toByteBuffer(), offset$1 + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE()) != data.length) {
                    throw new IOException(new StringBuilder().append((Object)"short record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                buffer = data;
            }
            return buffer;
        }

        public Tuple3<Object, Buffer, Object> read(long record_position) {
            long offset = record_position - this.position();
            Buffer header = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE());
            this.channel().read(header.toByteBuffer(), offset);
            BufferEditor is = header.bigEndianEditor();
            byte prefix = is.readByte();
            if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                throw new IOException("invalid record position");
            }
            byte id = is.readByte();
            int expectedChecksum = is.readInt();
            int length = is.readInt();
            Buffer data = new Buffer(length);
            if (this.channel().read(data.toByteBuffer(), offset + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE()) != length) {
                throw new IOException("short record");
            }
            if (this.org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer().verify_checksums() && expectedChecksum != this.org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer().checksum(data)) {
                throw new IOException("checksum does not match");
            }
            return new Tuple3((Object)BoxesRunTime.boxToByte((byte)id), (Object)data, (Object)BoxesRunTime.boxToLong((long)(record_position + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length)));
        }

        public Option<Tuple2<Object, Option<Object>>> check(long record_position) {
            int chunkSize;
            long offset = record_position - this.position();
            Buffer header = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE());
            this.channel().read(header.toByteBuffer(), offset);
            BufferEditor is = header.bigEndianEditor();
            byte prefix = is.readByte();
            if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                return None$.MODULE$;
            }
            byte kind = is.readByte();
            int expectedChecksum = is.readInt();
            int length = is.readInt();
            Buffer chunk = new Buffer(4096);
            ByteBuffer chunkbb = chunk.toByteBuffer();
            offset += (long)RecordLog$.MODULE$.LOG_HEADER_SIZE();
            CRC32 checksumer = new CRC32();
            for (int remaining = length; remaining > 0; remaining -= chunkSize) {
                chunkSize = Predef$.MODULE$.intWrapper(remaining).min(4096);
                chunkbb.position(0);
                chunkbb.limit(chunkSize);
                this.channel().read(chunkbb, offset);
                if (chunkbb.hasRemaining()) {
                    return None$.MODULE$;
                }
                checksumer.update(chunk.data, 0, chunkSize);
                offset += (long)chunkSize;
            }
            int checksum = (int)(checksumer.getValue() & 0xFFFFFFFFFFFFFFFFL);
            if (expectedChecksum != checksum) {
                return None$.MODULE$;
            }
            None$ uow_start_pos = kind == RecordLog$.MODULE$.UOW_END_RECORD() && length == 8 ? new Some((Object)BoxesRunTime.boxToLong((long)RecordLog$.MODULE$.decode_long(chunk))) : None$.MODULE$;
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)(record_position + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length)), (Object)uow_start_pos));
        }

        public long verifyAndGetEndPosition() {
            Object object = new Object();
            long exceptionResult3 = 0L;
            try {
                long pos = this.position();
                LongRef current_uow_start$1 = new LongRef(pos);
                long limit = this.position() + this.channel().size();
                while (pos < limit) {
                    Option<Tuple2<Object, Option<Object>>> option = this.check(pos);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Tuple2 tuple2 = (Tuple2)some.x();
                        if (tuple2 != null) {
                            long l;
                            long next$1 = l = BoxesRunTime.unboxToLong((Object)tuple2._1());
                            ((Option)tuple2._2()).foreach((Function1)new Serializable(this, current_uow_start$1, next$1, object){
                                public static final long serialVersionUID;
                                private final LongRef current_uow_start$1;
                                private final long next$1;
                                private final Object nonLocalReturnKey1$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(long uow_start_pos) {
                                    this.apply$mcVJ$sp(uow_start_pos);
                                }

                                public void apply$mcVJ$sp(long v1) {
                                    if (v1 == this.current_uow_start$1.elem) {
                                        this.current_uow_start$1.elem = this.next$1;
                                        return;
                                    }
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToLong((long)this.current_uow_start$1.elem));
                                }
                                {
                                    this.current_uow_start$1 = longRef;
                                    this.next$1 = l;
                                    this.nonLocalReturnKey1$1 = object;
                                }
                            });
                            pos = next$1;
                            continue;
                        }
                        throw new MatchError(option);
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Tuple2<Object, Option<Object>>> option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        return current_uow_start$1.elem;
                    }
                    throw new MatchError(option);
                }
                return current_uow_start$1.elem;
            }
            catch (NonLocalReturnControl nonLocalReturnControl) {
                if (nonLocalReturnControl.key() == object) {
                    exceptionResult3 = BoxesRunTime.unboxToLong((Object)nonLocalReturnControl.value());
                    return exceptionResult3;
                }
                throw nonLocalReturnControl;
            }
        }

        public LogReader copy(File file, long position) {
            return new LogReader(this.org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer(), file, position);
        }

        public long copy$default$2() {
            return this.position();
        }

        public File copy$default$1() {
            return this.file();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long l;
            long position$2;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof LogReader)) return false;
            if (((LogReader)((Object)object2)).org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer() != this.org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer()) return false;
            LogReader logReader = (LogReader)((Object)object2);
            File file = logReader.file();
            File file$2 = file;
            if (!this.gd2$1(file$2, position$2 = (l = logReader.position()))) return false;
            boolean bl = ((LogReader)((Object)object)).canEqual((Object)this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "LogReader";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            Comparable<File> comparable;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    comparable = this.file();
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToLong((long)this.position());
                }
            }
            return comparable;
        }

        public boolean canEqual(Object object) {
            return object instanceof LogReader;
        }

        public RecordLog org$fusesource$mq$leveldb$RecordLog$LogReader$$$outer() {
            return this.$outer;
        }

        private final boolean record_is_not_changing$1(int n, long l, Buffer buffer) {
            return BoxesRunTime.unboxToBoolean(FileSupport$.MODULE$.using(this.open(), new Serializable(this, n, l, buffer){
                public static final long serialVersionUID;
                private final int length$3;
                private final long offset$1;
                private final Buffer record$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(RandomAccessFile fd) {
                    FileChannel channel = fd.getChannel();
                    Buffer new_record = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE() + this.length$3);
                    channel.read(new_record.toByteBuffer(), this.offset$1);
                    Buffer buffer = this.record$1;
                    Buffer buffer2 = new_record;
                    boolean same = !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
                    Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)same));
                    return same;
                }
                {
                    this.length$3 = n;
                    this.offset$1 = l;
                    this.record$1 = buffer;
                }
            }));
        }

        private final boolean gd2$1(File file, long l) {
            File file2 = file;
            File file3 = this.file();
            return !(file2 != null ? !((Object)file2).equals(file3) : file3 != null) && l == this.position();
        }

        public LogReader(RecordLog $outer, File file, long position) {
            this.file = file;
            this.position = position;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
            this.fd = this.open();
            this.channel = this.fd().getChannel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogAppender
    extends LogReader
    implements ScalaObject {
        private final LogInfo info = new LogInfo(super.file(), super.position(), 0L);
        private long append_offset = 0L;
        private final AtomicLong flushed_offset = new AtomicLong(0L);
        private final DataByteArrayOutputStream write_buffer;

        public LogInfo info() {
            return this.info;
        }

        @Override
        public RandomAccessFile open() {
            return new RandomAccessFile(super.file(), "rw");
        }

        @Override
        public void dispose() {
            this.force();
            super.dispose();
        }

        public long append_offset() {
            return this.append_offset;
        }

        public void append_offset_$eq(long l) {
            this.append_offset = l;
        }

        public AtomicLong flushed_offset() {
            return this.flushed_offset;
        }

        public long append_position() {
            return super.position() + this.append_offset();
        }

        public DataByteArrayOutputStream write_buffer() {
            return this.write_buffer;
        }

        public void force() {
            this.flush();
            if (this.org$fusesource$mq$leveldb$RecordLog$LogAppender$$$outer().sync()) {
                this.org$fusesource$mq$leveldb$RecordLog$LogAppender$$$outer().max_log_flush_latency().apply(new Serializable(this){
                    public static final long serialVersionUID;
                    private final LogAppender $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.channel().force(this.$outer.append_offset() > this.$outer.org$fusesource$mq$leveldb$RecordLog$LogAppender$$$outer().logSize());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }

        public Tuple2<Object, LogInfo> append(byte id, Buffer data) {
            LogAppender logAppender = this;
            synchronized (logAppender) {
                long record_position = this.append_position();
                int data_length = data.length;
                int total_length = RecordLog$.MODULE$.LOG_HEADER_SIZE() + data_length;
                if (this.write_buffer().position() + total_length > RecordLog$.MODULE$.BUFFER_SIZE()) {
                    this.flush();
                }
                int cs = this.org$fusesource$mq$leveldb$RecordLog$LogAppender$$$outer().checksum(data);
                if (false && total_length > RecordLog$.MODULE$.BYPASS_BUFFER_SIZE()) {
                    this.write_buffer().writeByte((int)RecordLog$.MODULE$.LOG_HEADER_PREFIX());
                    this.write_buffer().writeByte((int)id);
                    this.write_buffer().writeInt(cs);
                    this.write_buffer().writeInt(data_length);
                    this.append_offset_$eq(this.append_offset() + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE());
                    this.flush();
                    ByteBuffer buffer = data.toByteBuffer();
                    long pos = this.append_offset() + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE();
                    this.flushed_offset().addAndGet(buffer.remaining());
                    this.channel().write(buffer, pos);
                    if (buffer.hasRemaining()) {
                        throw new IOException("Short write");
                    }
                    this.append_offset_$eq(this.append_offset() + (long)data_length);
                } else {
                    this.write_buffer().writeByte((int)RecordLog$.MODULE$.LOG_HEADER_PREFIX());
                    this.write_buffer().writeByte((int)id);
                    this.write_buffer().writeInt(cs);
                    this.write_buffer().writeInt(data_length);
                    this.write_buffer().write(data.data, data.offset, data_length);
                    this.append_offset_$eq(this.append_offset() + (long)total_length);
                }
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)record_position), (Object)this.info());
                return tuple2;
            }
        }

        public void flush() {
            this.org$fusesource$mq$leveldb$RecordLog$LogAppender$$$outer().max_log_flush_latency().apply(new Serializable(this){
                public static final long serialVersionUID;
                private final LogAppender $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    LogAppender logAppender = this.$outer;
                    synchronized (logAppender) {
                        BoxedUnit boxedUnit;
                        if (this.$outer.write_buffer().position() > 0) {
                            ByteBuffer buffer = this.$outer.write_buffer().toBuffer().toByteBuffer();
                            long pos = this.$outer.append_offset() - (long)buffer.remaining();
                            this.$outer.flushed_offset().addAndGet(buffer.remaining());
                            this.$outer.channel().write(buffer, pos);
                            if (buffer.hasRemaining()) {
                                throw new IOException("Short write");
                            }
                            this.$outer.write_buffer().reset();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        @Override
        public void check_read_flush(long end_offset) {
            if (this.flushed_offset().get() < end_offset) {
                this.flush();
            }
        }

        public RecordLog org$fusesource$mq$leveldb$RecordLog$LogAppender$$$outer() {
            return this.$outer;
        }

        public LogAppender(RecordLog $outer, File file, long position) {
            super($outer, file, position);
            this.channel().position($outer.logSize() - 1L);
            this.channel().write(new Buffer(1).toByteBuffer());
            this.channel().force(true);
            Object object = $outer.sync() ? this.channel().position(0L) : BoxedUnit.UNIT;
            this.write_buffer = new DataByteArrayOutputStream(RecordLog$.MODULE$.BUFFER_SIZE() + RecordLog$.MODULE$.LOG_HEADER_SIZE());
        }
    }
}

