/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.service;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.realm.JDBCRealm;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EmbeddedTomcat
implements ApplicationContextAware {
    public static Log log = LogFactory.getLog(EmbeddedTomcat.class);
    private static final String DEFAULT_ENGINE = "default";
    private static final String DEFAULT_HOST = "localhost";
    private static final String WEB_APPS_NAME = "webapps";
    private static final String DOC_BASE = "ROOT";
    private ApplicationContext ctx = null;
    private Embedded embedded;
    private String catalinaHome;

    public EmbeddedTomcat() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                EmbeddedTomcat.this.stopServer();
            }
        });
    }

    public void startServer() throws Exception {
        this.embedded.start();
    }

    public void stopServer() {
        if (this.embedded != null) {
            try {
                log.info((Object)"Shutting down embedded tomcat...");
                this.embedded.stop();
                log.info((Object)"Embedded tomcat shutdown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void init() throws Exception {
        File home = new File("..").getCanonicalFile();
        this.catalinaHome = home.getAbsolutePath();
        this.embedded = new Embedded();
        this.embedded.setCatalinaHome(this.catalinaHome);
        Engine engine = this.embedded.createEngine();
        engine.setName(DEFAULT_ENGINE);
        engine.setDefaultHost(DEFAULT_HOST);
        this.embedded.addEngine(engine);
        File webAppsLocation = new File(home, WEB_APPS_NAME);
        Host host = this.embedded.createHost(DEFAULT_HOST, webAppsLocation.getAbsolutePath());
        engine.addChild((Container)host);
        File docBase = new File(webAppsLocation, DOC_BASE);
        Context context = this.createContext("", docBase.getAbsolutePath());
        host.addChild((Container)context);
        String config_file_name = (String)this.ctx.getBean("configPropsFileName");
        log.debug((Object)("Attempting to load properties from " + config_file_name));
        Properties props = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(config_file_name);
            props.load(is);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.debug((Object)("Web Context Props : " + props));
        Context or_context = this.createContext("/jzkit", webAppsLocation.getAbsolutePath() + "/jzkit");
        for (String string : props.keySet()) {
            log.debug((Object)("Setting " + string + " to " + props.getProperty(string)));
            this.setContextParam(or_context, string, props.getProperty(string));
        }
        String prop_driver = props.getProperty("org.jzkit.jdbc_driver");
        String string = props.getProperty("org.jzkit.url");
        String prop_jdbc_user = props.getProperty("org.jzkit.username");
        String prop_jdbc_pass = props.getProperty("org.jzkit.password");
        JDBCRealm jdbc_realm = new JDBCRealm();
        jdbc_realm.setDriverName(prop_driver);
        jdbc_realm.setConnectionURL(string);
        jdbc_realm.setConnectionName(prop_jdbc_user);
        jdbc_realm.setConnectionPassword(prop_jdbc_pass);
        jdbc_realm.setUserTable("IDENT_AUTH_DETAILS");
        jdbc_realm.setUserNameCol("USERNAME");
        jdbc_realm.setUserCredCol("PASSWORD");
        jdbc_realm.setUserRoleTable("TC_ROLES");
        jdbc_realm.setRoleNameCol("ROLE");
        or_context.setRealm((Realm)jdbc_realm);
        host.addChild((Container)or_context);
        Connector connector = this.embedded.createConnector((String)null, 8080, false);
        this.embedded.addConnector(connector);
        this.startServer();
    }

    private Context createContext(String path, String docBase) {
        Context context = this.embedded.createContext(path, docBase);
        context.setParentClassLoader(this.getClass().getClassLoader());
        Wrapper servlet = context.createWrapper();
        servlet.setName(DEFAULT_ENGINE);
        servlet.setServletClass("org.apache.catalina.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.addInitParameter("debug", "0");
        servlet.addInitParameter("listings", "false");
        context.addChild((Container)servlet);
        context.addServletMapping("/", DEFAULT_ENGINE);
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass("org.apache.jasper.servlet.JspServlet");
        jspServlet.addInitParameter("fork", "false");
        jspServlet.addInitParameter("xpoweredBy", "false");
        jspServlet.setLoadOnStartup(2);
        context.addChild((Container)jspServlet);
        context.addServletMapping("*.jsp", "jsp");
        context.addServletMapping("*.jspx", "jsp");
        context.addWelcomeFile("index.html");
        context.addWelcomeFile("index.htm");
        context.addWelcomeFile("index.jsp");
        context.setSessionTimeout(30);
        context.addMimeMapping("html", "text/html");
        context.addMimeMapping("htm", "text/html");
        context.addMimeMapping("gif", "image/gif");
        context.addMimeMapping("jpg", "image/jpeg");
        context.addMimeMapping("png", "image/png");
        context.addMimeMapping("js", "text/javascript");
        context.addMimeMapping("css", "text/css");
        context.addMimeMapping("pdf", "application/pdf");
        return context;
    }

    private void setContextParam(Context ctx, String name, String value) {
        ApplicationParameter param = new ApplicationParameter();
        param.setName(name);
        param.setValue(value);
        ctx.addApplicationParameter(param);
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }
}

