/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotatedCodeElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.AnnotationTypeMatcher;
import net.bytebuddy.matcher.BooleanMatcher;
import net.bytebuddy.matcher.ClassLoaderHierarchyMatcher;
import net.bytebuddy.matcher.ClassLoaderParentMatcher;
import net.bytebuddy.matcher.CollectionItemMatcher;
import net.bytebuddy.matcher.CollectionOneToOneMatcher;
import net.bytebuddy.matcher.CollectionSizeMatcher;
import net.bytebuddy.matcher.DeclaringAnnotationMatcher;
import net.bytebuddy.matcher.DeclaringFieldMatcher;
import net.bytebuddy.matcher.DeclaringMethodMatcher;
import net.bytebuddy.matcher.DeclaringTypeMatcher;
import net.bytebuddy.matcher.DescriptorMatcher;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.EqualityMatcher;
import net.bytebuddy.matcher.InheritedAnnotationMatcher;
import net.bytebuddy.matcher.MethodExceptionTypeMatcher;
import net.bytebuddy.matcher.MethodParameterMatcher;
import net.bytebuddy.matcher.MethodParameterTypeMatcher;
import net.bytebuddy.matcher.MethodReturnTypeMatcher;
import net.bytebuddy.matcher.MethodSortMatcher;
import net.bytebuddy.matcher.ModifierMatcher;
import net.bytebuddy.matcher.NameMatcher;
import net.bytebuddy.matcher.NegatingMatcher;
import net.bytebuddy.matcher.NullMatcher;
import net.bytebuddy.matcher.StringMatcher;
import net.bytebuddy.matcher.SubTypeMatcher;
import net.bytebuddy.matcher.SuperTypeMatcher;
import net.bytebuddy.matcher.VisibilityMatcher;
import net.bytebuddy.utility.ByteBuddyCommons;

public final class ElementMatchers {
    private ElementMatchers() {
        throw new UnsupportedOperationException();
    }

    public static <T> ElementMatcher.Junction<T> is(Object value) {
        return value == null ? new NullMatcher() : new EqualityMatcher(value);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Method method) {
        return ElementMatchers.is(new MethodDescription.ForLoadedMethod(ByteBuddyCommons.nonNull(method)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Constructor<?> constructor) {
        return ElementMatchers.is(new MethodDescription.ForLoadedConstructor(ByteBuddyCommons.nonNull(constructor)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(MethodDescription methodDescription) {
        return new EqualityMatcher(ByteBuddyCommons.nonNull(methodDescription));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> is(Class<?> type) {
        return ElementMatchers.is(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> is(TypeDescription typeDescription) {
        return new EqualityMatcher(ByteBuddyCommons.nonNull(typeDescription));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> is(Annotation annotation) {
        return ElementMatchers.is(AnnotationDescription.ForLoadedAnnotation.of(ByteBuddyCommons.nonNull(annotation)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> is(AnnotationDescription annotationDescription) {
        return new EqualityMatcher(ByteBuddyCommons.nonNull(annotationDescription));
    }

    public static <T> ElementMatcher.Junction<T> not(ElementMatcher<? super T> matcher) {
        return new NegatingMatcher<T>(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T> ElementMatcher.Junction<T> any() {
        return new BooleanMatcher(true);
    }

    public static <T> ElementMatcher.Junction<T> none() {
        return new BooleanMatcher(false);
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Object ... value) {
        return ElementMatchers.anyOf(Arrays.asList(ByteBuddyCommons.nonNull(value)));
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Iterable<?> values) {
        ElementMatcher.Junction<T> matcher = ElementMatchers.none();
        for (Object value : values) {
            matcher = matcher.or(ElementMatchers.is(value));
        }
        return matcher;
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> anyOf(Class<?> ... value) {
        return ElementMatchers.anyOf(new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Constructor<?> ... value) {
        return ElementMatchers.anyOf(new MethodList.ForLoadedType(ByteBuddyCommons.nonNull(value), new Method[0]));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Method ... value) {
        return ElementMatchers.anyOf(new MethodList.ForLoadedType(new Constructor[0], ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> anyOf(Annotation ... value) {
        return ElementMatchers.anyOf(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(value)));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Object ... value) {
        return ElementMatchers.noneOf(Arrays.asList(value));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Iterable<?> values) {
        ElementMatcher.Junction<T> matcher = ElementMatchers.any();
        for (Object value : values) {
            matcher = matcher.and(ElementMatchers.not(ElementMatchers.is(value)));
        }
        return matcher;
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> noneOf(Class<?> ... value) {
        return ElementMatchers.noneOf(new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Constructor<?> ... value) {
        return ElementMatchers.noneOf(new MethodList.ForLoadedType(ByteBuddyCommons.nonNull(value), new Method[0]));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Method ... value) {
        return ElementMatchers.noneOf(new MethodList.ForLoadedType(new Constructor[0], ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> noneOf(Annotation ... value) {
        return ElementMatchers.noneOf(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(value)));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> named(String name) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(name), StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedIgnoreCase(String name) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(name), StringMatcher.Mode.EQUALS_FULLY_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWith(String prefix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(prefix), StringMatcher.Mode.STARTS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWithIgnoreCase(String prefix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(prefix), StringMatcher.Mode.STARTS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWith(String suffix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(suffix), StringMatcher.Mode.ENDS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWithIgnoreCase(String suffix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(suffix), StringMatcher.Mode.ENDS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContains(String infix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(infix), StringMatcher.Mode.CONTAINS));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContainsIgnoreCase(String infix) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(infix), StringMatcher.Mode.CONTAINS_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameMatches(String regex) {
        return new NameMatcher(new StringMatcher(ByteBuddyCommons.nonNull(regex), StringMatcher.Mode.MATCHES));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> hasDescriptor(String descriptor) {
        return new DescriptorMatcher(new StringMatcher(descriptor, StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(TypeDescription type) {
        return ElementMatchers.isDeclaredBy(ElementMatchers.is(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(Class<?> type) {
        return ElementMatchers.isDeclaredBy(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(ElementMatcher<? super TypeDescription> matcher) {
        return new DeclaringTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(Class<?> type) {
        return ElementMatchers.isVisibleTo(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(TypeDescription typeDescription) {
        return new VisibilityMatcher(typeDescription);
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> isAnnotatedWith(Class<? extends Annotation> type) {
        return ElementMatchers.isAnnotatedWith(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> isAnnotatedWith(TypeDescription typeDescription) {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.is(ByteBuddyCommons.isAnnotation(typeDescription)));
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> isAnnotatedWith(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.declaresAnnotation(new AnnotationTypeMatcher(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends AnnotatedCodeElement> ElementMatcher.Junction<T> declaresAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        return new DeclaringAnnotationMatcher(new CollectionItemMatcher<AnnotationDescription>(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isPublic() {
        return new ModifierMatcher(ModifierMatcher.Mode.PUBLIC);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isProtected() {
        return new ModifierMatcher(ModifierMatcher.Mode.PROTECTED);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isPackagePrivate() {
        return ElementMatchers.not(ElementMatchers.isPublic().or(ElementMatchers.<T>isProtected()).or(ElementMatchers.<T>isPrivate()));
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isPrivate() {
        return new ModifierMatcher(ModifierMatcher.Mode.PRIVATE);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isFinal() {
        return new ModifierMatcher(ModifierMatcher.Mode.FINAL);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isStatic() {
        return new ModifierMatcher(ModifierMatcher.Mode.STATIC);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isSynthetic() {
        return new ModifierMatcher(ModifierMatcher.Mode.SYNTHETIC);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSynchronized() {
        return new ModifierMatcher(ModifierMatcher.Mode.SYNCHRONIZED);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isNative() {
        return new ModifierMatcher(ModifierMatcher.Mode.NATIVE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isStrict() {
        return new ModifierMatcher(ModifierMatcher.Mode.STRICT);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isVarArgs() {
        return new ModifierMatcher(ModifierMatcher.Mode.VAR_ARGS);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isBridge() {
        return new ModifierMatcher(ModifierMatcher.Mode.BRIDGE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(Class<?> type) {
        return ElementMatchers.returns(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(TypeDescription typeDescription) {
        return ElementMatchers.returns(ElementMatchers.is(ByteBuddyCommons.nonNull(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(ElementMatcher<? super TypeDescription> matcher) {
        return new MethodReturnTypeMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Class<?> ... type) {
        TypeDescription[] typeDescription = new TypeDescription[type.length];
        int index = 0;
        for (Class<?> aType : type) {
            typeDescription[index++] = new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(aType));
        }
        return ElementMatchers.takesArguments(typeDescription);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(TypeDescription ... typeDescription) {
        return ElementMatchers.takesArguments(Arrays.asList(typeDescription));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Iterable<? extends TypeDescription> typeDescriptions) {
        LinkedList<ElementMatcher.Junction<T>> typeMatchers = new LinkedList<ElementMatcher.Junction<T>>();
        for (TypeDescription typeDescription : typeDescriptions) {
            typeMatchers.add(ElementMatchers.is(ByteBuddyCommons.nonVoid(typeDescription)));
        }
        return ElementMatchers.takesArguments(new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(ElementMatcher<? super Iterable<? extends TypeDescription>> matchers) {
        return new MethodParameterMatcher(new MethodParameterTypeMatcher(ByteBuddyCommons.nonNull(matchers)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(int length) {
        return new MethodParameterMatcher(new CollectionSizeMatcher(length));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasParameter(ElementMatcher<? super ParameterDescription> matcher) {
        return ElementMatchers.hasParameters(new CollectionItemMatcher<ParameterDescription>(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasParameters(ElementMatcher<? super Iterable<? extends ParameterDescription>> matcher) {
        return new MethodParameterMatcher(matcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.canThrow(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(exceptionType)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(TypeDescription exceptionType) {
        if (exceptionType.isAssignableTo(Throwable.class)) {
            return exceptionType.isAssignableTo(RuntimeException.class) || exceptionType.isAssignableTo(Error.class) ? new BooleanMatcher(true) : ElementMatchers.throwing(new CollectionItemMatcher(new SubTypeMatcher(exceptionType)));
        }
        throw new IllegalArgumentException(exceptionType + " is not an exception type");
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> throwing(ElementMatcher<? super List<? extends TypeDescription>> exceptionMatcher) {
        return new MethodExceptionTypeMatcher(exceptionMatcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMethod() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isConstructor() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.CONSTRUCTOR);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isTypeInitializer() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.TYPE_INITIALIZER);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isVisibilityBridge() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.VISIBILITY_BRIDGE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverridable() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.OVERRIDABLE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultMethod() {
        return new MethodSortMatcher(MethodSortMatcher.Sort.DEFAULT_METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultConstructor() {
        return ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultFinalizer() {
        return ElementMatchers.isFinalizer().and(ElementMatchers.isDeclaredBy(Object.class));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isFinalizer() {
        return ElementMatchers.named("finalize").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(Void.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isHashCode() {
        return ElementMatchers.named("hashCode").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(Integer.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isEquals() {
        return ElementMatchers.named("equals").and(ElementMatchers.takesArguments(Object.class)).and(ElementMatchers.returns(Boolean.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isClone() {
        return ElementMatchers.named("clone").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(Object.class));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isToString() {
        return ElementMatchers.named("toString").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(String.class));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter() {
        return ElementMatchers.nameStartsWith("set").and(ElementMatchers.takesArguments(1)).and(ElementMatchers.returns(Void.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(Class<?> type) {
        return ElementMatchers.isSetter(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(TypeDescription typeDescription) {
        return ElementMatchers.isSetter(ElementMatchers.is(ByteBuddyCommons.nonVoid(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isSetter().and(ElementMatchers.takesArguments(new CollectionOneToOneMatcher<TypeDescription>(Collections.singletonList(ByteBuddyCommons.nonNull(matcher)))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter() {
        return ElementMatchers.takesArguments(0).and(ElementMatchers.not(ElementMatchers.returns(Void.TYPE))).and(ElementMatchers.nameStartsWith("get").or(ElementMatchers.nameStartsWith("is").and(ElementMatchers.returns(ElementMatchers.anyOf(Boolean.TYPE, Boolean.class)))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(Class<?> type) {
        return ElementMatchers.isGetter(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(TypeDescription typeDescription) {
        return ElementMatchers.isGetter(ElementMatchers.is(ByteBuddyCommons.nonVoid(typeDescription)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isGetter().and(ElementMatchers.returns(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSpecializationOf(MethodDescription methodDescription) {
        TypeList parameterTypes = methodDescription.getParameters().asTypeList();
        ArrayList<ElementMatcher.Junction<T>> matchers = new ArrayList<ElementMatcher.Junction<T>>(parameterTypes.size());
        for (TypeDescription typeDescription : parameterTypes) {
            matchers.add(ElementMatchers.isSubTypeOf(typeDescription));
        }
        return (methodDescription.isStatic() ? ElementMatchers.isStatic() : ElementMatchers.not(ElementMatchers.<T>isStatic())).and(ElementMatchers.named(methodDescription.getSourceCodeName())).and(ElementMatchers.returns(ElementMatchers.isSubTypeOf(methodDescription.getReturnType()))).and(ElementMatchers.takesArguments(new CollectionOneToOneMatcher(matchers)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(Class<?> type) {
        return ElementMatchers.isSubTypeOf(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(TypeDescription typeDescription) {
        return new SubTypeMatcher(ByteBuddyCommons.nonNull(typeDescription));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(Class<?> type) {
        return ElementMatchers.isSuperTypeOf(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(TypeDescription typeDescription) {
        return new SuperTypeMatcher(ByteBuddyCommons.nonNull(typeDescription));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(Class<?> type) {
        return ElementMatchers.inheritsAnnotation(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(TypeDescription typeDescription) {
        return ElementMatchers.inheritsAnnotation(ElementMatchers.is(typeDescription));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasAnnotation(new AnnotationTypeMatcher(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        return new InheritedAnnotationMatcher(new CollectionItemMatcher<AnnotationDescription>(ByteBuddyCommons.nonNull(matcher)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> declaresField(ElementMatcher<? super FieldDescription> fieldMatcher) {
        return new DeclaringFieldMatcher(new CollectionItemMatcher<FieldDescription>(ByteBuddyCommons.nonNull(fieldMatcher)));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> declaresMethod(ElementMatcher<? super MethodDescription> methodMatcher) {
        return new DeclaringMethodMatcher(new CollectionItemMatcher<MethodDescription>(ByteBuddyCommons.nonNull(methodMatcher)));
    }

    public static <T extends ClassLoader> ElementMatcher<T> isBootstrapClassLoader() {
        return new NullMatcher();
    }

    public static <T extends ClassLoader> ElementMatcher<T> isSystemClassLoader() {
        return new EqualityMatcher(ClassLoader.getSystemClassLoader());
    }

    public static <T extends ClassLoader> ElementMatcher<T> isExtensionClassLoader() {
        return new EqualityMatcher(ClassLoader.getSystemClassLoader().getParent());
    }

    public static <T extends ClassLoader> ElementMatcher<T> isChildOf(ClassLoader classLoader) {
        return classLoader == null ? new BooleanMatcher(true) : ElementMatchers.hasChild(ElementMatchers.is(classLoader));
    }

    public static <T extends ClassLoader> ElementMatcher<T> hasChild(ElementMatcher<? super ClassLoader> matcher) {
        return new ClassLoaderHierarchyMatcher(ByteBuddyCommons.nonNull(matcher));
    }

    public static <T extends ClassLoader> ElementMatcher<T> isParentOf(ClassLoader classLoader) {
        return classLoader == null ? ElementMatchers.isBootstrapClassLoader() : new ClassLoaderParentMatcher(classLoader);
    }
}

