/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.readers.ServiceInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerInfoCache<T extends ServiceInfo> {
    private final Map<URI, T> cache = Collections.synchronizedMap(new HashMap());
    private final ServiceInfoLoader<T> loader;

    public ServerInfoCache(ServiceInfoLoader loader) {
        this.loader = loader;
    }

    public synchronized void clearCache() {
        this.cache.clear();
    }

    public final synchronized T getInfo(URI uri, RenderingContext context) {
        ServiceInfo result = (ServiceInfo)this.cache.get(uri);
        if (result == null) {
            try {
                result = this.requestInfo(uri, context);
            }
            catch (Exception e) {
                this.loader.logger().info((Object)("Error while getting capabilities for " + uri + ". The print module will assume it's a standard WMS."));
                String stackTrace = "";
                for (StackTraceElement el : e.getStackTrace()) {
                    stackTrace = stackTrace + el.toString() + "\n";
                }
                this.loader.logger().info((Object)stackTrace);
                result = this.loader.createNewErrorResult();
            }
            if (this.loader.logger().isDebugEnabled()) {
                this.loader.logger().debug((Object)("GetCapabilities " + uri + ": " + result));
            }
            this.cache.put(uri, result);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T requestInfo(URI baseUrl, RenderingContext context) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        URL url = this.loader.createURL(baseUrl, context);
        GetMethod method = null;
        MetricRegistry registry = context.getConfig().getMetricRegistry();
        Timer.Context timer = registry.timer("http_" + url.getAuthority()).time();
        try {
            T result;
            InputStream stream;
            if ((url.getProtocol().equals("http") || url.getProtocol().equals("https")) && context.getConfig().localHostForwardIsFrom(url.getHost())) {
                String scheme = url.getProtocol();
                String host = url.getHost();
                if (url.getProtocol().equals("https") && context.getConfig().localHostForwardIsHttps2http()) {
                    scheme = "http";
                }
                URL localUrl = new URL(scheme, "localhost", url.getPort(), url.getFile());
                HttpURLConnection connexion = (HttpURLConnection)localUrl.openConnection();
                connexion.setRequestProperty("Host", host);
                for (Map.Entry<String, String> entry : context.getHeaders().entrySet()) {
                    connexion.setRequestProperty(entry.getKey(), entry.getValue());
                }
                stream = connexion.getInputStream();
            } else {
                method = new GetMethod(url.toString());
                for (Map.Entry<String, String> entry : context.getHeaders().entrySet()) {
                    method.setRequestHeader(entry.getKey(), entry.getValue());
                }
                context.getConfig().getHttpClient(baseUrl).executeMethod((HttpMethod)method);
                int code = method.getStatusCode();
                if (code < 200 || code >= 300) {
                    throw new IOException("Error " + code + " while reading the Capabilities from " + url + ": " + method.getStatusText());
                }
                stream = method.getResponseBodyAsStream();
            }
            try {
                result = this.loader.parseInfo(stream);
            }
            finally {
                stream.close();
            }
            T t = result;
            return t;
        }
        finally {
            timer.stop();
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static abstract class ServiceInfoLoader<T extends ServiceInfo> {
        public abstract Log logger();

        public abstract T createNewErrorResult();

        public abstract URL createURL(URI var1, RenderingContext var2) throws UnsupportedEncodingException, URISyntaxException, MalformedURLException;

        public abstract T parseInfo(InputStream var1) throws ParserConfigurationException, IOException, SAXException;

        public static String getTextContentOfChild(Element element, String tagName) {
            String result = ServiceInfoLoader.getTextContextFromPath(element, tagName, null);
            if (result == null) {
                throw new NoSuchElementException("No child " + tagName + " was found in element " + element.getNodeName());
            }
            return result;
        }

        public static String getTextContentOfChild(Element element, String tagName, String defaultValue) {
            Element child = ServiceInfoLoader.getFirstChildElement(element, tagName);
            if (child == null || child.getTextContent().trim().isEmpty()) {
                return defaultValue;
            }
            return child.getTextContent();
        }

        public static ArrayList<String> getTextContentOfChildren(Element element, String tagName) {
            ArrayList<String> text = new ArrayList<String>();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String textContent;
                Element child;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !ServiceInfoLoader.getLocalName(child = (Element)node).equals(tagName) || (textContent = node.getTextContent()).trim().isEmpty()) continue;
                text.add(textContent);
            }
            return text;
        }

        public static String getTextContextFromPath(Element element, String path, String defaultValue) {
            return ServiceInfoLoader.getTextContextFromPath(element, Arrays.asList(path.split("/")), defaultValue);
        }

        private static String getTextContextFromPath(Element element, List<String> path, String defaultValue) {
            Element child = ServiceInfoLoader.getFirstChildElement(element, path.get(0));
            if (child == null) {
                return defaultValue;
            }
            if (path.size() == 1) {
                String text = child.getTextContent();
                if (text.trim().isEmpty()) {
                    return defaultValue;
                }
                return text;
            }
            return ServiceInfoLoader.getTextContextFromPath(child, path.subList(1, path.size()), defaultValue);
        }

        private static Element getFirstChildElement(Element element, String tagName) {
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node elem = childNodes.item(i);
                if (!(elem instanceof Element) || !ServiceInfoLoader.getLocalName(elem).equals(tagName)) continue;
                return (Element)elem;
            }
            return null;
        }

        private static String getLocalName(Node elem) {
            String nodeName = elem.getNodeName();
            String[] split = nodeName.split(":", 2);
            return split.length == 2 ? split[1] : split[0];
        }
    }
}

