/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.legend.LegendItemTable;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class LegendsBlock
extends Block {
    public static final Logger LOGGER = Logger.getLogger(LegendsBlock.class);
    private static String tempDir = System.getProperty("java.io.tmpdir");
    private static String fileSeparator = System.getProperty("file.separator");
    private boolean borders = false;
    private float maxWidth = Float.MAX_VALUE;
    private float maxHeight = Float.MAX_VALUE;
    private float iconMaxWidth = Float.MAX_VALUE;
    private float iconMaxHeight = 8.0f;
    private float[] iconPadding = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float textMaxWidth = Float.MAX_VALUE;
    private float[] textPadding = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float scale = 1.0f;
    private boolean inline = true;
    private float classIndentation = 20.0f;
    private float layerSpaceBefore = 5.0f;
    private float layerSpace = 5.0f;
    private float classSpace = 2.0f;
    private String layerFont = "Helvetica";
    protected float layerFontSize = 10.0f;
    private String classFont = "Helvetica";
    protected float classFontSize = 8.0f;
    private String fontEncoding = "Cp1252";
    private int horizontalAlignment = 1;
    private float[] columnPadding = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        Renderer renderer = new Renderer(params, context);
        renderer.render(target);
    }

    public void setMaxWidth(double maxWidth) {
        this.maxWidth = this.getMaxValueIfZero((float)maxWidth, "maxWidth");
    }

    public void setMaxHeight(double maxHeight) {
        this.maxHeight = this.getMaxValueIfZero((float)maxHeight, "maxHeight");
    }

    public void setDefaultScale(double scale) {
        this.scale = (float)scale;
        if (scale < 0.0) {
            throw new InvalidValueException("scale", scale);
        }
        if (scale == 0.0) {
            this.scale = 1.0f;
        }
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setIconMaxWidth(double maxIconWidth) {
        this.iconMaxWidth = (float)maxIconWidth;
        if (maxIconWidth < 0.0) {
            throw new InvalidValueException("maxIconWidth", maxIconWidth);
        }
        if (maxIconWidth == 0.0) {
            this.iconMaxWidth = Float.MAX_VALUE;
        }
    }

    public void setIconMaxHeight(double maxIconHeight) {
        this.iconMaxHeight = this.getMaxValueIfZero((float)maxIconHeight, "maxIconHeight");
    }

    public void setClassIndentation(double classIndentation) {
        this.classIndentation = (float)classIndentation;
        if (classIndentation < 0.0) {
            throw new InvalidValueException("classIndentation", classIndentation);
        }
    }

    public void setClassFont(String classFont) {
        this.classFont = classFont;
    }

    public void setClassFontSize(double classFontSize) {
        this.classFontSize = (float)classFontSize;
        if (classFontSize < 0.0) {
            throw new InvalidValueException("classFontSize", classFontSize);
        }
    }

    public String getClassFont() {
        return this.classFont;
    }

    protected Font getLayerPdfFont() {
        return FontFactory.getFont((String)this.layerFont, (String)this.fontEncoding, (float)this.layerFontSize);
    }

    protected Font getClassPdfFont() {
        return FontFactory.getFont((String)this.classFont, (String)this.fontEncoding, (float)this.classFontSize);
    }

    public void setLayerSpace(double layerSpace) {
        this.layerSpace = (float)layerSpace;
        if (layerSpace < 0.0) {
            throw new InvalidValueException("layerSpace", layerSpace);
        }
    }

    public void setClassSpace(double classSpace) {
        this.classSpace = (float)classSpace;
        if (classSpace < 0.0) {
            throw new InvalidValueException("classSpace", classSpace);
        }
    }

    public void setLayerFont(String layerFont) {
        this.layerFont = layerFont;
    }

    public void setLayerFontSize(double layerFontSize) {
        this.layerFontSize = (float)layerFontSize;
        if (layerFontSize < 0.0) {
            throw new InvalidValueException("layerFontSize", layerFontSize);
        }
    }

    public void setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
    }

    public void setColumnMargin(String columnMargin) {
        this.columnPadding = this.getFloatCssValues(columnMargin);
    }

    public void setHorizontalAlignment(String value) {
        if (value.equalsIgnoreCase("left")) {
            this.horizontalAlignment = 0;
        } else if (value.equalsIgnoreCase("right")) {
            this.horizontalAlignment = 2;
        }
    }

    public void setIconPadding(String values) {
        this.iconPadding = this.getFloatCssValues(values);
    }

    public void setTextPadding(String values) {
        this.textPadding = this.getFloatCssValues(values);
    }

    private float[] getFloatCssValues(String values) {
        float[] result = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        String[] topRightBottomLeft = values.split(" ");
        int len = topRightBottomLeft.length > 4 ? 4 : topRightBottomLeft.length;
        switch (len) {
            default: {
                for (int i = 0; i < 4; ++i) {
                    result[i] = Float.parseFloat(topRightBottomLeft[0]);
                }
                break;
            }
            case 2: {
                result[0] = result[2] = Float.parseFloat(topRightBottomLeft[0]);
                result[1] = result[3] = Float.parseFloat(topRightBottomLeft[1]);
                break;
            }
            case 3: {
                result[0] = Float.parseFloat(topRightBottomLeft[0]);
                result[1] = result[3] = Float.parseFloat(topRightBottomLeft[1]);
                result[2] = Float.parseFloat(topRightBottomLeft[3]);
                break;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    float val;
                    result[i] = val = Float.parseFloat(topRightBottomLeft[i]);
                }
            }
        }
        return result;
    }

    public void setBorders(boolean value) {
        this.borders = value;
    }

    public void setTextMaxWidth(double textMaxWidth) {
        this.textMaxWidth = this.getMaxValueIfZero((float)textMaxWidth, "textMaxWidth");
    }

    public void setLayerSpaceBefore(double layerSpaceBefore) {
        if (layerSpaceBefore < 0.0) {
            throw new InvalidValueException("layerSpaceBefore", layerSpaceBefore);
        }
        this.layerSpaceBefore = (float)layerSpaceBefore;
    }

    private class Renderer {
        private String tempFilename;
        private Document tempDocument = new Document();
        private PdfWriter writer;
        private RenderingContext context;
        private ArrayList<PdfPTable> columns = new ArrayList();
        private final ArrayList<Float> columnsWidth = new ArrayList();
        private PdfPTable column;
        private int currentColumnIndex = 0;
        private float maxActualImageWidth = 0.0f;
        private float maxActualTextWidth = 0.0f;
        private final ArrayList<LegendItemTable> legendItems = new ArrayList();
        private float optimumIconCellWidth = 0.0f;
        private float optimumTextCellWidth = 0.0f;
        private PdfPCell leftCell;
        private PdfPCell rightCell;
        private float[] absoluteWidths;
        private boolean needTempDocument = true;
        private final HashMap<Integer, Float> subHeights = new HashMap();

        public Renderer(PJsonObject params, RenderingContext context) throws DocumentException {
            this.column = this.getDefaultOuterTable(1);
            this.columns.add(this.column);
            this.context = context;
            PJsonArray legends = context.getGlobalParams().optJSONArray("legends");
            if (legends == null || legends.size() == 0) {
                this.needTempDocument = false;
            }
            if (this.needTempDocument) {
                this.makeTempDocument();
            }
        }

        public void render(Block.PdfElement target) throws DocumentException {
            int numColumns = 1;
            this.absoluteWidths = new float[1];
            PJsonArray legends = this.context.getGlobalParams().optJSONArray("legends");
            float maxColumnWidth = LegendsBlock.this.maxWidth;
            float bufferHeight = 0.0f;
            if (legends != null && legends.size() > 0) {
                for (int i = 0; i < legends.size(); ++i) {
                    this.createLegend(legends.getJSONObject(i), i == 0);
                }
                this.computeOptimumColumns(this.legendItems);
                this.setOptimumCellWidths(maxColumnWidth);
                float totalHeight = 0.0f;
                int len = this.legendItems.size();
                for (int i = 0; i < len; ++i) {
                    LegendItemTable legendItem = this.legendItems.get(i);
                    this.computeOptimumLegendItemWidths(legendItem);
                    float height = this.getHeight((Element)legendItem);
                    float cellPaddingTop = this.leftCell.getPaddingTop();
                    float spacingBefore = legendItem.getSpaceBefore();
                    if ((totalHeight += height) > LegendsBlock.this.maxHeight || legendItem.isNewColumn()) {
                        this.column = this.getDefaultOuterTable(1);
                        this.columns.add(this.column);
                        totalHeight = 0.0f;
                        if (spacingBefore > 0.0f && cellPaddingTop > 0.0f) {
                            this.leftCell.setPaddingTop(cellPaddingTop - spacingBefore);
                            if (this.rightCell != null) {
                                this.rightCell.setPaddingTop(this.rightCell.getPaddingTop() - spacingBefore);
                            }
                        }
                        int columnsSize = this.columns.size();
                        maxColumnWidth = LegendsBlock.this.maxWidth / (float)columnsSize - LegendsBlock.this.columnPadding[1] - LegendsBlock.this.columnPadding[3];
                        if (maxColumnWidth < this.optimumIconCellWidth + this.optimumTextCellWidth) {
                            this.column = this.getDefaultOuterTable(1);
                            this.columns = new ArrayList(columnsSize);
                            this.columns.add(this.column);
                            i = -1;
                            this.setOptimumCellWidths(maxColumnWidth);
                            continue;
                        }
                        this.column.addCell((PdfPTable)legendItem);
                        continue;
                    }
                    if (legendItem.isHeading() && i > 0) {
                        LegendItemTable.Params params = legendItem.getParams();
                        legendItem = this.getLegendItemTable(params.indent, params.node, params.pdfFont, params.lineSpace, params.defaultIconBeforeName, LegendsBlock.this.layerSpaceBefore, params.heading);
                        this.legendItems.set(i, legendItem);
                    }
                    this.column.addCell((PdfPTable)legendItem);
                }
                this.column.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
            }
            numColumns = this.columns.size();
            PdfPTable table = this.getDefaultOuterTable(numColumns);
            if (LegendsBlock.this.maxWidth != Float.MAX_VALUE) {
                table.setTotalWidth(LegendsBlock.this.maxWidth);
            }
            for (PdfPTable col : this.columns) {
                PdfPCell cell = new PdfPCell(col);
                cell.setPaddingTop(LegendsBlock.this.columnPadding[0]);
                cell.setPaddingRight(LegendsBlock.this.columnPadding[1]);
                cell.setPaddingBottom(LegendsBlock.this.columnPadding[2]);
                cell.setPaddingLeft(LegendsBlock.this.columnPadding[3]);
                if (!LegendsBlock.this.borders) {
                    cell.setBorder(0);
                }
                table.addCell(cell);
            }
            if (LegendsBlock.this.maxWidth < Float.MAX_VALUE) {
                table.setTotalWidth(LegendsBlock.this.maxWidth);
                table.setLockedWidth(true);
            }
            table.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
            target.add((Element)table);
            this.cleanup();
        }

        private float getTextWidth(String myString, Font pdfFont) {
            BaseFont baseFont = pdfFont.getBaseFont();
            return baseFont == null ? new Chunk(myString).getWidthPoint() : baseFont.getWidthPoint(myString, pdfFont.getSize());
        }

        private Chunk createImageChunk(RenderingContext context, String iconItem, float maxIconWidth, float maxIconHeight, float scale) throws DocumentException {
            Chunk iconChunk = null;
            try {
                iconChunk = iconItem.indexOf("image%2Fsvg%2Bxml") != -1 ? PDFUtils.createImageChunkFromSVG(context, iconItem, maxIconWidth, maxIconHeight, scale) : PDFUtils.createImageChunk(context, maxIconWidth, maxIconHeight, scale, URI.create(iconItem), 0.0f);
            }
            catch (IOException e) {
                throw new DocumentException((Exception)e);
            }
            return iconChunk;
        }

        private void makeTempDocument() throws DocumentException {
            try {
                this.tempFilename = tempDir.indexOf(47) != -1 ? "" : "\\";
                long time = new Date().getTime();
                this.tempFilename = tempDir + fileSeparator + "mapfish-print-tmp-" + time + ".pdf";
                this.writer = PdfWriter.getInstance((Document)this.tempDocument, (OutputStream)new FileOutputStream(this.tempFilename));
                this.tempDocument.open();
            }
            catch (FileNotFoundException e) {
                throw new DocumentException((Exception)e);
            }
            catch (DocumentException e) {
                new File(this.tempFilename).delete();
                throw new DocumentException((Exception)((Object)e));
            }
        }

        private void cleanup() throws DocumentException {
            if (!this.needTempDocument) {
                return;
            }
            try {
                this.tempDocument.close();
                this.writer.close();
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            finally {
                new File(this.tempFilename).delete();
            }
        }

        private float getHeight(Element element) throws DocumentException {
            this.tempDocument.add(element);
            if (element instanceof PdfPTable) {
                return ((PdfPTable)element).getTotalHeight();
            }
            if (element instanceof PdfPCell) {
                return ((PdfPCell)element).getHeight();
            }
            return -1.0f;
        }

        private void createLegend(PJsonObject layer, boolean isFirst) throws DocumentException {
            Font layerPdfFont = LegendsBlock.this.getLayerPdfFont();
            Font classPdfFont = LegendsBlock.this.getClassPdfFont();
            this.createTableLine(0.0f, layer, layerPdfFont, LegendsBlock.this.layerSpace, true, 0.0f, true);
            PJsonArray classes = layer.getJSONArray("classes");
            for (int j = 0; j < classes.size(); ++j) {
                PJsonObject clazz = classes.getJSONObject(j);
                this.createTableLine(LegendsBlock.this.classIndentation, clazz, classPdfFont, LegendsBlock.this.classSpace, LegendsBlock.this.inline, 0.0f, false);
            }
        }

        private void createTableLine(float indent, PJsonObject node, Font pdfFont, float lineSpace, boolean defaultIconBeforeName, float spaceBefore, boolean isHeading) throws DocumentException {
            this.legendItems.add(this.getLegendItemTable(indent, node, pdfFont, lineSpace, defaultIconBeforeName, spaceBefore, isHeading));
        }

        private LegendItemTable getLegendItemTable(float indent, PJsonObject node, Font pdfFont, float lineSpace, boolean defaultIconBeforeName, float spaceBefore, boolean isHeading) throws DocumentException {
            String name = node.getString("name");
            String icon = node.optString("icon");
            PJsonArray iconsArray = node.optJSONArray("icons");
            int iconsSize = iconsArray == null ? 0 : iconsArray.size();
            String[] icons = new String[iconsSize];
            boolean haveNoIcon = icon == null && iconsSize == 0;
            String iconScaleString = node.optString("scale", "" + LegendsBlock.this.scale);
            float iconScale = Float.parseFloat(iconScaleString);
            boolean iconBeforeName = node.optBool("iconBeforeName", defaultIconBeforeName);
            int i = -1;
            while (++i < iconsSize) {
                icons[i] = iconsArray.getString(i);
            }
            Phrase imagePhrase = new Phrase();
            float imageWidth = 0.0f;
            if (iconsSize > 0) {
                for (String myIcon : icons) {
                    Chunk iconChunk = this.createImageChunk(this.context, myIcon, LegendsBlock.this.iconMaxWidth, LegendsBlock.this.iconMaxHeight, iconScale);
                    imagePhrase.add((Element)iconChunk);
                    imageWidth += iconChunk.getImage().getPlainWidth();
                }
            } else if (icon != null) {
                Chunk iconChunk = this.createImageChunk(this.context, icon, LegendsBlock.this.iconMaxWidth, LegendsBlock.this.iconMaxHeight, iconScale);
                imagePhrase.add((Element)iconChunk);
                imageWidth = iconChunk.getImage().getPlainWidth();
            } else {
                Chunk iconChunk = new Chunk("");
                imagePhrase.add((Element)iconChunk);
            }
            Phrase namePhrase = new Phrase();
            namePhrase.setFont(pdfFont);
            namePhrase.add(name);
            float textWidth = this.getTextWidth(name, pdfFont);
            int columnsWidthSize = this.columnsWidth.size();
            float maxWidthF = textWidth + imageWidth;
            if (columnsWidthSize <= this.currentColumnIndex) {
                this.columnsWidth.add(Float.valueOf(Math.min(LegendsBlock.this.maxWidth, maxWidthF)));
            } else if (columnsWidthSize >= 1 && this.currentColumnIndex == 0) {
                maxWidthF = Math.max(this.columnsWidth.get(0).floatValue(), maxWidthF);
                this.columnsWidth.set(0, Float.valueOf(Math.min(LegendsBlock.this.maxWidth, maxWidthF)));
            }
            this.absoluteWidths = null;
            LegendItemTable legendItemTable = null;
            if (haveNoIcon) {
                legendItemTable = new LegendItemTable(1);
                this.absoluteWidths = new float[1];
                this.absoluteWidths[0] = LegendsBlock.this.textMaxWidth + LegendsBlock.this.iconMaxWidth + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3] + LegendsBlock.this.textPadding[1] + LegendsBlock.this.textPadding[3];
            } else {
                legendItemTable = new LegendItemTable(2);
                this.absoluteWidths = new float[2];
                this.absoluteWidths[0] = LegendsBlock.this.iconMaxWidth + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3];
                this.absoluteWidths[1] = LegendsBlock.this.textMaxWidth + LegendsBlock.this.textPadding[1] + LegendsBlock.this.textPadding[3];
            }
            legendItemTable.setParams(indent, node, pdfFont, lineSpace, defaultIconBeforeName, spaceBefore, isHeading);
            legendItemTable.setHeading(isHeading);
            legendItemTable.setIconBeforeName(iconBeforeName);
            legendItemTable.setTotalWidth(this.absoluteWidths);
            legendItemTable.getDefaultCell().setPadding(0.0f);
            PdfPCell imageCell = null;
            if (!haveNoIcon) {
                imageCell = new PdfPCell(imagePhrase);
                float indentLeft = legendItemTable.isIconBeforeName() ? indent : 0.0f;
                imageCell.setPaddingTop(spaceBefore + LegendsBlock.this.iconPadding[0]);
                imageCell.setPaddingRight(LegendsBlock.this.iconPadding[1]);
                imageCell.setPaddingBottom(lineSpace + LegendsBlock.this.iconPadding[2]);
                imageCell.setPaddingLeft(indentLeft + LegendsBlock.this.iconPadding[3]);
                if (!LegendsBlock.this.borders) {
                    imageCell.setBorder(0);
                }
            }
            PdfPCell nameCell = new PdfPCell(namePhrase);
            float indentLeft = haveNoIcon || !iconBeforeName ? indent : 0.0f;
            legendItemTable.setSpaceBefore(spaceBefore);
            nameCell.setPaddingTop(spaceBefore + LegendsBlock.this.textPadding[0]);
            nameCell.setPaddingRight(LegendsBlock.this.textPadding[1]);
            nameCell.setPaddingBottom(lineSpace + LegendsBlock.this.textPadding[2]);
            nameCell.setPaddingLeft(indentLeft + LegendsBlock.this.textPadding[3]);
            if (!iconBeforeName && LegendsBlock.this.inline) {
                nameCell.setHorizontalAlignment(2);
            }
            if (!LegendsBlock.this.borders) {
                nameCell.setBorder(0);
            }
            if (LegendsBlock.this.inline) {
                if (iconBeforeName) {
                    if (imageCell != null) {
                        legendItemTable.addCell(imageCell);
                    }
                    legendItemTable.addCell(nameCell);
                } else {
                    legendItemTable.addCell(nameCell);
                    if (imageCell != null) {
                        legendItemTable.addCell(imageCell);
                    }
                }
            } else {
                legendItemTable = new LegendItemTable(1);
                if (iconBeforeName) {
                    if (imageCell != null) {
                        legendItemTable.addCell(imageCell);
                    }
                    legendItemTable.addCell(nameCell);
                } else {
                    legendItemTable.addCell(nameCell);
                    if (imageCell != null) {
                        legendItemTable.addCell(imageCell);
                    }
                }
            }
            legendItemTable.setImageCell(imageCell);
            legendItemTable.setNameCell(nameCell);
            this.maxActualImageWidth = Math.max(imageWidth, this.maxActualImageWidth);
            this.maxActualTextWidth = Math.max(textWidth, this.maxActualTextWidth);
            return legendItemTable;
        }

        private PdfPTable getDefaultOuterTable(int numColumns) {
            PdfPTable pdfPTable = new PdfPTable(numColumns);
            if (!LegendsBlock.this.borders) {
                pdfPTable.getDefaultCell().setBorder(0);
            }
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.getDefaultCell().setPadding(0.0f);
            pdfPTable.setSpacingAfter((float)LegendsBlock.this.spacingAfter);
            return pdfPTable;
        }

        private void computeOptimumLegendItemWidths(LegendItemTable legendItem) throws DocumentException {
            PdfPCell[] cells = legendItem.getRow(0).getCells();
            int numCells = cells.length;
            this.leftCell = cells[0];
            this.rightCell = null;
            if (numCells > 1) {
                this.rightCell = cells[1];
            }
            if (numCells == 1) {
                this.absoluteWidths = new float[1];
                this.absoluteWidths[0] = this.optimumTextCellWidth + this.optimumIconCellWidth;
            } else {
                this.absoluteWidths = new float[2];
                if (legendItem.isIconBeforeName()) {
                    this.absoluteWidths[0] = this.optimumIconCellWidth;
                    this.absoluteWidths[1] = this.optimumTextCellWidth;
                } else {
                    this.absoluteWidths[0] = this.optimumTextCellWidth;
                    this.absoluteWidths[1] = this.optimumIconCellWidth;
                }
            }
            legendItem.setTotalWidth(this.absoluteWidths);
            legendItem.setLockedWidth(true);
            legendItem.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
        }

        private void setOptimumCellWidths(float maxColumnWidth) {
            this.optimumIconCellWidth = Math.min(this.maxActualImageWidth + LegendsBlock.this.classIndentation, LegendsBlock.this.iconMaxWidth + LegendsBlock.this.classIndentation);
            this.optimumTextCellWidth = Math.min(this.maxActualTextWidth, LegendsBlock.this.textMaxWidth);
            this.optimumIconCellWidth = Math.min(this.optimumIconCellWidth, maxColumnWidth / 2.0f);
            this.optimumTextCellWidth = Math.min(this.optimumTextCellWidth, maxColumnWidth - this.optimumIconCellWidth);
        }

        private void computeOptimumColumns(ArrayList<LegendItemTable> legendItems) throws DocumentException {
            float totalHeight = 0.0f;
            int subHeightIndex = -1;
            int len = legendItems.size();
            for (int i = 0; i < len; ++i) {
                LegendItemTable legendItem = legendItems.get(i);
                float height = this.getHeight((Element)legendItem);
                totalHeight += height;
                if (legendItem.isHeading()) {
                    ++subHeightIndex;
                }
                if (!this.subHeights.containsKey(subHeightIndex)) {
                    this.subHeights.put(subHeightIndex, Float.valueOf(height));
                    continue;
                }
                this.subHeights.put(subHeightIndex, Float.valueOf(this.subHeights.get(subHeightIndex).floatValue() + height));
            }
            float availableHeight = LegendsBlock.this.maxHeight;
            for (Map.Entry<Integer, Float> subHeight : this.subHeights.entrySet()) {
                int i = subHeight.getKey();
                float height = subHeight.getValue().floatValue();
                int iPlusOne = i + 1;
                float nextHeight = 0.0f;
                if (this.subHeights.containsKey(iPlusOne)) {
                    nextHeight = this.subHeights.get(i + 1).floatValue();
                }
                if (!(height + nextHeight > availableHeight) || !(nextHeight > 0.0f)) continue;
                int countHeadings = 0;
                for (LegendItemTable legendItem : legendItems) {
                    if (legendItem.isHeading()) {
                        ++countHeadings;
                    }
                    if (countHeadings != iPlusOne + 1) continue;
                    legendItem.setNewColumn(true);
                    countHeadings = 0;
                }
            }
        }
    }
}

