/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.mapfish.print.config.HostMatcher;

public abstract class InetHostMatcher
extends HostMatcher {
    public static final Logger LOGGER = Logger.getLogger(InetHostMatcher.class);
    protected byte[][] authorizedIPs = null;

    @Override
    public boolean validate(URI uri) throws UnknownHostException, SocketException, MalformedURLException {
        InetAddress[] requestedIPs;
        InetAddress maskAddress = this.getMaskAddress();
        try {
            requestedIPs = InetAddress.getAllByName(uri.getHost());
        }
        catch (UnknownHostException ex) {
            return false;
        }
        boolean oneMatching = false;
        for (int i = 0; i < requestedIPs.length; ++i) {
            InetAddress requestedIP = requestedIPs[i];
            if (!this.isInAuthorized(requestedIP, maskAddress)) continue;
            oneMatching = true;
            break;
        }
        return oneMatching && super.validate(uri);
    }

    private boolean isInAuthorized(InetAddress requestedIP, InetAddress mask) throws UnknownHostException, SocketException {
        byte[] rBytes = this.mask(requestedIP, mask);
        byte[][] authorizedIPs = this.getAuthorizedIPs(mask);
        for (int i = 0; i < authorizedIPs.length; ++i) {
            byte[] authorizedIP = authorizedIPs[i];
            if (!this.compareIP(rBytes, authorizedIP)) continue;
            return true;
        }
        LOGGER.debug((Object)("Address not in the authorizeds: " + requestedIP));
        return false;
    }

    private boolean compareIP(byte[] rBytes, byte[] authorizedIP) {
        if (rBytes.length != authorizedIP.length) {
            return false;
        }
        for (int j = 0; j < authorizedIP.length; ++j) {
            byte bA = authorizedIP[j];
            byte bR = rBytes[j];
            if (bA == bR) continue;
            return false;
        }
        return true;
    }

    private byte[] mask(InetAddress address, InetAddress mask) {
        byte[] aBytes = address.getAddress();
        if (mask != null) {
            byte[] mBytes = mask.getAddress();
            if (aBytes.length != mBytes.length) {
                LOGGER.warn((Object)("Cannot mask address [" + address + "] with :" + mask));
                return aBytes;
            }
            byte[] result = new byte[aBytes.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(aBytes[i] & mBytes[i]);
            }
            return result;
        }
        return aBytes;
    }

    protected abstract InetAddress getMaskAddress() throws UnknownHostException;

    protected void buildMaskedAuthorizedIPs(InetAddress[] ips) throws UnknownHostException {
        InetAddress maskAddress = this.getMaskAddress();
        this.authorizedIPs = new byte[ips.length][];
        for (int i = 0; i < ips.length; ++i) {
            this.authorizedIPs[i] = this.mask(ips[i], maskAddress);
        }
    }

    protected abstract byte[][] getAuthorizedIPs(InetAddress var1) throws UnknownHostException, SocketException;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.authorizedIPs);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetHostMatcher other = (InetHostMatcher)obj;
        return Arrays.equals((Object[])this.authorizedIPs, (Object[])other.authorizedIPs);
    }
}

