/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.io.Serializable;
import org.openrdf.model.GraphException;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.StatementIterator;

public class LiteralImpl
implements Literal,
Serializable {
    private String _label;
    private String _language;
    private URI _datatype;

    public LiteralImpl(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label must not be null");
        }
        this._label = label;
    }

    public LiteralImpl(String label, String language) {
        this(label);
        this._language = language == null ? null : language.toLowerCase();
    }

    public LiteralImpl(String label, URI datatype) {
        this(label);
        this._datatype = datatype;
    }

    public String getLabel() {
        return this._label;
    }

    public String getLanguage() {
        return this._language;
    }

    public URI getDatatype() {
        return this._datatype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            if (!this._label.equals(other.getLabel())) {
                return false;
            }
            if (this._datatype == null ? other.getDatatype() != null : !((Object)this._datatype).equals(other.getDatatype())) {
                return false;
            }
            return !(this._language == null ? other.getLanguage() != null : !this._language.equals(other.getLanguage()));
        }
        return false;
    }

    public int hashCode() {
        return this._label.hashCode();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            int result = this._label.compareTo(other.getLabel());
            if (result == 0) {
                if (this._datatype == null) {
                    if (other.getDatatype() != null) {
                        result = -1;
                    }
                } else {
                    result = other.getDatatype() == null ? 1 : this._datatype.compareTo(other.getDatatype());
                }
            }
            if (result == 0) {
                if (this._language == null) {
                    if (other.getLanguage() != null) {
                        result = -1;
                    }
                } else {
                    result = other.getLanguage() == null ? 1 : this._language.compareTo(other.getLanguage());
                }
            }
            return result;
        }
        Value other = (Value)o;
        return 1;
    }

    public String toString() {
        return this._label;
    }

    public StatementIterator getObjectStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }
}

