/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;

public class GraphImpl
implements Graph {
    private static final boolean JOIN_BLANKNODES_DEFAULT = true;
    private RdfRepository _sail;

    public GraphImpl() {
        this((RdfRepository)new org.openrdf.sesame.sailimpl.memory.RdfRepository());
        try {
            this._sail.initialize(Collections.EMPTY_MAP);
        }
        catch (SailInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public GraphImpl(LocalRepository repository) {
        this((RdfRepository)repository.getSail());
    }

    public GraphImpl(RdfRepository sail) {
        this._sail = sail;
    }

    public void add(Resource subject, URI predicate, Value object) {
        this._sail.startTransaction();
        try {
            this._sail.addStatement(subject, predicate, object);
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
    }

    public void add(Statement st) {
        this._sail.startTransaction();
        try {
            this._sail.addStatement(st.getSubject(), st.getPredicate(), st.getObject());
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
    }

    public void add(StatementIterator iterator) {
        this.add(iterator, true);
    }

    public void add(StatementIterator iterator, boolean joinBlankNodes) {
        HashMap<String, Value> bNodesMap = null;
        ValueFactory factory = null;
        if (!joinBlankNodes) {
            bNodesMap = new HashMap<String, Value>();
            factory = this._sail.getValueFactory();
        }
        this._sail.startTransaction();
        try {
            while (iterator.hasNext()) {
                Statement st = iterator.next();
                Resource subject = st.getSubject();
                URI predicate = st.getPredicate();
                Value object = st.getObject();
                if (!joinBlankNodes) {
                    String bNodeId;
                    if (subject instanceof BNode) {
                        bNodeId = ((BNode)subject).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            subject = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            subject = factory.createBNode();
                            bNodesMap.put(bNodeId, subject);
                        }
                    }
                    if (object instanceof BNode) {
                        bNodeId = ((BNode)object).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            object = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            object = factory.createBNode();
                            bNodesMap.put(bNodeId, object);
                        }
                    }
                }
                this._sail.addStatement(subject, predicate, object);
            }
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
    }

    public void add(Collection statements) {
        this.add(statements, true);
    }

    public void add(Collection statements, boolean joinBlankNodes) {
        HashMap<String, Value> bNodesMap = null;
        ValueFactory factory = null;
        if (!joinBlankNodes) {
            bNodesMap = new HashMap<String, Value>();
            factory = this._sail.getValueFactory();
        }
        Iterator iter = statements.iterator();
        this._sail.startTransaction();
        try {
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof Statement)) continue;
                Statement st = (Statement)o;
                Resource subject = st.getSubject();
                URI predicate = st.getPredicate();
                Value object = st.getObject();
                if (!joinBlankNodes) {
                    String bNodeId;
                    if (subject instanceof BNode) {
                        bNodeId = ((BNode)subject).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            subject = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            subject = factory.createBNode();
                            bNodesMap.put(bNodeId, subject);
                        }
                    }
                    if (object instanceof BNode) {
                        bNodeId = ((BNode)object).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            object = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            object = factory.createBNode();
                            bNodesMap.put(bNodeId, object);
                        }
                    }
                }
                this._sail.addStatement(subject, predicate, object);
            }
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
    }

    public void add(Graph graph) {
        this.add(graph, true);
    }

    public void add(Graph graph, boolean joinBlankNodes) {
        HashMap<String, Value> bNodesMap = null;
        if (!joinBlankNodes) {
            bNodesMap = new HashMap<String, Value>();
        }
        StatementIterator iter = graph.getStatements();
        try {
            ValueFactory factory = this._sail.getValueFactory();
            this._sail.startTransaction();
            while (iter.hasNext()) {
                Statement st = iter.next();
                Resource subject = st.getSubject();
                URI predicate = st.getPredicate();
                Value object = st.getObject();
                if (!joinBlankNodes) {
                    String bNodeId;
                    if (subject instanceof BNode) {
                        bNodeId = ((BNode)subject).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            subject = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            subject = factory.createBNode();
                            bNodesMap.put(bNodeId, subject);
                        }
                    }
                    if (object instanceof BNode) {
                        bNodeId = ((BNode)object).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            object = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            object = factory.createBNode();
                            bNodesMap.put(bNodeId, object);
                        }
                    }
                }
                this._sail.addStatement(subject, predicate, object);
            }
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
            iter.close();
        }
    }

    public boolean contains(Resource subject, URI predicate, Value object) {
        return this._sail.hasStatement(subject, predicate, object);
    }

    public boolean contains(Statement st) {
        return this.contains(st.getSubject(), st.getPredicate(), st.getObject());
    }

    public StatementIterator getStatements() {
        return this._sail.getStatements(null, null, null);
    }

    public StatementIterator getStatements(Resource subject, URI predicate, Value object) {
        return this._sail.getStatements(subject, predicate, object);
    }

    public int remove(Resource subject, URI predicate, Value object) {
        int result = 0;
        this._sail.startTransaction();
        try {
            result = this._sail.removeStatements(subject, predicate, object);
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
        return result;
    }

    public int remove(Statement st) {
        return this.remove(st.getSubject(), st.getPredicate(), st.getObject());
    }

    public int remove(StatementIterator iterator) {
        int result = 0;
        this._sail.startTransaction();
        try {
            while (iterator.hasNext()) {
                Statement st = iterator.next();
                result += this._sail.removeStatements(st.getSubject(), st.getPredicate(), st.getObject());
            }
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
        return result;
    }

    public void clear() {
        this._sail.startTransaction();
        try {
            this._sail.clearRepository();
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._sail.commitTransaction();
        }
    }

    public Collection getStatementCollection(Resource subject, URI predicate, Value object) {
        ArrayList<Statement> collection = new ArrayList<Statement>();
        StatementIterator iterator = this.getStatements(subject, predicate, object);
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        iterator.close();
        return collection;
    }

    public int remove(Graph graph) {
        return this.remove(graph.getStatements());
    }

    public ValueFactory getValueFactory() {
        return this._sail.getValueFactory();
    }
}

