/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.encoding.BuiltInEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.DictionaryEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;

public class FontContainer {
    private COSDictionary dict;
    private List<Integer> widths;
    PDFont font;

    FontContainer(COSDictionary fontData) throws IOException {
        this.dict = fontData;
        this.font = PDFontFactory.createFont((COSDictionary)fontData);
    }

    int getFirstChar() {
        return this.dict.getInt(COSName.FIRST_CHAR);
    }

    int getLastChar() {
        return this.dict.getInt(COSName.LAST_CHAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CMap getToUnicodeCMap() throws IOException {
        COSBase base = this.dict.getDictionaryObject(COSName.TO_UNICODE);
        if (this.font instanceof PDType0Font && base == null) {
            PDCIDFont cidFont = ((PDType0Font)this.font).getDescendantFont();
            base = cidFont.getCOSObject().getDictionaryObject(COSName.TO_UNICODE);
        }
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            CMapParser parser = new CMapParser();
            return parser.parsePredefined(name);
        }
        if (base instanceof COSStream) {
            InputStream input = null;
            try {
                input = ((COSStream)base).getUnfilteredStream();
                CMapParser parser = new CMapParser();
                CMap cMap = parser.parse(input);
                return cMap;
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        return null;
    }

    COSBase getToUnicode() {
        return this.dict.getDictionaryObject(COSName.TO_UNICODE);
    }

    List<Integer> getWidths() {
        if (this.widths == null) {
            COSArray array = (COSArray)this.dict.getDictionaryObject(COSName.WIDTHS);
            this.widths = array != null ? COSArrayList.convertIntegerCOSArrayToList((COSArray)array) : Collections.emptyList();
        }
        return this.widths;
    }

    Encoding getEncoding() {
        if (this.font instanceof PDSimpleFont) {
            if (((PDSimpleFont)this.font).getEncoding() instanceof DictionaryEncoding) {
                return new DictionaryEncoding((COSDictionary)((PDSimpleFont)this.font).getEncoding().getCOSObject(), true, null);
            }
            return ((PDSimpleFont)this.font).getEncoding();
        }
        return null;
    }

    String getBaseEncodingName() {
        COSBase cosObject;
        Encoding encoding = this.getEncoding();
        if (encoding != null && !(encoding instanceof BuiltInEncoding) && (cosObject = encoding.getCOSObject()) != null) {
            if (cosObject instanceof COSDictionary) {
                COSBase item = ((COSDictionary)cosObject).getItem(COSName.BASE_ENCODING);
                if (item != null) {
                    return ((COSName)item).getName();
                }
            } else {
                if (cosObject instanceof COSName) {
                    return ((COSName)cosObject).getName();
                }
                throw new RuntimeException(cosObject.toString() + " not supported");
            }
        }
        return null;
    }

    float[] getBoundingBox() throws IOException {
        BoundingBox bb = this.font.getBoundingBox();
        return new float[]{bb.getLowerLeftX(), bb.getLowerLeftY(), bb.getUpperRightX(), bb.getUpperRightY()};
    }

    public PDFont getFont() {
        return this.font;
    }
}

