/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import lizard.tiff.IFD;
import lizard.tiff.IFDEntry;
import lizard.tiff.tag.UnisysIXPSTags;
import lizard.util.MemoryFileInputFilter;

class UnisysIXPS_IFD
extends IFD {
    long userAreaIFD;

    public String toString() {
        String s = "    Unisys IXPS IFD Entry Count: " + this.count + "\n";
        int i = 0;
        while (i < this.count) {
            UnisysIXPSTags ut = new UnisysIXPSTags(this.entries[i].tag.Value());
            s = String.valueOf(s) + "\tTag: " + ut.toString();
            if (this.entries[i].isOffset()) {
                int len = Math.min(this.entries[i].dataArray.length, 256);
                if (this.entries[i].type.isAscii()) {
                    String sz = new String(this.entries[i].dataArray);
                    s = String.valueOf(s) + sz + "\n";
                }
            } else {
                s = String.valueOf(s) + this.entries[i].value + "\n";
            }
            ++i;
        }
        return s;
    }

    public void read(MemoryFileInputFilter in) {
        boolean nStripOffsets = false;
        boolean nStripByteCounts = false;
        boolean compType = false;
        this.count = in.readUnsignedShort();
        this.entries = new IFDEntry[this.count];
        int i = 0;
        while (i < this.count) {
            this.entries[i] = new IFDEntry();
            this.entries[i].read(in);
            if (this.entries[i].tag.equals(32000)) {
                this.userAreaIFD = this.entries[i].value;
            }
            ++i;
        }
        this.offset = in.readInt();
    }

    UnisysIXPS_IFD() {
    }
}

