/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import java.awt.Image;
import java.io.IOException;
import lizard.tiff.CCITTG3Image;
import lizard.tiff.CCITTG4Image;
import lizard.tiff.CodedImage;
import lizard.tiff.IFDEntry;
import lizard.tiff.JPEGImage;
import lizard.tiff.PackbitsImage;
import lizard.tiff.RawImage;
import lizard.tiff.UnisysISIS_IFD;
import lizard.tiff.UnisysIXPS_IFD;
import lizard.tiff.Weird_IFD;
import lizard.util.MemoryFileInputFilter;
import lizard.util.MotorolaIntelInputFilter;

class IFD {
    public int count;
    public IFDEntry[] entries;
    public long offset;
    CodedImage cImg;
    IFD unisys;

    public IFD() {
        this.init();
    }

    void init() {
        this.count = 0;
        this.entries = null;
        this.offset = 0L;
        this.cImg = null;
        this.unisys = null;
    }

    IFDEntry GetEntry(int id) {
        int i = 0;
        while (i < this.count) {
            if (this.entries[i].tag.equals(id)) {
                return this.entries[i];
            }
            ++i;
        }
        return null;
    }

    int GetFieldValue(int id) {
        int i = 0;
        while (i < this.count) {
            if (this.entries[i].tag.equals(id)) {
                return (int)this.entries[i].value;
            }
            ++i;
        }
        return 0;
    }

    int GetCompressionType() {
        return this.GetFieldValue(259);
    }

    int size() {
        return 2 + 12 * this.count + 4;
    }

    public String toString() {
        String s = "IFD Entry Count: " + this.count + "\n";
        int i = 0;
        while (i < this.count) {
            s = !this.entries[i].tag.equals(33881) && !this.entries[i].tag.equals(34975) && !this.entries[i].tag.equals(33884) ? String.valueOf(s) + "\t" + this.entries[i].toString() + "\n" : String.valueOf(s) + "\tTag: " + this.entries[i].tag.toString() + "\n";
            ++i;
        }
        if (this.unisys != null) {
            s = String.valueOf(s) + this.unisys.toString();
        }
        s = String.valueOf(s) + "\t\tNext Offset: " + this.offset + "\n";
        return s;
    }

    public Image getImage() {
        return this.cImg.getImage();
    }

    public Object getImageProducer() {
        return this.cImg.getImageProducer();
    }

    public void write(MotorolaIntelInputFilter out) throws IOException {
        int nStripOffsets = 0;
        int nStripByteCounts = 0;
        long nextIFD = this.offset;
        if (this.count == 0 || this.cImg == null) {
            return;
        }
        long offset = out.getFilePointer();
        offset += (long)this.size();
        out.writeShort(this.count);
        int i = 0;
        while (i < this.count) {
            if (this.entries[i].tag.equals(273)) {
                nStripOffsets = i;
                this.entries[i].count = 1L;
                this.entries[i].value = offset;
                offset += (long)this.cImg.imageBytes.length;
            } else if (this.entries[i].tag.equals(279)) {
                nStripByteCounts = i;
                this.entries[i].count = 1L;
                this.entries[i].value = this.cImg.imageBytes.length;
            }
            if (this.entries[i].isOffset()) {
                this.entries[i].value = offset;
                offset += (long)this.entries[i].sizeOfData();
            }
            this.entries[i].writeEntry(out);
            ++i;
        }
        out.writeInt((int)nextIFD);
        i = 0;
        while (i < this.count) {
            if (this.entries[i].isOffset()) {
                this.entries[i].writeData(out);
            }
            ++i;
        }
        this.writeImageBytes(out, nStripOffsets, nStripByteCounts);
    }

    public void writeImageBytes(MotorolaIntelInputFilter out, int nOffsets, int nCounts) throws IOException {
        int len = 0;
        boolean i = false;
        if (this.entries[nCounts].isOffset()) {
            System.out.println("No I won't write out in strips for now");
        } else {
            len = (int)this.entries[nCounts].value;
            out.seek(this.entries[nOffsets].value);
            out.write(this.cImg.imageBytes, 0, len);
        }
    }

    public void read(MemoryFileInputFilter in) {
        int nStripOffsets = 0;
        int nStripByteCounts = 0;
        int compType = 0;
        this.count = in.readUnsignedShort();
        this.entries = new IFDEntry[this.count];
        int i = 0;
        while (i < this.count) {
            this.entries[i] = new IFDEntry();
            this.entries[i].read(in);
            if (this.entries[i].tag.equals(259)) {
                compType = (int)this.entries[i].value;
            }
            if (this.entries[i].tag.equals(279)) {
                nStripByteCounts = i;
            }
            if (this.entries[i].tag.equals(273)) {
                nStripOffsets = i;
            }
            if (this.entries[i].tag.equals(33881)) {
                this.unisys = new UnisysISIS_IFD();
                this.unisys.offset = this.entries[i].value;
            }
            if (this.entries[i].tag.equals(34975)) {
                this.unisys = new Weird_IFD();
                this.unisys.offset = this.entries[i].value;
            }
            if (this.entries[i].tag.equals(33884)) {
                this.unisys = new UnisysIXPS_IFD();
                this.unisys.offset = this.entries[i].value;
            }
            ++i;
        }
        this.offset = in.readInt();
        switch (compType) {
            case 1: {
                this.cImg = new RawImage(this);
                break;
            }
            case 3: {
                this.cImg = new CCITTG3Image(this);
                break;
            }
            case 4: {
                this.cImg = new CCITTG4Image(this);
                break;
            }
            case 6: 
            case 7: {
                this.cImg = new JPEGImage(this);
                break;
            }
            case 32773: {
                this.cImg = new PackbitsImage(this);
                break;
            }
            default: {
                this.cImg = new CodedImage(this);
            }
        }
        this.readImageBytes(in, nStripOffsets, nStripByteCounts);
        if (this.unisys != null) {
            in.seek(this.unisys.offset);
            this.unisys.read(in);
        }
    }

    public void readImageBytes(MemoryFileInputFilter in, int nOffsets, int nCounts) {
        int len = 0;
        if (nCounts != 0 && this.entries[nCounts].isOffset()) {
            long count = this.entries[nCounts].count;
            long[] countArray = new long[(int)count];
            this.cImg.imageStrips = new byte[(int)count][];
            in.seek(this.entries[nCounts].value);
            int i = 0;
            len = 0;
            while ((long)i < count) {
                countArray[i] = in.readInt();
                len = (int)((long)len + countArray[i]);
                ++i;
            }
            long[] offsetArray = new long[(int)count];
            in.seek(this.entries[nOffsets].value);
            i = 0;
            while ((long)i < count) {
                offsetArray[i] = in.readInt();
                ++i;
            }
            int n = 0;
            i = 0;
            while ((long)i < count) {
                this.cImg.imageStrips[i] = new byte[(int)countArray[i]];
                in.seek(offsetArray[i]);
                in.readFully(this.cImg.imageStrips[i]);
                n = (int)((long)n + countArray[i]);
                ++i;
            }
        } else {
            long offset = this.entries[nOffsets].value;
            len = nCounts > 0 ? (int)this.entries[nCounts].value : (int)(in.length() - offset);
            this.cImg.imageBytes = new byte[len];
            in.seek(offset);
            in.readFully(this.cImg.imageBytes);
        }
    }
}

