/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.rql.model.ResourceQuery;

public abstract class Var
implements ResourceQuery {
    protected String _name;
    private Value _value;
    protected Var _leader = null;

    public Var(String name) {
        this._name = name;
    }

    public String getQuery() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setValue(Value value) {
        if (this._leader == null) {
            this._value = value;
        } else {
            this._leader.setValue(value);
        }
    }

    public Value getValue() {
        if (this._leader == null) {
            return this._value;
        }
        return this._leader.getValue();
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public void setLeader(Var leader) {
        this._leader = leader;
    }

    public Var getLeader() {
        return this._leader;
    }

    public boolean hasLeader() {
        return this._leader != null;
    }

    public boolean returnsSet() {
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this._name);
        if (this._leader != null) {
            result.append("[-->");
            result.append(this._leader);
            result.append("]");
        } else if (this._value != null) {
            result.append("[");
            if (this._value instanceof URI) {
                result.append(((URI)this._value).getURI());
            } else if (this._value instanceof BNode) {
                result.append(((BNode)this._value).getID());
            } else if (this._value instanceof Literal) {
                result.append(((Literal)this._value).getLabel());
            } else {
                result.append("SET");
            }
            result.append("]");
        }
        return result.toString();
    }
}

