/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;

class JpaPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<JpaPersistentProperty>
implements JpaPersistentProperty {
    private static final Collection<Class<? extends Annotation>> ASSOCIATION_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> ID_ANNOTATIONS;
    private final Metamodel metamodel;

    public JpaPersistentPropertyImpl(Metamodel metamodel, Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, JpaPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        this.metamodel = metamodel;
    }

    public boolean isIdProperty() {
        for (Class<? extends Annotation> annotation : ID_ANNOTATIONS) {
            if (!this.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntity() {
        try {
            ManagedType type = this.metamodel.managedType(this.getType());
            return !(type instanceof EmbeddableType);
        }
        catch (IllegalArgumentException o_O) {
            return false;
        }
    }

    public boolean isAssociation() {
        for (Class<? extends Annotation> annotationType : ASSOCIATION_ANNOTATIONS) {
            if (this.findAnnotation(annotationType) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isTransient() {
        return this.isAnnotationPresent(Transient.class) || super.isTransient();
    }

    protected Association<JpaPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    static {
        HashSet<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
        annotations.add(OneToMany.class);
        annotations.add(OneToOne.class);
        annotations.add(ManyToMany.class);
        annotations.add(ManyToOne.class);
        ASSOCIATION_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Id.class);
        annotations.add(EmbeddedId.class);
        ID_ANNOTATIONS = annotations;
    }
}

