/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.exceptions;

import org.jdom.Content;
import org.jdom.Element;

public abstract class JeevesException
extends RuntimeException {
    protected String id;
    protected Object object;
    protected int code;

    public JeevesException(String message, Object object) {
        super(message, object instanceof Throwable ? (Throwable)object : null);
        this.object = object;
        this.code = -1;
    }

    public static Element toElement(Throwable t) {
        String msg = t.getMessage();
        String cls = t.getClass().getSimpleName();
        String id = "error";
        Object obj = null;
        if (t instanceof JeevesException) {
            JeevesException je = (JeevesException)t;
            id = je.getId();
            obj = je.getObject();
        }
        Element error = new Element("error").addContent((Content)new Element("message").setText(msg)).addContent((Content)new Element("class").setText(cls)).addContent((Content)JeevesException.getStackTrace(t, 10));
        error.setAttribute("id", id);
        if (obj != null) {
            Element elObj = new Element("object");
            if (obj instanceof Element) {
                elObj.addContent(((Element)obj).detach());
            } else {
                elObj.setText(obj.toString());
            }
            error.addContent((Content)elObj);
        }
        return error;
    }

    private static Element getStackTrace(Throwable t, int depth) {
        Element stack = new Element("stack");
        boolean writing = true;
        for (StackTraceElement ste : t.getStackTrace()) {
            String clas = ste.getClassName();
            String file = ste.getFileName();
            String meth = ste.getMethodName();
            String line = Integer.toString(ste.getLineNumber());
            Element at = new Element("at");
            at.setAttribute("class", clas == null ? "???" : clas);
            at.setAttribute("file", file == null ? "???" : file);
            at.setAttribute("line", line);
            at.setAttribute("method", meth == null ? "???" : meth);
            if (--depth >= 0 || clas != null && (clas.startsWith("org.fao") || clas.startsWith("org.wfp") || clas.startsWith("jeeves") || clas.startsWith("org.geonetwork"))) {
                writing = true;
                stack.addContent((Content)at);
                continue;
            }
            if (!writing) continue;
            stack.addContent((Content)new Element("skip").setText("..."));
            writing = false;
        }
        return stack;
    }

    public String getId() {
        return this.id;
    }

    public Object getObject() {
        return this.object;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.getMessage();
    }
}

