/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.records.attachments.StoreUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordCreateEvent;
import org.fao.geonet.events.history.RecordDeletedEvent;
import org.fao.geonet.events.history.RecordImportedEvent;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.Importer;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.input.JDOMParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordInsertOrDelete")
@PreAuthorize(value="hasRole('Editor')")
@ReadWriteController
public class MetadataInsertDeleteApi {
    public static final String LOGGER = "geonetwork.api.metadatainsertdelete";
    public static final String API_PARAM_REPORT_ABOUT_IMPORTED_RECORDS = "Report about imported records.";
    public static final String API_PARAM_RECORD_GROUP = "The group the record is attached to.";
    public static final String API_PARAM_RECORD_UUID_PROCESSING = "Record identifier processing.";
    private final String API_PARAM_RECORD_TAGS = "Tags to assign to the record.";
    private final String API_PARAM_RECORD_VALIDATE = "Validate the record first and reject it if not valid.";
    private final String API_PARAM_RECORD_XSL = "XSL transformation to apply to the record.";
    private final String API_PARAM_FORCE_SCHEMA = "Force the schema of the record. If not set, schema autodetection is used (and is the preferred method).";
    private final String API_PARAM_BACKUP_FIRST = "Backup first the record as MEF in the metadata removed folder.";
    private final String API_PARAM_RECORD_TYPE = "The type of record.";
    @Autowired
    private DataManager dataManager;
    @Autowired
    private SearchManager searchManager;
    @Autowired
    private AccessManager accessMan;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    MetadataDraftRepository metadataDraftRepository;
    @Autowired
    private SettingManager settingManager;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private GeonetworkDataDirectory dataDirectory;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private IMetadataManager metadataManager;
    @Autowired
    private AccessManager accessManager;

    @ApiOperation(value="Delete a record", notes="User MUST be able to edit the record to delete it. By default, a backup is made in ZIP format. After that, the record attachments are removed, the document removed from the index and then from the database.", nickname="deleteRecord")
    @RequestMapping(value={"/{metadataUuid}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(code=204, message="Record deleted."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRecord(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Backup first the record as MEF in the metadata removed folder.", required=false) @RequestParam(required=false, defaultValue="true") boolean withBackup, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        IMetadataManager metadataManager = (IMetadataManager)appContext.getBean(IMetadataManager.class);
        SearchManager searchManager = (SearchManager)appContext.getBean(SearchManager.class);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE && metadata.getDataInfo().getType() != MetadataType.TEMPLATE_OF_SUB_TEMPLATE && withBackup) {
            MetadataUtils.backupRecord(metadata, context);
        }
        boolean approved = true;
        if (metadata instanceof MetadataDraft) {
            approved = false;
        }
        store.delResources(context, metadata.getUuid(), Boolean.valueOf(approved));
        metadataManager.deleteMetadata(context, metadata.getId() + "");
        this.triggerDeleteEvent(request, metadata);
        searchManager.forceIndexChanges();
    }

    @ApiOperation(value="Delete one or more records", notes="User MUST be able to edit the record to delete it. ", nickname="deleteRecords")
    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=204, message="Report about deleted records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public SimpleMetadataProcessingReport deleteRecords(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Backup first the record as MEF in the metadata removed folder.", required=false) @RequestParam(required=false, defaultValue="true") boolean withBackup, @ApiIgnore HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        IMetadataManager metadataManager = (IMetadataManager)appContext.getBean(IMetadataManager.class);
        AccessManager accessMan = (AccessManager)appContext.getBean(AccessManager.class);
        SearchManager searchManager = (SearchManager)appContext.getBean(SearchManager.class);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        for (String uuid : records) {
            Metadata metadata = this.metadataRepository.findOneByUuid(uuid);
            if (metadata == null) {
                report.incrementNullRecords();
                continue;
            }
            if (!this.accessManager.canEdit(context, String.valueOf(metadata.getId())) || this.metadataDraftRepository.findOneByUuid(uuid) != null) {
                report.addNotEditableMetadataId(metadata.getId());
                continue;
            }
            if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE && metadata.getDataInfo().getType() != MetadataType.TEMPLATE_OF_SUB_TEMPLATE && withBackup) {
                MetadataUtils.backupRecord((AbstractMetadata)metadata, context);
            }
            store.delResources(context, metadata.getUuid());
            metadataManager.deleteMetadata(context, String.valueOf(metadata.getId()));
            this.triggerDeleteEvent(request, (AbstractMetadata)metadata);
            report.incrementProcessedRecords();
            report.addMetadataId(metadata.getId());
        }
        searchManager.forceIndexChanges();
        report.close();
        return report;
    }

    @ApiOperation(value="Add a record", notes="Add one or more record from an XML fragment, URL or file in a folder on the catalog server. When loadingfrom the catalog server folder, it might be faster to use a local filesystem harvester.", nickname="insert")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @ApiResponses(value={@ApiResponse(code=201, message="Report about imported records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport insert(@ApiParam(value="The type of record.", required=false, defaultValue="METADATA") @RequestParam(required=false, defaultValue="METADATA") MetadataType metadataType, @ApiParam(value="XML fragment.", required=false) @RequestBody(required=false) String xml, @ApiParam(value="URL of a file to download and insert.", required=false) @RequestParam(required=false) String[] url, @ApiParam(value="Server folder where to look for files.", required=false) @RequestParam(required=false) String serverFolder, @ApiParam(value="(Server folder import only) Recursive search in folder.", required=false) @RequestParam(required=false, defaultValue="false") boolean recursiveSearch, @ApiParam(value="(XML file only) Publish record.", required=false) @RequestParam(required=false, defaultValue="false") boolean publishToAll, @ApiParam(value="(MEF file only) Assign to current catalog.", required=false) @RequestParam(required=false, defaultValue="false") boolean assignToCatalog, @ApiParam(value="Record identifier processing.", required=false, defaultValue="NOTHING") @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @ApiParam(value="The group the record is attached to.", required=false) @RequestParam(required=false) String group, @ApiParam(value="Tags to assign to the record.", required=false) @RequestParam(required=false) String[] category, @ApiParam(value="Validate the record first and reject it if not valid.", required=false) @RequestParam(required=false, defaultValue="false") boolean rejectIfInvalid, @ApiParam(value="XSL transformation to apply to the record.", required=false, defaultValue="_none_") @RequestParam(required=false, defaultValue="_none_") String transformWith, @ApiParam(value="Force the schema of the record. If not set, schema autodetection is used (and is the preferred method).", required=false) @RequestParam(required=false) String schema, @ApiParam(value="(experimental) Add extra information to the record.", required=false) @RequestParam(required=false) String extra, HttpServletRequest request) throws Exception {
        if (url == null && xml == null && serverFolder == null) {
            throw new IllegalArgumentException(String.format("XML fragment or a URL or a server folder MUST be provided.", new Object[0]));
        }
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        if (xml != null) {
            Element element = null;
            try {
                element = Xml.loadString((String)xml, (boolean)false);
            }
            catch (JDOMParseException ex) {
                throw new IllegalArgumentException(String.format("XML fragment is invalid. Error is %s", ex.getMessage()));
            }
            Pair<Integer, String> pair = this.loadRecord(metadataType, element, uuidProcessing, group, category, rejectIfInvalid, publishToAll, transformWith, schema, extra, request);
            report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format("Metadata imported from XML with UUID '%s'", pair.two()));
            this.triggerImportEvent(request, (String)pair.two());
            report.incrementProcessedRecords();
        }
        if (url != null) {
            for (Element u : url) {
                Element xmlContent = null;
                try {
                    xmlContent = Xml.loadFile((Path)ApiUtils.downloadUrlInTemp((String)u));
                }
                catch (Exception e) {
                    Log.error((String)LOGGER, (Object)String.format("Error importing metadata from '%s'.", (Object[])url), (Throwable)e);
                    report.addError(new Exception(String.format("Failed to import metadata from '%s'. Verify that the URL is correct and contact your administrator if the problem persists to verify the details of the error in the log files.", (Object[])url)));
                }
                if (xmlContent != null) {
                    Iterator<Path> pair = this.loadRecord(metadataType, xmlContent, uuidProcessing, group, category, rejectIfInvalid, publishToAll, transformWith, schema, extra, request);
                    report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format("Metadata imported from URL with UUID '%s'", pair.two()));
                    this.triggerImportEvent(request, (String)pair.two());
                }
                report.incrementProcessedRecords();
            }
        }
        if (serverFolder != null) {
            Path serverFolderPath = IO.toPath((String)serverFolder, (String[])new String[0]);
            final ArrayList files = Lists.newArrayList();
            final MEFLib.MefOrXmlFileFilter predicate = new MEFLib.MefOrXmlFileFilter();
            if (recursiveSearch) {
                Files.walkFileTree(serverFolderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (predicate.accept(file)) {
                            files.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                DirectoryStream<Path> paths = Files.newDirectoryStream(serverFolderPath, (DirectoryStream.Filter<? super Path>)predicate);
                Object object = null;
                try {
                    for (Path file : paths) {
                        files.add(file);
                    }
                }
                catch (Throwable pair) {
                    object = pair;
                    throw pair;
                }
                finally {
                    if (paths != null) {
                        if (object != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable pair) {
                                ((Throwable)object).addSuppressed(pair);
                            }
                        } else {
                            paths.close();
                        }
                    }
                }
            }
            if (files.size() == 0) {
                throw new Exception(String.format("No XML or MEF or ZIP file found in server folder '%s'.", serverFolder));
            }
            ServiceContext context = ApiUtils.createServiceContext(request);
            for (Path f : files) {
                if (MEFLib.isValidArchiveExtensionForMEF((String)f.getFileName().toString())) {
                    try {
                        MEFLib.Version version = MEFLib.getMEFVersion((Path)f);
                        List ids = MEFLib.doImport((String)(version == MEFLib.Version.V1 ? "mef" : "mef2"), (MEFLib.UuidAction)uuidProcessing, (String)transformWith, (String)this.settingManager.getSiteId(), (MetadataType)metadataType, (String[])category, (String)group, (boolean)rejectIfInvalid, (boolean)assignToCatalog, (ServiceContext)context, (Path)f);
                        for (String id : ids) {
                            report.addMetadataInfos(Integer.parseInt(id), id, !publishToAll, false, String.format("Metadata imported from MEF with id '%s'", id));
                            this.triggerCreationEvent(request, id);
                            report.incrementProcessedRecords();
                        }
                        continue;
                    }
                    catch (Exception e) {
                        report.addError(e);
                        report.addInfos(String.format("Failed to import MEF file '%s'. Check error for details.", f.getFileName().toString()));
                        continue;
                    }
                }
                try {
                    Pair<Integer, String> pair = this.loadRecord(metadataType, Xml.loadFile((Path)f), uuidProcessing, group, category, rejectIfInvalid, publishToAll, transformWith, schema, extra, request);
                    report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format("Metadata imported from server folder with UUID '%s'", pair.two()));
                    this.triggerCreationEvent(request, (String)pair.two());
                }
                catch (Exception e) {
                    report.addError(e);
                }
                report.incrementProcessedRecords();
            }
        }
        report.close();
        return report;
    }

    @ApiOperation(value="Create a new record", notes="Create a record from a template or by copying an existing record.Return the UUID of the newly created record. Existing links in the source record are preserved, this means that the new record may contains link to the source attachments. They need to be manually updated after creation.", nickname="create")
    @RequestMapping(value={"/duplicate"}, method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Return the internal id of the newly created record."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public String create(@ApiParam(value="The type of record.", required=false, defaultValue="METADATA") @RequestParam(required=false, defaultValue="METADATA") MetadataType metadataType, @ApiParam(value="UUID of the source record to copy.", required=true) @RequestParam(required=true) String sourceUuid, @ApiParam(value="Assign a custom UUID. If this UUID already exist an error is returned. This is enabled only if metadata create / generate UUID settings is activated.", required=false) @RequestParam(required=false) String targetUuid, @ApiParam(value="The group the record is attached to.", required=true) @RequestParam(required=true) String group, @ApiParam(value="Is published to all user group members? If not, only the author and administrator can edit the record.", required=false, defaultValue="false") @RequestParam(required=false, defaultValue="false") boolean isVisibleByAllGroupMembers, @ApiParam(value="Tags to assign to the record.", required=false) @RequestParam(required=false) String[] category, @ApiParam(value="Copy categories from source?", required=false, defaultValue="false") @RequestParam(required=false, defaultValue="false") boolean hasCategoryOfSource, @ApiParam(value="Is child of the record to copy?", required=false, defaultValue="false") @RequestParam(required=false, defaultValue="false") boolean isChildOfSource, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        Specifications spec;
        List userGroups;
        AbstractMetadata sourceMetadata = ApiUtils.getRecord(sourceUuid);
        boolean generateUuid = this.settingManager.getValueAsBool("system/metadatacreate/generateUuid");
        String metadataUuid = null;
        if (!generateUuid && !StringUtils.isEmpty((String)targetUuid)) {
            try {
                ApiUtils.getRecord(targetUuid);
                throw new BadParameterEx(String.format("You can't create a new record with the UUID '%s' because a record already exist with this UUID.", targetUuid), (Object)targetUuid);
            }
            catch (ResourceNotFoundException e) {
                metadataUuid = targetUuid;
            }
        } else {
            metadataUuid = UUID.randomUUID().toString();
        }
        UserSession user = ApiUtils.getUserSession(httpSession);
        if (user.getProfile() != Profile.Administrator && (userGroups = this.userGroupRepository.findAll((Specification)(spec = Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Editor)).and(UserGroupSpecs.hasUserId((int)user.getUserIdAsInt())).and(UserGroupSpecs.hasGroupId((Integer)Integer.valueOf(group)))))).size() == 0) {
            throw new SecurityException(String.format("You can't create a record in this group. User MUST be an Editor in that group", new Object[0]));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        String newId = this.dataManager.createMetadata(context, String.valueOf(sourceMetadata.getId()), group, this.settingManager.getSiteId(), context.getUserSession().getUserIdAsInt(), isChildOfSource ? sourceMetadata.getUuid() : null, metadataType.toString(), isVisibleByAllGroupMembers, metadataUuid);
        this.triggerCreationEvent(request, newId);
        this.dataManager.activateWorkflowIfConfigured(context, newId, group);
        try {
            StoreUtils.copyDataDir((ServiceContext)context, (int)sourceMetadata.getId(), (int)Integer.parseInt(newId), (boolean)true);
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while copying metadata resources. Error is %s. Metadata is created but without resources from the source record with id '%s':", e.getMessage(), newId));
        }
        if (hasCategoryOfSource) {
            Collection categories = this.dataManager.getCategories(sourceMetadata.getId() + "");
            try {
                Iterator iterator = categories.iterator();
                while (iterator.hasNext()) {
                    MetadataCategory c = (MetadataCategory)iterator.next();
                    this.dataManager.setCategory(context, newId, c.getId() + "");
                }
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while copying source record category to new record. Error is %s. Metadata is created but without the categories from the source record with id '%d':", e.getMessage(), newId));
            }
        }
        if (category != null && category.length > 0) {
            try {
                for (String c : category) {
                    this.dataManager.setCategory(context, newId, c);
                }
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while setting record category to new record. Error is %s. Metadata is created but without the requested categories.", e.getMessage(), newId));
            }
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Add a record from XML or MEF/ZIP file", notes="Add record in the catalog by uploading files.", nickname="insertFile")
    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Report about imported records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport insertFile(@ApiParam(value="The type of record.", required=false, defaultValue="METADATA") @RequestParam(required=false, defaultValue="METADATA") MetadataType metadataType, @ApiParam(value="XML or MEF file to upload", required=false) @RequestParam(value="file", required=false) MultipartFile[] file, @ApiParam(value="Record identifier processing.", required=false, defaultValue="NOTHING") @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @ApiParam(value="The group the record is attached to.", required=false) @RequestParam(required=false) String group, @ApiParam(value="Tags to assign to the record.", required=false) @RequestParam(required=false) String[] category, @ApiParam(value="Validate the record first and reject it if not valid.", required=false) @RequestParam(required=false, defaultValue="false") boolean rejectIfInvalid, @ApiParam(value="(XML file only) Publish record.", required=false) @RequestParam(required=false, defaultValue="false") boolean publishToAll, @ApiParam(value="(MEF file only) Assign to current catalog.", required=false) @RequestParam(required=false, defaultValue="false") boolean assignToCatalog, @ApiParam(value="XSL transformation to apply to the record.", required=false, defaultValue="_none_") @RequestParam(required=false, defaultValue="_none_") String transformWith, @ApiParam(value="Force the schema of the record. If not set, schema autodetection is used (and is the preferred method).", required=false) @RequestParam(required=false) String schema, @ApiParam(value="(experimental) Add extra information to the record.", required=false) @RequestParam(required=false) String extra, HttpServletRequest request) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException(String.format("A file MUST be provided.", new Object[0]));
        }
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        if (file != null) {
            ServiceContext context = ApiUtils.createServiceContext(request);
            for (MultipartFile f : file) {
                if (MEFLib.isValidArchiveExtensionForMEF((String)f.getOriginalFilename())) {
                    Path tempFile = Files.createTempFile("mef-import", ".zip", new FileAttribute[0]);
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)f.getInputStream(), (File)tempFile.toFile());
                        MEFLib.Version version = MEFLib.getMEFVersion((Path)tempFile);
                        List ids = MEFLib.doImport((String)(version == MEFLib.Version.V1 ? "mef" : "mef2"), (MEFLib.UuidAction)uuidProcessing, (String)transformWith, (String)this.settingManager.getSiteId(), (MetadataType)metadataType, (String[])category, (String)group, (boolean)rejectIfInvalid, (boolean)assignToCatalog, (ServiceContext)context, (Path)tempFile);
                        if (ids.isEmpty()) {
                            throw new BadFormatEx("Import 0 record, check whether the importing file is a valid MEF archive.");
                        }
                        ids.forEach(e -> {
                            report.addMetadataInfos(Integer.parseInt(e), (String)e, !publishToAll, false, String.format("Metadata imported with ID '%s'", e));
                            try {
                                this.triggerCreationEvent(request, (String)e);
                            }
                            catch (Exception e1) {
                                report.addError(e1);
                                report.addInfos(String.format("Impossible to store event for '%s'. Check error for details.", f.getOriginalFilename()));
                            }
                            report.incrementProcessedRecords();
                        });
                        continue;
                    }
                    catch (Exception e2) {
                        report.addError(e2);
                        report.addInfos(String.format("Failed to import MEF file '%s'. Check error for details.", f.getOriginalFilename()));
                        continue;
                    }
                    finally {
                        IO.deleteFile((Path)tempFile, (boolean)false, (String)"geonetwork.mef");
                    }
                }
                Pair<Integer, String> pair = this.loadRecord(metadataType, Xml.loadStream((InputStream)f.getInputStream()), uuidProcessing, group, category, rejectIfInvalid, publishToAll, transformWith, schema, extra, request);
                report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format("Metadata imported with UUID '%s'", pair.two()));
                this.triggerImportEvent(request, (String)pair.two());
                report.incrementProcessedRecords();
            }
        }
        report.close();
        return report;
    }

    @ApiOperation(value="Add a map metadata record from OGC OWS context", notes="Add record in the catalog by uploading a map context.", nickname="insertOgcMapContextFile")
    @RequestMapping(value={"/importfrommap"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Report about imported records."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport insertOgcMapContextFile(@ApiParam(value="A map title", required=true) @RequestParam(value="title", required=true) String title, @ApiParam(value="A map abstract", required=false) @RequestParam(value="recordAbstract", required=false) String recordAbstract, @ApiParam(value="OGC OWS context as string", required=false) @RequestParam(value="xml", required=false) String xml, @ApiParam(value="OGC OWS context file name", required=false) @RequestParam(value="filename", required=false) String filename, @ApiParam(value="OGC OWS context URL", required=false) @RequestParam(value="url", required=false) String url, @ApiParam(value="A map viewer URL to visualize the map", required=false) @RequestParam(value="viewerUrl", required=false) String viewerUrl, @ApiParam(value="Map overview as PNG (base64 encoded)", required=false) @RequestParam(value="overview", required=false) String overview, @ApiParam(value="Map overview filename", required=false) @RequestParam(value="overviewFilename", required=false) String overviewFilename, @ApiParam(value="Topic category", required=false) @RequestParam(value="topic", required=false) String topic, @ApiParam(value="Publish record.", required=false) @RequestParam(required=false, defaultValue="false") boolean publishToAll, @ApiParam(value="Record identifier processing.", required=false, defaultValue="NOTHING") @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @ApiParam(value="The group the record is attached to.", required=false) @RequestParam(required=false) String group, HttpServletRequest request) throws Exception {
        HashMap<String, String> onlineSrcParams;
        if (StringUtils.isEmpty((String)xml) && StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException(String.format("A context as XML or a remote URL MUST be provided.", new Object[0]));
        }
        if (StringUtils.isEmpty((String)xml) && StringUtils.isEmpty((String)filename)) {
            throw new IllegalArgumentException(String.format("A context as XML will be saved as a record attachment. You MUST provide a filename in this case.", new Object[0]));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        String styleSheetWmc = this.dataDirectory.getWebappDir() + File.separator + "xsl/conversion/import" + File.separator + "OGCWMC-OR-OWSC-to-ISO19139.xsl";
        FilePathChecker.verify((String)filename);
        HashMap<String, String> xslParams = new HashMap<String, String>();
        xslParams.put("viewer_url", viewerUrl);
        xslParams.put("map_url", url);
        xslParams.put("topic", topic);
        xslParams.put("title", title);
        xslParams.put("abstract", recordAbstract);
        xslParams.put("lang", context.getLanguage());
        UserSession us = context.getUserSession();
        if (us != null) {
            xslParams.put("currentuser_name", us.getName() + " " + us.getSurname());
            xslParams.put("currentuser_mail", us.getEmailAddr());
            xslParams.put("currentuser_org", us.getOrganisation());
        }
        Element wmcDoc = Xml.loadString((String)xml, (boolean)false);
        Element transformedMd = Xml.transform((Element)wmcDoc, (Path)new File(styleSheetWmc).toPath(), xslParams);
        String uuid = UUID.randomUUID().toString();
        String date = new ISODate().toString();
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        ArrayList id = new ArrayList();
        ArrayList<Element> md = new ArrayList<Element>();
        md.add(transformedMd);
        Importer.importRecord((String)uuid, (MEFLib.UuidAction)uuidProcessing, md, (String)"iso19139", (int)0, (String)this.settingManager.getSiteId(), (String)this.settingManager.getSiteName(), null, (ServiceContext)context, id, (String)date, (String)date, (String)group, (MetadataType)MetadataType.METADATA);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        String metadataUuid = metadataUtils.getMetadataUuid((String)id.get(0));
        if (StringUtils.isEmpty((String)url)) {
            store.putResource(context, metadataUuid, filename, IOUtils.toInputStream((String)Xml.getString((Element)wmcDoc)), null, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(true));
            onlineSrcParams = new HashMap<String, String>();
            onlineSrcParams.put("protocol", "WWW:DOWNLOAD-OGC:OWS-C");
            onlineSrcParams.put("url", this.settingManager.getNodeURL() + String.format("api/records/%s/attachments/%s", uuid, filename));
            onlineSrcParams.put("name", filename);
            onlineSrcParams.put("desc", title);
            transformedMd = Xml.transform((Element)transformedMd, (Path)this.schemaManager.getSchemaDir("iso19139").resolve("process").resolve("onlinesrc-add.xsl"), onlineSrcParams);
            this.dataManager.updateMetadata(context, (String)id.get(0), transformedMd, false, true, false, context.getLanguage(), null, true);
        }
        if (StringUtils.isNotEmpty((String)overview) && StringUtils.isNotEmpty((String)overviewFilename)) {
            store.putResource(context, metadataUuid, overviewFilename, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)overview)), null, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(true));
            onlineSrcParams = new HashMap();
            onlineSrcParams.put("thumbnail_url", this.settingManager.getNodeURL() + String.format("api/records/%s/attachments/%s", uuid, overviewFilename));
            transformedMd = Xml.transform((Element)transformedMd, (Path)this.schemaManager.getSchemaDir("iso19139").resolve("process").resolve("thumbnail-add.xsl"), onlineSrcParams);
            this.dataManager.updateMetadata(context, (String)id.get(0), transformedMd, false, true, false, context.getLanguage(), null, true);
        }
        int iId = Integer.parseInt((String)id.get(0));
        if (publishToAll) {
            this.dataManager.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.view.getId());
            this.dataManager.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.download.getId());
            this.dataManager.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.dynamic.getId());
        }
        if (StringUtils.isNotEmpty((String)group)) {
            int gId = Integer.parseInt(group);
            this.dataManager.setOperation(context, iId, gId, ReservedOperation.view.getId());
            this.dataManager.setOperation(context, iId, gId, ReservedOperation.download.getId());
            this.dataManager.setOperation(context, iId, gId, ReservedOperation.dynamic.getId());
        }
        this.dataManager.indexMetadata(id);
        report.addMetadataInfos(Integer.parseInt((String)id.get(0)), uuid, !publishToAll, false, uuid);
        this.triggerCreationEvent(request, uuid);
        report.incrementProcessedRecords();
        report.close();
        return report;
    }

    private void triggerCreationEvent(HttpServletRequest request, String uuid) throws Exception, JsonProcessingException {
        AbstractMetadata metadata = ApiUtils.getRecord(uuid);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordCreateEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)userSession.getPrincipal(), (String)"userObject"), metadata.getData()).publish((ApplicationContext)applicationContext);
    }

    private void triggerImportEvent(HttpServletRequest request, String uuid) throws Exception, JsonProcessingException {
        AbstractMetadata metadata = ApiUtils.getRecord(uuid);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordImportedEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)userSession.getPrincipal(), (String)"user"), metadata.getData()).publish((ApplicationContext)applicationContext);
    }

    private void triggerDeleteEvent(HttpServletRequest request, AbstractMetadata metadata) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordDeletedEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), metadata.getData()).publish((ApplicationContext)applicationContext);
    }

    private Pair<Integer, String> loadRecord(MetadataType metadataType, Element xmlElement, MEFLib.UuidAction uuidProcessing, String group, String[] category, boolean rejectIfInvalid, boolean publishToAll, String transformWith, String schema, final String extra, HttpServletRequest request) throws Exception {
        Metadata md;
        String uuid;
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (!transformWith.equals("_none_")) {
            Path folder = this.dataDirectory.getWebappDir().resolve("xsl/conversion/import");
            FilePathChecker.verify((String)transformWith);
            Path xslFile = folder.resolve(transformWith + ".xsl");
            if (Files.exists(xslFile, new LinkOption[0])) {
                xmlElement = Xml.transform((Element)xmlElement, (Path)xslFile);
            } else {
                throw new ResourceNotFoundException(String.format("XSL transformation '%s' not found.", transformWith));
            }
        }
        if (schema == null && (schema = this.dataManager.autodetectSchema(xmlElement)) == null) {
            throw new IllegalArgumentException("Can't detect schema for metadata automatically. You could try to force the schema with the schema parameter.");
        }
        if (rejectIfInvalid) {
            try {
                Integer groupId = null;
                if (StringUtils.isNotEmpty((String)group)) {
                    groupId = Integer.parseInt(group);
                }
                DataManager.validateExternalMetadata((String)schema, (Element)xmlElement, (ServiceContext)context, (Integer)groupId);
            }
            catch (XSDValidationErrorEx e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (metadataType == MetadataType.SUB_TEMPLATE || metadataType == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
            uuid = xmlElement.getAttributeValue("uuid");
            if (StringUtils.isEmpty((String)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
        } else {
            uuid = this.dataManager.extractUUID(schema, xmlElement);
            if (uuid.length() == 0) {
                uuid = UUID.randomUUID().toString();
                xmlElement = this.dataManager.setUUID(schema, uuid, xmlElement);
            }
        }
        if (uuidProcessing == MEFLib.UuidAction.NOTHING && (md = this.metadataRepository.findOneByUuid(uuid)) != null) {
            throw new IllegalArgumentException(String.format("A record with UUID '%s' already exist and you choose no action on UUID processing. Choose to overwrite existing record or to generate a new UUID.", uuid));
        }
        String date = new ISODate().toString();
        ArrayList id = new ArrayList();
        ArrayList<Element> md2 = new ArrayList<Element>();
        md2.add(xmlElement);
        HashMap sourceTranslations = Maps.newHashMap();
        try {
            Importer.importRecord((String)uuid, (MEFLib.UuidAction)uuidProcessing, md2, (String)schema, (int)0, (String)this.settingManager.getSiteId(), (String)this.settingManager.getSiteName(), (Map)sourceTranslations, (ServiceContext)context, id, (String)date, (String)date, (String)group, (MetadataType)metadataType);
        }
        catch (DataIntegrityViolationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        int iId = Integer.parseInt((String)id.get(0));
        uuid = this.dataManager.getMetadataUuid(iId + "");
        this.dataManager.setTemplate(iId, metadataType, null);
        if (publishToAll) {
            this.dataManager.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.view.getId());
            this.dataManager.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.download.getId());
            this.dataManager.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.dynamic.getId());
        }
        this.dataManager.activateWorkflowIfConfigured(context, (String)id.get(0), group);
        if (category != null) {
            for (String c : category) {
                this.dataManager.setCategory(context, (String)id.get(0), c);
            }
        }
        if (extra != null) {
            this.metadataRepository.update((Serializable)Integer.valueOf(iId), (Updater)new Updater<Metadata>(){

                public void apply(@Nonnull Metadata metadata) {
                    if (extra != null) {
                        metadata.getDataInfo().setExtra(extra);
                    }
                }
            });
        }
        this.dataManager.indexMetadata((String)id.get(0), true, null);
        return Pair.read((Object)Integer.valueOf((String)id.get(0)), (Object)uuid);
    }
}

