/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.languages;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Language;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.lib.DbLib;
import org.fao.geonet.repository.LanguageRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/languages", "/{portal}/api/0.1/languages"})
@Api(value="languages", tags={"languages"}, description="Languages operations")
@Controller(value="languages")
public class LanguagesApi {
    @Autowired
    private LanguageRepository languageRepository;
    @Autowired
    private GeonetworkDataDirectory dataDirectory;

    @ApiOperation(value="Get languages", notes="Languages for the application having translations in the database. All tables with 'Desc' suffix contains translation for some domain objects like groups, tags, ...", nickname="getLanguages")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Language> getLanguages() throws Exception {
        return this.languageRepository.findAll();
    }

    @ApiOperation(value="Add a language", notes="Add all default translations from all *Desc tables in the database. This operation will only add translations for a default catalog installation. Defaults can be customized in SQL scripts located in WEB-INF/classes/setup/sql/data/*.", authorizations={@Authorization(value="basicAuth")}, nickname="addLanguage")
    @RequestMapping(value={"/{langCode}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=201, message="Language translations added."), @ApiResponse(code=404, message="Resource not found. eg. No SQL file available for that langugae."), @ApiResponse(code=403, message="Operation not allowed. Only Administrator can access it.")})
    public void addLanguages(@ApiParam(value="ISO 3 letter code", required=true) @PathVariable String langCode, @ApiIgnore HttpServletRequest request) throws IOException, ResourceNotFoundException {
        Language lang = (Language)this.languageRepository.findOne((Serializable)((Object)langCode));
        if (lang == null) {
            String languageDataFile = "loc-" + langCode + "-default.sql";
            Path templateFile = this.dataDirectory.getWebappDir().resolve("WEB-INF").resolve("classes").resolve("setup").resolve("sql").resolve("data").resolve(languageDataFile);
            if (Files.exists(templateFile, new LinkOption[0])) {
                ArrayList<String> data = new ArrayList<String>();
                try (BufferedReader br = new BufferedReader(new FileReader(templateFile.toFile()));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        data.add(line);
                    }
                }
                if (data.size() > 0) {
                    ServiceContext context = ApiUtils.createServiceContext(request);
                    DbLib.runSQL((ServiceContext)context, data);
                    return;
                }
            }
            throw new ResourceNotFoundException(String.format("Language data file '%s' not found in classes/setup/sql/data.", languageDataFile));
        }
        throw new RuntimeException(String.format("Language '%s' already available.", lang.getId()));
    }

    @ApiOperation(value="Remove a language", notes="Delete all translations from all *Desc tables in the database. Warning: This will also remove all translations you may have done to those objects (eg. custom groups).", authorizations={@Authorization(value="basicAuth")}, nickname="deleteLanguage")
    @RequestMapping(value={"/{langCode}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Language translations removed."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrator can access it.")})
    public void deleteLanguage(@ApiParam(value="ISO 3 letter code", required=true) @PathVariable String langCode, HttpServletRequest request) throws IOException, ResourceNotFoundException {
        Language lang = (Language)this.languageRepository.findOne((Serializable)((Object)langCode));
        if (lang == null) {
            throw new ResourceNotFoundException(String.format("Language '%s' not found.", langCode));
        }
        String LANGUAGE_DELETE_SQL = "language-delete.sql";
        Path templateFile = this.dataDirectory.getWebappDir().resolve("WEB-INF").resolve("classes").resolve("setup").resolve("sql").resolve("template").resolve("language-delete.sql");
        if (Files.exists(templateFile, new LinkOption[0])) {
            ArrayList<String> data = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new FileReader(templateFile.toFile()));){
                String line;
                while ((line = br.readLine()) != null) {
                    data.add(String.format(line, lang.getId()));
                }
            }
            if (data.size() > 0) {
                ServiceContext context = ApiUtils.createServiceContext(request);
                DbLib.runSQL((ServiceContext)context, data);
                return;
            }
        }
        throw new ResourceNotFoundException(String.format("Template file '%s' not found in classes/setup/sql/template.", "language-delete.sql"));
    }
}

