/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.IdentityMapper;

public abstract class MappingSelector
extends BaseSelector {
    protected File targetdir = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper map = null;
    protected int granularity = (int)FileUtils.newFileUtils().getFileTimestampGranularity();

    public void setTargetdir(File targetdir) {
        this.targetdir = targetdir;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void verifySettings() {
        if (this.targetdir == null) {
            this.setError("The targetdir attribute is required.");
        }
        this.map = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
        if (this.map == null) {
            this.setError("Could not set <mapper> element.");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        String[] destfiles = this.map.mapFileName(filename);
        if (destfiles == null) {
            return false;
        }
        if (destfiles.length != 1 || destfiles[0] == null) {
            throw new BuildException("Invalid destination file results for " + this.targetdir.getName() + " with filename " + filename);
        }
        String destname = destfiles[0];
        File destfile = new File(this.targetdir, destname);
        boolean selected = this.selectionTest(file, destfile);
        return selected;
    }

    protected abstract boolean selectionTest(File var1, File var2);

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }
}

