/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.iface;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IRStatusReport {
    private static final String KISR_NS = "http://www.k-int.com/schemas/StatusReport";
    public String source_short_name;
    public String source_long_name;
    public String source_id;
    public String status;
    public int num_hits;
    public int current_hwm;
    public Vector recent_messages;
    public IRStatusReport[] child_reports;

    public IRStatusReport(String sn, String ln, String id, String status, int nh, int ch, IRStatusReport[] cr, Vector recent_messages) {
        this.source_short_name = sn;
        this.source_long_name = ln;
        this.source_id = id;
        this.num_hits = nh;
        this.current_hwm = ch;
        this.child_reports = cr;
        this.status = status;
        this.recent_messages = recent_messages;
    }

    public String getSourceShortName() {
        return this.source_short_name;
    }

    public String getSourceLongName() {
        return this.source_long_name;
    }

    public String getSourceId() {
        return this.source_id;
    }

    public int getEstTotalHits() {
        return this.num_hits;
    }

    public int getCurrentSize() {
        return this.current_hwm;
    }

    public String getStatus() {
        return this.status;
    }

    public IRStatusReport[] getChildReports() {
        return this.child_reports;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        sw.write("Status report for ");
        sw.write(this.source_long_name);
        sw.write("( ");
        sw.write(this.source_id);
        sw.write(" ).\t Source status is ");
        sw.write("" + this.status);
        sw.write(" and currently holds ");
        sw.write("" + this.current_hwm);
        sw.write("out of ");
        sw.write("" + this.num_hits);
        sw.write("records");
        if (this.child_reports == null) {
            sw.write(".\n");
        } else {
            sw.write(" and is aggregating data from ");
            sw.write("" + this.child_reports.length);
            sw.write(" services \n{");
            for (int i = 0; i < this.child_reports.length; ++i) {
                sw.write(this.child_reports[i].toString());
            }
            sw.write("}.\n");
        }
        return sw.toString();
    }

    public Element toXMLNode(Document parent_doc) {
        Element status_report_node = parent_doc.createElementNS(KISR_NS, "KISR:StatusReport");
        status_report_node.setAttribute("SourceLongName", this.source_long_name);
        status_report_node.setAttribute("SourceID", this.source_id);
        status_report_node.setAttribute("Status", "" + this.status);
        status_report_node.setAttribute("Estimate", "" + this.current_hwm);
        status_report_node.setAttribute("Available", "" + this.num_hits);
        Enumeration e = this.recent_messages.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            Element message = parent_doc.createElement("Message");
            message.appendChild(parent_doc.createTextNode(o.toString()));
            status_report_node.appendChild(message);
        }
        if (this.child_reports != null) {
            Element child_reports_node = parent_doc.createElement("ChildReports");
            for (int i = 0; i < this.child_reports.length; ++i) {
                child_reports_node.appendChild(this.child_reports[i].toXMLNode(parent_doc));
            }
            status_report_node.appendChild(child_reports_node);
        }
        return status_report_node;
    }

    public Vector getRecentMessages() {
        return this.recent_messages;
    }
}

