/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.ShortCollection;
import bak.pcj.ShortIterator;
import bak.pcj.set.AbstractShortSet;
import bak.pcj.set.ShortSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class ShortBitSet
extends AbstractShortSet
implements ShortSortedSet,
Cloneable,
Serializable {
    private static final int BITS_PER_LONG = 64;
    private static final int BIT_MASK = 63;
    private static final int BIT_MASK_BITS = 6;
    private static final int DEFAULT_CAPACITY = 64;
    private long[] data;
    private int size;

    public ShortBitSet(short maximum) {
        if (maximum < 0) {
            Exceptions.negativeArgument("maximum", String.valueOf(maximum));
        }
        this.data = new long[1 + ShortBitSet.longIndex(maximum)];
        this.size = 0;
    }

    public ShortBitSet() {
        this(64);
    }

    public ShortBitSet(ShortCollection c) {
        this();
        this.addAll(c);
    }

    public ShortBitSet(short[] a) {
        this(ShortBitSet.amax(a));
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    private static short amax(short[] a) {
        short max = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    private static int longIndex(int index) {
        return index >> 6;
    }

    private static int bitIndex(int index) {
        return index & 0x3F;
    }

    private static long bit(int bitno) {
        return 1L << bitno;
    }

    private static int largestBitIndexOf(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException("No elements left");
        }
        int bitIndex = 63;
        long bit = 1L << bitIndex;
        while ((v & bit) == 0L) {
            --bitIndex;
            bit >>= 1;
        }
        return bitIndex;
    }

    private static int smallestBitIndexOf(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException("No elements left");
        }
        int bitIndex = 0;
        long bit = 1L;
        while ((v & bit) == 0L) {
            ++bitIndex;
            bit <<= 1;
        }
        return bitIndex;
    }

    private static int countBits(long v) {
        int count = 0;
        int bitIndex = 0;
        long bit = 1L;
        do {
            if ((v & bit) != 0L) {
                ++count;
            }
            bit <<= 1;
        } while (++bitIndex < 64);
        return count;
    }

    private static long lowMask(int n) {
        long v = 0L;
        int i = 0;
        while (i < n) {
            v = v << 1 | 1L;
            ++i;
        }
        return v;
    }

    private static long highMask(int n) {
        return ShortBitSet.lowMask(n) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void ensureCapacity(int maximum) {
        int newcapacity;
        if (maximum < 0) {
            Exceptions.negativeArgument("maximum", String.valueOf(maximum));
        }
        if (this.data.length < (newcapacity = 1 + ShortBitSet.longIndex(maximum))) {
            long[] newdata = new long[newcapacity];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
        }
    }

    public boolean add(short value) {
        long bit;
        boolean result;
        int longIndex;
        if (value < 0) {
            Exceptions.negativeArgument("value", String.valueOf(value));
        }
        if (this.data.length < 1 + (longIndex = ShortBitSet.longIndex(value))) {
            this.ensureCapacity(value);
        }
        boolean bl = result = (this.data[longIndex] & (bit = ShortBitSet.bit(ShortBitSet.bitIndex(value)))) == 0L;
        if (result) {
            ++this.size;
        }
        int n = longIndex;
        this.data[n] = this.data[n] | bit;
        return result;
    }

    public ShortIterator iterator() {
        if (this.size == 0) {
            return new ShortIterator(){

                public boolean hasNext() {
                    return false;
                }

                public short next() {
                    Exceptions.endOfIterator();
                    throw new RuntimeException();
                }

                public void remove() {
                    Exceptions.noElementToRemove();
                }
            };
        }
        return new ShortIterator(){
            int nextLongIndex = this.nextLongIndex(0);
            int nextBitIndex = this.nextLongIndex < ShortBitSet.access$000(ShortBitSet.this).length ? this.nextBitIndex(this.nextLongIndex, 0) : 0;
            int lastValue = -1;

            int nextLongIndex(int index) {
                while (index < ShortBitSet.this.data.length && ShortBitSet.this.data[index] == 0L) {
                    ++index;
                }
                return index;
            }

            int nextBitIndex(int longIndex, int bitIndex) {
                long v = ShortBitSet.this.data[longIndex];
                long bit = 1L << bitIndex;
                while (bitIndex < 64 && (v & bit) == 0L) {
                    ++bitIndex;
                    bit <<= 1;
                }
                return bitIndex;
            }

            public boolean hasNext() {
                return this.nextLongIndex < ShortBitSet.this.data.length;
            }

            public short next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (short)(this.nextLongIndex * 64 + this.nextBitIndex);
                this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, this.nextBitIndex + 1);
                if (this.nextBitIndex == 64) {
                    this.nextLongIndex = this.nextLongIndex(this.nextLongIndex + 1);
                    if (this.nextLongIndex < ShortBitSet.this.data.length) {
                        this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, 0);
                    }
                }
                return (short)this.lastValue;
            }

            public void remove() {
                if (this.lastValue < 0) {
                    Exceptions.noElementToRemove();
                }
                ShortBitSet.this.remove((short)this.lastValue);
                this.lastValue = -1;
            }
        };
    }

    public void trimToSize() {
        int n = this.data.length - 1;
        while (n >= 0 && this.data[n] == 0L) {
            --n;
        }
        if (n < this.data.length - 1) {
            long[] newdata = new long[1 + n];
            System.arraycopy(this.data, 0, newdata, 0, newdata.length);
            this.data = newdata;
        }
    }

    public Object clone() {
        try {
            ShortBitSet c = (ShortBitSet)super.clone();
            c.data = new long[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = 0L;
            ++i;
        }
        this.size = 0;
    }

    public boolean contains(short value) {
        if (value < 0) {
            return false;
        }
        int longIndex = ShortBitSet.longIndex(value);
        if (longIndex >= this.data.length) {
            return false;
        }
        long bit = ShortBitSet.bit(ShortBitSet.bitIndex(value));
        return (this.data[longIndex] & bit) != 0L;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean remove(short value) {
        boolean result;
        if (value < 0) {
            return false;
        }
        int longIndex = ShortBitSet.longIndex(value);
        if (longIndex >= this.data.length) {
            return false;
        }
        long bit = ShortBitSet.bit(ShortBitSet.bitIndex(value));
        boolean bl = result = (this.data[longIndex] & bit) != 0L;
        if (result) {
            --this.size;
        }
        int n = longIndex;
        this.data[n] = this.data[n] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public int size() {
        return this.size;
    }

    private short firstFrom(short from) {
        int longIndex;
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        if ((longIndex = ShortBitSet.longIndex(from)) >= this.data.length) {
            Exceptions.setNoFirst();
        }
        long v = this.data[longIndex];
        v &= ShortBitSet.highMask(ShortBitSet.bitIndex(from));
        try {
            while (true) {
                if (v != 0L) {
                    int bitIndex = ShortBitSet.smallestBitIndexOf(v);
                    return (short)(64 * longIndex + bitIndex);
                }
                v = this.data[++longIndex];
            }
        }
        catch (IndexOutOfBoundsException e) {
            Exceptions.setNoFirst();
            throw new RuntimeException();
        }
    }

    public short first() {
        return this.firstFrom((short)0);
    }

    private short lastFrom(short from) {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        int longIndex = Math.min(ShortBitSet.longIndex(from), this.data.length - 1);
        long v = this.data[longIndex];
        v &= ShortBitSet.lowMask(ShortBitSet.bitIndex(from) + 1);
        try {
            while (true) {
                if (v != 0L) {
                    int bitIndex = ShortBitSet.largestBitIndexOf(v);
                    return (short)(64 * longIndex + bitIndex);
                }
                v = this.data[--longIndex];
            }
        }
        catch (IndexOutOfBoundsException e) {
            Exceptions.setNoLast();
            throw new RuntimeException();
        }
    }

    public short last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        int longIndex = this.data.length - 1;
        while (this.data[longIndex] == 0L) {
            --longIndex;
        }
        long v = this.data[longIndex];
        int bitIndex = 63;
        long bit = 1L << bitIndex;
        while ((v & bit) == 0L) {
            --bitIndex;
            bit >>= 1;
        }
        return (short)(64 * longIndex + bitIndex);
    }

    public ShortSortedSet headSet(short to) {
        return new SubSet(false, 0, true, to);
    }

    public ShortSortedSet tailSet(short from) {
        return new SubSet(true, from, false, 0);
    }

    public ShortSortedSet subSet(short from, short to) {
        return new SubSet(true, from, true, to);
    }

    private class SubSet
    extends AbstractShortSet
    implements ShortSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private short lowerBound;
        private short upperBound;

        SubSet(boolean hasLowerBound, short lowerBound, boolean hasUpperBound, short upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(short v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ShortBitSet.this.add(v);
        }

        public boolean remove(short v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ShortBitSet.this.remove(v);
        }

        public boolean contains(short v) {
            return this.inSubRange(v) && ShortBitSet.this.contains(v);
        }

        public ShortIterator iterator() {
            return new SubSetIterator();
        }

        public int size() {
            int size;
            int longIndexLow;
            if (ShortBitSet.this.size() == 0) {
                return 0;
            }
            try {
                longIndexLow = ShortBitSet.longIndex(this.first());
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            int longIndexHigh = ShortBitSet.longIndex(this.last());
            if (longIndexLow == longIndexHigh) {
                long v = ShortBitSet.this.data[longIndexLow];
                if (this.hasLowerBound) {
                    v &= ShortBitSet.highMask(ShortBitSet.bitIndex(this.lowerBound));
                }
                if (this.hasUpperBound) {
                    v &= ShortBitSet.lowMask(ShortBitSet.bitIndex(this.upperBound));
                }
                size = ShortBitSet.countBits(v);
            } else {
                long vLow = ShortBitSet.this.data[longIndexLow];
                if (this.hasLowerBound) {
                    vLow &= ShortBitSet.highMask(ShortBitSet.bitIndex(this.lowerBound));
                }
                long vHigh = ShortBitSet.this.data[longIndexHigh];
                if (this.hasUpperBound) {
                    vHigh &= ShortBitSet.lowMask(ShortBitSet.bitIndex(this.upperBound));
                }
                size = ShortBitSet.countBits(vLow) + ShortBitSet.countBits(vHigh);
                int i = longIndexLow + 1;
                while (i < longIndexHigh) {
                    size += ShortBitSet.countBits(ShortBitSet.this.data[i]);
                    ++i;
                }
            }
            return size;
        }

        public short first() {
            short first = ShortBitSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : (short)0);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public short last() {
            short last = ShortBitSet.this.lastFrom(this.hasUpperBound ? (short)(this.upperBound - 1) : ShortBitSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public ShortSortedSet headSet(short to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public ShortSortedSet tailSet(short from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public ShortSortedSet subSet(short from, short to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(short v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class SubSetIterator
        implements ShortIterator {
            int longIndexLow;
            int longIndexHigh;
            long vLow;
            long vHigh;
            boolean isEmpty = false;
            int nextLongIndex;
            int nextBitIndex;
            int lastValue = -1;

            SubSetIterator() {
                try {
                    this.longIndexLow = ShortBitSet.longIndex(SubSet.this.first());
                }
                catch (NoSuchElementException e) {
                    this.isEmpty = true;
                }
                if (!this.isEmpty) {
                    this.longIndexHigh = ShortBitSet.longIndex(SubSet.this.last());
                    if (this.longIndexLow == this.longIndexHigh) {
                        long v = ShortBitSet.this.data[this.longIndexLow];
                        if (SubSet.this.hasLowerBound) {
                            v &= ShortBitSet.highMask(ShortBitSet.bitIndex(SubSet.this.lowerBound));
                        }
                        if (SubSet.this.hasUpperBound) {
                            v &= ShortBitSet.lowMask(ShortBitSet.bitIndex(SubSet.this.upperBound));
                        }
                        ShortBitSet.this.size = ShortBitSet.countBits(v);
                        this.vLow = this.vHigh = v;
                    } else {
                        this.vLow = ShortBitSet.this.data[this.longIndexLow];
                        if (SubSet.this.hasLowerBound) {
                            this.vLow &= ShortBitSet.highMask(ShortBitSet.bitIndex(SubSet.this.lowerBound));
                        }
                        this.vHigh = ShortBitSet.this.data[this.longIndexHigh];
                        if (SubSet.this.hasUpperBound) {
                            this.vHigh &= ShortBitSet.lowMask(ShortBitSet.bitIndex(SubSet.this.upperBound));
                        }
                    }
                    this.nextLongIndex = this.longIndexLow;
                    this.nextBitIndex = ShortBitSet.smallestBitIndexOf(this.vLow);
                }
            }

            long data(int longIndex) {
                if (longIndex == this.longIndexLow) {
                    return this.vLow;
                }
                if (longIndex == this.longIndexHigh) {
                    return this.vHigh;
                }
                return ShortBitSet.this.data[longIndex];
            }

            int nextLongIndex(int index) {
                while (index <= this.longIndexHigh && this.data(index) == 0L) {
                    ++index;
                }
                return index;
            }

            int nextBitIndex(int longIndex, int bitIndex) {
                long v = this.data(longIndex);
                long bit = 1L << bitIndex;
                while (bitIndex < 64 && (v & bit) == 0L) {
                    ++bitIndex;
                    bit <<= 1;
                }
                return bitIndex;
            }

            public boolean hasNext() {
                return !this.isEmpty && this.nextLongIndex <= this.longIndexHigh;
            }

            public short next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (short)(this.nextLongIndex * 64 + this.nextBitIndex);
                this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, this.nextBitIndex + 1);
                if (this.nextBitIndex == 64) {
                    this.nextLongIndex = this.nextLongIndex(this.nextLongIndex + 1);
                    if (this.nextLongIndex < ShortBitSet.this.data.length) {
                        this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, 0);
                    }
                }
                return (short)this.lastValue;
            }

            public void remove() {
                if (this.lastValue < 0) {
                    Exceptions.noElementToRemove();
                }
                ShortBitSet.this.remove((short)this.lastValue);
                this.lastValue = -1;
            }
        }
    }
}

