/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ShortCollection;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.CharKeyShortMap;
import bak.pcj.map.CharKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractCharKeyShortMap
implements CharKeyShortMap {
    protected AbstractCharKeyShortMap() {
    }

    public void clear() {
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public short remove(char key) {
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            short value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultShort();
    }

    public void putAll(CharKeyShortMap map) {
        CharKeyShortMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(char key) {
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public short get(char key) {
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultShort();
    }

    public boolean containsValue(short value) {
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CharKeyShortMap)) {
            return false;
        }
        CharKeyShortMap map = (CharKeyShortMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            char k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultCharHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultShortHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public short tget(char key) {
        short value = this.get(key);
        if (value == MapDefaults.defaultShort() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        CharKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ShortCollection values();

    public abstract short put(char var1, short var2);

    public abstract short lget();

    public abstract CharSet keySet();

    public abstract CharKeyShortMapIterator entries();
}

