/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.DoubleCollection;
import bak.pcj.adapter.CollectionToDoubleCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyDoubleMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyDoubleMap;
import bak.pcj.map.ObjectKeyDoubleMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyDoubleMapAdapter
extends AbstractObjectKeyDoubleMap
implements ObjectKeyDoubleMap {
    protected Map map;
    protected Double lastValue;

    public MapToObjectKeyDoubleMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyDoubleMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Double)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(double value) {
        return this.map.containsValue(new Double(value));
    }

    public ObjectKeyDoubleMapIterator entries() {
        return new ObjectKeyDoubleMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyDoubleMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public double getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public double get(Object key) {
        Double value = (Double)this.map.get(key);
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public double lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public double put(Object key, double value) {
        Double oldValue = this.map.put(key, new Double(value));
        return oldValue == null ? MapDefaults.defaultDouble() : oldValue;
    }

    public double remove(Object key) {
        Double value = (Double)this.map.remove(key);
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public int size() {
        return this.map.size();
    }

    public DoubleCollection values() {
        return new CollectionToDoubleCollectionAdapter(this.map.values());
    }

    public double tget(Object key) {
        Double value = (Double)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isObjectKeyDoubleAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

