/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractShortCollection;
import bak.pcj.Adapter;
import bak.pcj.ShortIterator;
import bak.pcj.adapter.IteratorToShortIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToShortCollectionAdapter
extends AbstractShortCollection {
    protected Collection collection;

    public CollectionToShortCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToShortCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(short v) {
        return this.collection.add(new Short(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(short v) {
        return this.collection.contains(new Short(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public ShortIterator iterator() {
        return new IteratorToShortIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(short v) {
        return this.collection.remove(new Short(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isShortAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

