/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.http.handler.RequestHandlerSupport;
import ro.isdc.wro.http.support.ResponseHeadersConfigurer;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.util.WroUtil;

public class ReloadCacheRequestHandler
extends RequestHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadCacheRequestHandler.class);
    public static final String ALIAS = "reloadCache";
    public static final String ENDPOINT_URI = "wroAPI/reloadCache";
    @Inject
    private ReadOnlyContext context;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Context.get().getConfig().reloadCache();
        ResponseHeadersConfigurer.noCache().setHeaders(response);
        response.setStatus(200);
        LOG.debug("Cache is reloaded");
    }

    public boolean accept(HttpServletRequest request) {
        return WroUtil.matchesUrl(request, ENDPOINT_URI);
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.context.getConfig().isDebug();
    }
}

