/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.xml;

import javax.xml.parsers.SAXParserFactory;
import org.openrdf.util.log.ThreadLog;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderFactory {
    public static final String XERCES_SAXPARSER = "org.apache.xerces.parsers.SAXParser";

    public static XMLReader createXMLReader() throws SAXException {
        XMLReader reader = null;
        String xmlReaderName = System.getProperty("org.xml.sax.driver");
        if (xmlReaderName != null) {
            try {
                reader = XMLReaderFactory._createXMLReader(xmlReaderName);
            }
            catch (ClassNotFoundException e) {
                ThreadLog.warning("Class " + xmlReaderName + " not found");
            }
            catch (ClassCastException e) {
                ThreadLog.warning(xmlReaderName + " is not a valid XMLReader.");
            }
            catch (Exception e) {
                ThreadLog.warning("could not create instance of " + xmlReaderName);
            }
            ThreadLog.trace("XMLReader initialized using system property: " + xmlReaderName);
        }
        if (reader == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                reader = factory.newSAXParser().getXMLReader();
            }
            catch (NoClassDefFoundError e) {
                ThreadLog.warning("javax.xml.parsers.SAXParserFactory not available");
            }
            catch (Exception e) {
                ThreadLog.warning("Failed to initialize XMLReader through JAXP");
            }
            ThreadLog.trace("XMLReader initialized using JAXP: " + reader);
        }
        if (reader == null) {
            try {
                reader = XMLReaderFactory._createXMLReader(XERCES_SAXPARSER);
            }
            catch (ClassNotFoundException e) {
                String message = "Class org.apache.xerces.parsers.SAXParser not found";
                ThreadLog.error(message);
                throw new SAXException(message);
            }
            catch (ClassCastException e) {
                String message = "org.apache.xerces.parsers.SAXParser is not a valid XMLReader.";
                ThreadLog.error(message);
                throw new SAXException(message);
            }
            catch (Exception e) {
                String message = "Could not create instance of org.apache.xerces.parsers.SAXParser";
                ThreadLog.error(message);
                throw new SAXException(message);
            }
            ThreadLog.trace("XMLReader initialized using default Xerces SAX parser org.apache.xerces.parsers.SAXParser");
        }
        return reader;
    }

    public static XMLReader createXMLReader(String name) throws SAXException {
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory._createXMLReader(name);
        }
        catch (ClassNotFoundException e) {
            ThreadLog.error("Class " + name + " not found");
            throw new SAXException(e);
        }
        catch (ClassCastException e) {
            ThreadLog.error(name + " is not a valid XMLReader.");
            throw new SAXException(e);
        }
        catch (Exception e) {
            ThreadLog.error("Could not create instance of " + name);
            throw new SAXException(e);
        }
        return reader;
    }

    protected static XMLReader _createXMLReader(String name) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
        return (XMLReader)Class.forName(name).newInstance();
    }
}

