/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;

public class S3Credentials {
    private AmazonS3 client = null;
    private AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
    private String keyPrefix = System.getenv("AWS_S3_PREFIX");
    private String bucket = System.getenv("AWS_S3_BUCKET");
    private String accessKey = null;
    private String secretKey = null;
    private String region = System.getenv("AWS_DEFAULT_REGION");
    private String endpoint = System.getenv("AWS_S3_ENDPOINT");

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @PostConstruct
    public void init() {
        if (!this.keyPrefix.endsWith("/")) {
            this.keyPrefix = this.keyPrefix + "/";
        }
        if (this.accessKey != null && this.secretKey != null) {
            this.builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey)));
            this.accessKey = null;
            this.secretKey = null;
        } else {
            this.builder.withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
        }
        if (this.region != null) {
            if (this.endpoint != null) {
                this.builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.region));
            } else {
                this.builder.withRegion(this.region);
            }
        }
        this.client = (AmazonS3)this.builder.build();
        this.builder = null;
        if (this.bucket == null) {
            throw new RuntimeException("Missing the bucket configuration");
        }
    }

    @Nonnull
    public AmazonS3 getClient() {
        return this.client;
    }

    @Nonnull
    public String getBucket() {
        return this.bucket;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }
}

