/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jcs.access.exception.CacheException;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.kernel.search.spatial.ErrorHandler;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Parser;
import org.jdom.Element;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.xml.sax.SAXException;

public class SpatialIndexWriter
implements FeatureListener {
    public static final String _IDS_ATTRIBUTE_NAME = "metadataid";
    public static final String _SPATIAL_INDEX_TYPENAME = "spatialindex";
    public static final int MAX_WRITES_IN_TRANSACTION = 1000;
    static final String SPATIAL_FILTER_JCS = "SpatialFilterCache";
    private static int _writes;
    private final Parser[] _parsers;
    private final Transaction _transaction;
    private final Lock _lock;
    private int _maxWrites;
    private FeatureStore<SimpleFeatureType, SimpleFeature> _featureStore;
    private STRtree _index;
    private Map<String, String> errorMessage;
    private Name _idColumn;
    private boolean _autocommit;

    public SpatialIndexWriter(DataStore datastore, Parser[] parsers, Transaction transaction, int maxWrites, Lock lock) throws Exception {
        this._lock = lock;
        for (Parser _parser : this._parsers = parsers) {
            _parser.setStrict(false);
            _parser.setValidating(false);
        }
        this._transaction = transaction;
        this._maxWrites = maxWrites;
        this._featureStore = this.createFeatureStore(datastore);
        boolean bl = this._autocommit = maxWrites < 2;
        if (!this._autocommit) {
            this._featureStore.setTransaction(this._transaction);
        }
        this._featureStore.addFeatureListener((FeatureListener)this);
    }

    static MultiPolygon extractGeometriesFrom(Path schemaDir, Element metadata, Parser[] parsers, Map<String, String> errorMessage) throws Exception {
        return SpatialIndexWriter.getSpatialExtent(schemaDir, metadata, parsers, new SpatialIndexingErrorHandler(errorMessage));
    }

    public static MultiPolygon getSpatialExtent(Path schemaDir, Element metadata, Parser[] parsers, ErrorHandler errorHandler) throws Exception {
        Logging.getLogger((String)"org.geotools.xml").setLevel(Level.SEVERE);
        Path sSheet = schemaDir.resolve("extract-gml.xsl").toAbsolutePath();
        Element transform = Xml.transform((Element)metadata, (Path)sSheet);
        if (transform.getChildren().size() == 0) {
            return null;
        }
        ArrayList<Polygon> allPolygons = new ArrayList<Polygon>();
        for (Element geom : transform.getChildren()) {
            Parser parser = null;
            parser = geom.getNamespace().equals((Object)Geonet.Namespaces.GML32) ? parsers[1] : parsers[0];
            String srs = geom.getAttributeValue("srsName");
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            String gml = Xml.getString((Element)geom);
            try {
                if (srs != null && !srs.equals("")) {
                    sourceCRS = CRS.decode((String)srs);
                }
                MultiPolygon jts = SpatialIndexWriter.parseGml(parser, gml);
                if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
                    MathTransform tform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    jts = (MultiPolygon)JTS.transform((Geometry)jts, (MathTransform)tform);
                }
                for (int i = 0; i < jts.getNumGeometries(); ++i) {
                    allPolygons.add((Polygon)jts.getGeometryN(i));
                }
            }
            catch (Exception e) {
                errorHandler.handleParseException(e, gml);
            }
        }
        if (allPolygons.isEmpty()) {
            return null;
        }
        try {
            Polygon[] array = new Polygon[allPolygons.size()];
            GeometryFactory geometryFactory = ((Polygon)allPolygons.get(0)).getFactory();
            return geometryFactory.createMultiPolygon(allPolygons.toArray(array));
        }
        catch (Exception e) {
            errorHandler.handleBuildException(e, allPolygons);
            return null;
        }
    }

    public static MultiPolygon parseGml(Parser parser, String gml) throws IOException, SAXException, ParserConfigurationException {
        Object value = parser.parse((Reader)new StringReader(gml));
        if (value instanceof HashMap) {
            HashMap map = (HashMap)value;
            ArrayList<Polygon> geoms = new ArrayList<Polygon>();
            for (Object entry : map.values()) {
                SpatialIndexWriter.addToList(geoms, entry);
            }
            if (geoms.isEmpty()) {
                return null;
            }
            if (geoms.size() > 1) {
                GeometryFactory factory = ((Polygon)geoms.get(0)).getFactory();
                return factory.createMultiPolygon(geoms.toArray(new Polygon[0]));
            }
            return SpatialIndexWriter.toMultiPolygon((Geometry)geoms.get(0));
        }
        if (value == null) {
            return null;
        }
        return SpatialIndexWriter.toMultiPolygon((Geometry)value);
    }

    public static void addToList(List<Polygon> geoms, Object entry) {
        if (entry instanceof Polygon) {
            geoms.add((Polygon)entry);
        } else if (entry instanceof Collection) {
            Collection collection = (Collection)entry;
            for (Object object : collection) {
                geoms.add((Polygon)object);
            }
        }
    }

    public Map<String, String> getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(Path schemaDir, String id, Element metadata) throws Exception {
        this._lock.lock();
        try {
            this._index = null;
            this.errorMessage = new HashMap<String, String>();
            MultiPolygon geometry = SpatialIndexWriter.extractGeometriesFrom(schemaDir, metadata, this._parsers, this.errorMessage);
            if (geometry != null && !geometry.getEnvelopeInternal().isNull()) {
                MemoryFeatureCollection features = new MemoryFeatureCollection((SimpleFeatureType)this._featureStore.getSchema());
                SimpleFeatureType schema = (SimpleFeatureType)this._featureStore.getSchema();
                SimpleFeature template = SimpleFeatureBuilder.template((SimpleFeatureType)schema, (String)SimpleFeatureBuilder.createDefaultFeatureId());
                template.setAttribute(schema.getGeometryDescriptor().getName(), (Object)geometry);
                template.setAttribute(this.getIdColumn(), (Object)id);
                features.add(template);
                this._featureStore.addFeatures((FeatureCollection)features);
                if (!this._autocommit && ++_writes > this._maxWrites) {
                    this._transaction.commit();
                    _writes = 0;
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private String getIdColumn() {
        this._lock.lock();
        try {
            if (this._idColumn == null) {
                this._idColumn = SpatialIndexWriter.findIdColumn(this._featureStore);
            }
            String string = this._idColumn == null ? _IDS_ATTRIBUTE_NAME : this._idColumn.toString();
            return string;
        }
        finally {
            this._lock.unlock();
        }
    }

    public void close() throws IOException {
        this._lock.lock();
        try {
            if (_writes > 0) {
                this._transaction.commit();
                _writes = 0;
            }
            this._transaction.close();
            this._index = null;
            this._featureStore.setTransaction(Transaction.AUTO_COMMIT);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.index", (Object)("SpatialIndexWriter close error: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this._lock.unlock();
        }
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource() {
        return this._featureStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) throws IOException {
        this._lock.lock();
        try {
            FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            PropertyIsEqualTo filter = factory.equals((Expression)factory.property(this.getIdColumn()), (Expression)factory.literal((Object)id));
            this._index = null;
            this._featureStore.removeFeatures((Filter)filter);
            try {
                SpatialFilter.getJCSCache().clear();
            }
            catch (Throwable e) {
                Log.error((String)"geonetwork.index", (Object)("SpatialIndexWriter JCSCache clear error: " + e.getMessage()), (Throwable)e);
            }
            ++_writes;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(List<String> ids) throws IOException {
        this._lock.lock();
        try {
            FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            LinkedList<PropertyIsEqualTo> filters = new LinkedList<PropertyIsEqualTo>();
            String idColumn = this.getIdColumn();
            for (String id : ids) {
                filters.add(factory.equals((Expression)factory.property(idColumn), (Expression)factory.literal((Object)id)));
            }
            this._index = null;
            this._featureStore.removeFeatures((Filter)factory.or(filters));
            try {
                SpatialFilter.getJCSCache().clear();
            }
            catch (Throwable e) {
                Log.error((String)"geonetwork.index", (Object)("SpatialIndexWriter JCSCache clear error: " + e.getMessage()), (Throwable)e);
            }
            ++_writes;
        }
        finally {
            this._lock.unlock();
        }
    }

    public void commit() throws IOException {
        this._lock.lock();
        try {
            if (!this._autocommit && _writes > 0) {
                _writes = 0;
                this._transaction.commit();
                this._index = null;
                SpatialFilter.getJCSCache().clear();
            }
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.index", (Object)("SpatialIndexWriter JCSCache commit error: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this._lock.unlock();
        }
    }

    public SpatialIndex getIndex() throws IOException {
        this._lock.lock();
        try {
            if (this._index == null) {
                this.populateIndex();
            }
            STRtree sTRtree = this._index;
            return sTRtree;
        }
        finally {
            this._lock.unlock();
        }
    }

    public void reset() throws Exception {
        this._lock.lock();
        try {
            this._featureStore.setTransaction(Transaction.AUTO_COMMIT);
            this._index = null;
            this._featureStore.removeFeatures((Filter)Filter.INCLUDE);
            this._featureStore.setTransaction(this._transaction);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void populateIndex() throws IOException {
        try {
            SpatialFilter.getJCSCache().clear();
        }
        catch (CacheException e) {
            Log.error((String)"geonetwork.index", (Object)("SpatialIndexWriter JCSCache clear error: " + e.getMessage()), (Throwable)e);
        }
        this._index = new STRtree();
        try (FeatureIterator features = null;){
            features = this._featureStore.getFeatures().features();
            while (features.hasNext()) {
                SimpleFeature feature = (SimpleFeature)features.next();
                if (this._idColumn == null) {
                    this._idColumn = SpatialIndexWriter.findIdColumn(this._featureStore);
                }
                if (feature.getDefaultGeometry() == null) continue;
                this.insertFeatureInIndex(feature);
            }
        }
    }

    private FeatureStore<SimpleFeatureType, SimpleFeature> createFeatureStore(DataStore datastore) throws Exception {
        Log.debug((String)"geonetwork.spatial", (Object)"Configuring SpatialIndexWriter.");
        FeatureStore<SimpleFeatureType, SimpleFeature> featureSource = SpatialIndexWriter.findSpatialIndexStore(datastore);
        if (featureSource != null) {
            this._idColumn = SpatialIndexWriter.findIdColumn(featureSource);
            if (this._idColumn == null) {
                throw new IllegalArgumentException("ERROR, unable to find _idColumn!!! in \n    DataStore: " + featureSource.getDataStore() + "\n    FeatureType: " + featureSource.getSchema());
            }
            return featureSource;
        }
        return null;
    }

    public static FeatureStore<SimpleFeatureType, SimpleFeature> findSpatialIndexStore(DataStore datastore) throws IOException {
        Log.debug((String)"geonetwork.spatial", (Object)"Attempting to find FeatureType");
        for (String name : datastore.getTypeNames()) {
            Log.debug((String)"geonetwork.spatial", (Object)("Found FeatureType: " + name));
            if (!_SPATIAL_INDEX_TYPENAME.equalsIgnoreCase(name)) continue;
            Log.debug((String)"geonetwork.spatial", (Object)("Found the spatial index FeatureType: " + name));
            return (FeatureStore)datastore.getFeatureSource(name);
        }
        return SpatialIndexWriter.attemptToCreateSpatialIndexFeatureStore(datastore);
    }

    private static FeatureStore<SimpleFeatureType, SimpleFeature> attemptToCreateSpatialIndexFeatureStore(DataStore datastore) throws IOException {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(_SPATIAL_INDEX_TYPENAME);
        typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.add("geom", MultiPolygon.class);
        typeBuilder.add(_IDS_ATTRIBUTE_NAME, String.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        datastore.createSchema((FeatureType)type);
        return (FeatureStore)datastore.getFeatureSource(type.getTypeName());
    }

    public static Name findIdColumn(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource) {
        Log.debug((String)"geonetwork.spatial", (Object)("Trying to find metadataid attribute in " + featureSource.getSchema()));
        for (AttributeDescriptor descriptor : ((SimpleFeatureType)featureSource.getSchema()).getAttributeDescriptors()) {
            Log.debug((String)"geonetwork.spatial", (Object)("Found attribute " + descriptor.getLocalName()));
            if (!_IDS_ATTRIBUTE_NAME.equalsIgnoreCase(descriptor.getLocalName())) continue;
            Log.debug((String)"geonetwork.spatial", (Object)("Found the id attribute of the spatial index: " + descriptor.getLocalName()));
            return descriptor.getName();
        }
        if (((SimpleFeatureType)featureSource.getSchema()).getDescriptor("fid") != null) {
            return ((SimpleFeatureType)featureSource.getSchema()).getDescriptor("fid").getName();
        }
        return null;
    }

    public static MultiPolygon toMultiPolygon(Geometry geometry) {
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return geometry.getFactory().createMultiPolygon(new Polygon[]{polygon});
        }
        if (geometry instanceof MultiPolygon) {
            return (MultiPolygon)geometry;
        }
        String message = geometry.getClass() + " cannot be converted to a polygon. Check metadata";
        Log.error((String)"geonetwork.index", (Object)message);
        throw new IllegalArgumentException(message);
    }

    public void changed(FeatureEvent featureEvent) {
        try {
            switch (featureEvent.getType()) {
                case ADDED: {
                    break;
                }
                case CHANGED: {
                    SpatialFilter.getJCSCache().clear();
                    break;
                }
                case REMOVED: {
                    SpatialFilter.getJCSCache().clear();
                    break;
                }
                case COMMIT: {
                    SpatialFilter.getJCSCache().clear();
                    break;
                }
                case ROLLBACK: {
                    SpatialFilter.getJCSCache().clear();
                    break;
                }
                default: {
                    SpatialFilter.getJCSCache().clear();
                    break;
                }
            }
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    private void insertFeatureInIndex(SimpleFeature feature) {
        Geometry defaultGeometry = (Geometry)feature.getDefaultGeometry();
        if (defaultGeometry instanceof MultiPolygon && defaultGeometry.getNumGeometries() > 1) {
            for (int i = 0; i < defaultGeometry.getNumGeometries(); ++i) {
                Data data = this.buildData(feature, defaultGeometry.getNumGeometries());
                Envelope envelope = defaultGeometry.getGeometryN(i).getEnvelopeInternal();
                data.setEnv(envelope);
                this._index.insert(envelope, (Object)data);
            }
        } else {
            Data data = this.buildData(feature, 1);
            Envelope envelope = defaultGeometry.getEnvelopeInternal();
            data.setEnv(envelope);
            this._index.insert(envelope, (Object)data);
        }
    }

    private Data buildData(SimpleFeature feature, int numBrotherGeometries) {
        Data data = new Data();
        data.setMetadataId(feature.getAttribute(this._idColumn == null ? _IDS_ATTRIBUTE_NAME : this._idColumn.toString()).toString());
        data.setFeatureId(feature.getIdentifier());
        data.setNumBrotherGeometries(numBrotherGeometries);
        return data;
    }

    public class Data {
        private FeatureId featureId;
        private String metadataId;
        private Envelope env;
        private int numBrotherGeometries;

        public Envelope getEnv() {
            return this.env;
        }

        public void setEnv(Envelope env) {
            this.env = env;
        }

        public FeatureId getFeatureId() {
            return this.featureId;
        }

        public void setFeatureId(FeatureId featureId) {
            this.featureId = featureId;
        }

        public String getMetadataId() {
            return this.metadataId;
        }

        public void setMetadataId(String metadataId) {
            this.metadataId = metadataId;
        }

        public int getNumBrotherGeometries() {
            return this.numBrotherGeometries;
        }

        public void setNumBrotherGeometries(int numBrotherGeometries) {
            this.numBrotherGeometries = numBrotherGeometries;
        }
    }

    private static class SpatialIndexingErrorHandler
    implements ErrorHandler {
        private final Map<String, String> errorMessage;

        public SpatialIndexingErrorHandler(Map<String, String> errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public void handleParseException(Exception e, String gml) {
            this.errorMessage.put("PARSE", gml + ". Error is:" + e.getMessage());
            Log.error((String)"geonetwork.index", (Object)("Failed to convert gml to jts object: " + gml + "\n\t" + e.getMessage()), (Throwable)e);
        }

        @Override
        public void handleBuildException(Exception e, List<Polygon> allPolygons) {
            this.errorMessage.put("BUILD", allPolygons + ". Error is:" + e.getMessage());
            Log.error((String)"geonetwork.index", (Object)("Failed to create a MultiPolygon from: " + allPolygons), (Throwable)e);
        }
    }
}

