/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.facet;

import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.search.facet.SummaryType;

public class SummaryTypes {
    private static final String SUMMARY_TYPES_HEADER = " * Summary Type Configuration:\n";
    private List<SummaryType> summaryTypes;

    public SummaryTypes(List<SummaryType> summaryTypes) {
        this.summaryTypes = summaryTypes;
    }

    public List<SummaryType> getSummaryTypes() {
        return new ArrayList<SummaryType>(this.summaryTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(SUMMARY_TYPES_HEADER);
        for (SummaryType summaryType : this.summaryTypes) {
            sb.append(summaryType);
        }
        return sb.toString();
    }

    public SummaryType get(String resultType) {
        for (SummaryType summaryType : this.summaryTypes) {
            if (!summaryType.getName().equals(resultType)) continue;
            return summaryType;
        }
        throw new BadParameterEx("summaryItems", (Object)("Could not find summary type '" + resultType + "'. Check your summaryType configuration"));
    }
}

