/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.BaseHandler;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

class SimpleTypeEntry
extends BaseHandler {
    public String name;
    public List<String> alTypes = new ArrayList<String>();
    public List<String> alEnum = new ArrayList<String>();

    public SimpleTypeEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public SimpleTypeEntry(ElementInfo ei) {
        this.name = this.handleAttribs(ei, null);
        this.handleChildren(ei);
    }

    public String toString() {
        int j;
        StringBuffer sb = new StringBuffer();
        sb.append("SimpleTypeEntry name:" + this.name + " Enums:[");
        for (j = 0; j < this.alEnum.size(); ++j) {
            sb.append(this.alEnum.get(j) + ", ");
        }
        sb.append("], types:[");
        for (j = 0; j < this.alTypes.size(); ++j) {
            sb.append(this.alTypes.get(j) + ", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Object aChildren : children) {
            Element elChild = (Element)aChildren;
            String elName = elChild.getName();
            if (elName.equals("restriction")) {
                List restrictions = elChild.getChildren();
                for (Object restriction : restrictions) {
                    Element elEnum = (Element)restriction;
                    String elemName = elEnum.getName();
                    if (elemName.equals("enumeration")) {
                        this.alEnum.add(elEnum.getAttributeValue("value"));
                        continue;
                    }
                    if (elemName.equals("minInclusive") || elemName.equals("maxInclusive") || elemName.equals("minExclusive") || elemName.equals("maxExclusive") || elemName.equals("pattern")) continue;
                    Logger.log();
                }
                continue;
            }
            if (elName.equals("union")) {
                String[] types;
                List simpleTypes = elChild.getChildren("simpleType", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
                if (simpleTypes.size() > 0) {
                    for (Object st : simpleTypes) {
                        Element stEl = (Element)st;
                        List restrictions = stEl.getChildren("restriction", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
                        for (Object r : restrictions) {
                            Element rEl = (Element)r;
                            List enumerationList = rEl.getChildren("enumeration", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
                            for (Object e : enumerationList) {
                                Element elEnum = (Element)e;
                                String v = elEnum.getAttributeValue("value");
                                this.alEnum.add(v);
                            }
                        }
                    }
                    continue;
                }
                String memberTypes = elChild.getAttributeValue("memberTypes");
                if (memberTypes == null) continue;
                for (String type : types = memberTypes.split(" ")) {
                    this.alTypes.add(type);
                }
                continue;
            }
            if (elName.equals("annotation")) continue;
            Logger.log();
        }
    }
}

