/*
 * Decompiled with CFR 0.152.
 */
package jeeves.services.session;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.jdom.Element;

public class Put
implements Service {
    String groupName;
    HashSet<String> inFields;

    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.groupName = params.getMandatoryValue("group");
        List<Element> l = params.getChildren("inFields", "field");
        if (l != null) {
            this.inFields = new HashSet();
            for (Element field : l) {
                this.inFields.add(field.getName());
            }
        }
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        UserSession session = context.getUserSession();
        Hashtable<String, Element> group = (Hashtable<String, Element>)session.getProperty(this.groupName);
        if (group == null) {
            group = new Hashtable<String, Element>();
        }
        for (Element child : params.getChildren()) {
            if (this.inFields != null && !this.inFields.contains(child.getName())) continue;
            group.put(child.getName(), child);
        }
        session.setProperty(this.groupName, group);
        return params;
    }
}

