/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;

public class ServerBeanPropertyUpdater {
    private String urlPlaceHolder;
    private Map<Object, Object> originalURLs = new HashMap<Object, Object>();
    private Map<Object, String> beans;

    public ServerBeanPropertyUpdater(String urlPlaceHolder, Map<Object, String> beans) {
        if (urlPlaceHolder.startsWith("@") && urlPlaceHolder.endsWith("@")) {
            this.urlPlaceHolder = urlPlaceHolder;
        }
        this.beans = beans;
    }

    public static void updateURL(String newURL, ApplicationContext context) throws Exception {
        Map updaters = context.getBeansOfType(ServerBeanPropertyUpdater.class);
        for (ServerBeanPropertyUpdater updater : updaters.values()) {
            updater.updateServerURL(newURL);
        }
    }

    public void updateServerURL(String baseURL) throws Exception {
        if (this.urlPlaceHolder != null) {
            for (Map.Entry<Object, String> bean : this.beans.entrySet()) {
                Object originalURL = this.originalURLs.get(bean.getKey());
                if (originalURL == null) {
                    originalURL = this.getValue(bean.getKey(), bean.getValue());
                    this.originalURLs.put(bean.getKey(), originalURL);
                }
                if (!(originalURL instanceof String)) continue;
                String url = (String)originalURL;
                String updatedURL = url.replace(this.urlPlaceHolder, baseURL);
                this.setValue(bean.getKey(), bean.getValue(), updatedURL);
            }
        }
    }

    private Object getValue(Object bean, String propertyName) throws Exception {
        PropertyDescriptor desc = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)propertyName);
        Method readMethod = desc.getReadMethod();
        if (readMethod != null) {
            readMethod.setAccessible(true);
            return readMethod.invoke(bean, new Object[0]);
        }
        return this.lookUpField(bean.getClass(), propertyName).get(bean);
    }

    private Field lookUpField(Class<?> beanClass, String propertyName) throws NoSuchFieldException {
        Field field;
        try {
            field = beanClass.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = beanClass.getSuperclass();
            if (superClass == null) {
                throw new NoSuchFieldException(propertyName + " not found");
            }
            field = this.lookUpField(superClass, propertyName);
        }
        field.setAccessible(true);
        return field;
    }

    private void setValue(Object bean, String propertyName, String newValue) throws Exception {
        PropertyDescriptor desc = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)propertyName);
        Method writeMethod = desc.getWriteMethod();
        if (writeMethod != null) {
            writeMethod.setAccessible(true);
            writeMethod.invoke(bean, newValue);
        }
        this.lookUpField(bean.getClass(), propertyName).set(bean, newValue);
    }
}

