/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.config.springutil.JeevesDelegatingFilterProxy;
import jeeves.services.ReadWriteController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ReadOnlyMvcInterceptor
extends HandlerInterceptorAdapter {
    public static final String SERVLET_CONTEXT_ATTR_KEY = "readOnlyMode";
    @Autowired
    ServletContext context;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Boolean isReadOnly = (Boolean)JeevesDelegatingFilterProxy.getServletContext(this.context).getAttribute(SERVLET_CONTEXT_ATTR_KEY);
            if (isReadOnly == null) {
                isReadOnly = false;
            }
            if (isReadOnly.booleanValue() && handlerMethod.getBean() != null && handlerMethod.getBean().getClass().getAnnotation(ReadWriteController.class) != null) {
                throw new InReadOnlyModeException(request.getPathInfo());
            }
        }
        return super.preHandle(request, response, handler);
    }

    private static class InReadOnlyModeException
    extends RuntimeException {
        InReadOnlyModeException(String req) {
            super("Server is in Readonly mode, requested service is not allowed when in read only mode: " + req);
        }
    }
}

