/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.swing.Icon;
import org.geotools.styling.ExternalMark;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.StyleVisitor;

public class ExternalMarkImpl
implements ExternalMark {
    private OnLineResource onlineResource;
    private Icon inlineContent;
    private int index;
    private String format;

    public ExternalMarkImpl() {
    }

    public ExternalMarkImpl(Icon icon) {
        this.inlineContent = icon;
        this.index = -1;
        this.onlineResource = null;
        this.format = null;
    }

    public ExternalMarkImpl(OnLineResource resource, String format, int markIndex) {
        this.inlineContent = null;
        this.index = markIndex;
        this.onlineResource = resource;
        this.format = format;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public Icon getInlineContent() {
        return this.inlineContent;
    }

    @Override
    public int getMarkIndex() {
        return this.index;
    }

    @Override
    public OnLineResource getOnlineResource() {
        return this.onlineResource;
    }

    public Object accept(StyleVisitor visitor, Object extraData) {
        return visitor.visit((org.opengis.style.ExternalMark)this, extraData);
    }

    @Override
    public void setInlineContent(Icon inline) {
        this.inlineContent = inline;
    }

    @Override
    public void getInlineContent(Icon inline) {
        this.setInlineContent(inline);
    }

    @Override
    public void setFormat(String mimeType) {
        this.format = mimeType;
    }

    @Override
    public void setMarkIndex(int markIndex) {
        this.index = markIndex;
    }

    @Override
    public void setOnlineResource(OnLineResource resource) {
        this.onlineResource = resource;
    }

    static ExternalMarkImpl cast(org.opengis.style.ExternalMark mark) {
        if (mark == null) {
            return null;
        }
        if (mark instanceof ExternalMarkImpl) {
            return (ExternalMarkImpl)mark;
        }
        ExternalMarkImpl copy = new ExternalMarkImpl();
        copy.setFormat(mark.getFormat());
        copy.setMarkIndex(mark.getMarkIndex());
        copy.setOnlineResource(mark.getOnlineResource());
        return copy;
    }
}

