/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.configuration.provider.xml;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.jzkit.ServiceDirectory.CollectionDescriptionDBO;
import org.jzkit.ServiceDirectory.CollectionInfoTypeDBO;
import org.jzkit.ServiceDirectory.SearchServiceDescriptionDBO;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.configuration.provider.xml.InMemoryImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class XMLImpl
extends InMemoryImpl
implements ApplicationContextAware {
    private Digester main_digester = null;
    private Digester profile_digester = null;
    private Digester query_crosswalk_digester = null;
    private String config_file = null;

    private XMLImpl() {
    }

    public XMLImpl(String config_file) {
        this.config_file = config_file;
    }

    public void init() {
        this.log.debug((Object)("Load config: " + this.config_file));
        try {
            this.load(this.config_file);
        }
        catch (IOException ioe) {
            this.log.error((Object)"Problem loading config", (Throwable)ioe);
        }
        catch (SAXException saxe) {
            this.log.error((Object)"Problem loading config", (Throwable)saxe);
        }
        this.initialise();
    }

    public XMLImpl(ApplicationContext ctx, String config_file) {
        if (ctx == null) {
            throw new RuntimeException("XMLIMpl ctx is null");
        }
        this.ctx = ctx;
        this.log.debug((Object)("Load config: " + config_file));
        try {
            this.load(config_file);
        }
        catch (IOException ioe) {
            this.log.error((Object)"Problem loading config", (Throwable)ioe);
        }
        catch (SAXException saxe) {
            this.log.error((Object)"Problem loading config", (Throwable)saxe);
        }
    }

    private void load(String config_resource) throws IOException, SAXException {
        URL config_source = XMLImpl.class.getResource(config_resource);
        URL rules = XMLImpl.class.getResource("DigesterRules.xml");
        URL profile_rules = XMLImpl.class.getResource("ApplicationProfileDigesterRules.xml");
        URL query_crosswalk_rules = XMLImpl.class.getResource("QueryCrosswalkDigesterRules.xml");
        this.log.debug((Object)("Loading rules : " + rules));
        this.main_digester = DigesterLoader.createDigester((URL)rules);
        this.profile_digester = DigesterLoader.createDigester((URL)profile_rules);
        this.query_crosswalk_digester = DigesterLoader.createDigester((URL)query_crosswalk_rules);
        this.main_digester.push((Object)this);
        this.log.debug((Object)"Parsing config");
        this.main_digester.parse(config_source.openStream());
        this.log.debug((Object)"Done Parsing config");
    }

    public void addCollection(String collection_code, String repository_code) throws ConfigurationException {
        this.log.debug((Object)("Add collection " + collection_code + " to repos " + repository_code));
        CollectionDescriptionDBO cd = this.lookupCollectionDescription(collection_code);
        this.log.debug((Object)("CollectionDescription=" + cd));
        SearchServiceDescriptionDBO ssd = this.lookupSearchService(repository_code);
        this.log.debug((Object)("SearchServiceDescription=" + ssd));
        if (cd == null || ssd == null) {
            throw new ConfigurationException("Unable to locate collection or repository information for collection instance");
        }
        cd.setSearchServiceDescription(ssd);
        this.log.debug((Object)"addCollection completed");
    }

    public void addLandscape(String landscape_code, String coll_code) throws ConfigurationException {
        this.log.debug((Object)("Add collection " + coll_code + " to landscape " + landscape_code));
    }

    public void registerClasspathProfile(String config_resource) throws IOException, SAXException {
        this.log.debug((Object)("registerClasspathProfile : " + config_resource + " (ctx=" + this.ctx + ")"));
        this.profile_digester.clear();
        this.profile_digester.push((Object)this);
        Resource r = this.ctx.getResource(config_resource);
        if (r.exists()) {
            URL config_source = r.getURL();
            this.log.debug((Object)("processing config " + config_source));
            this.profile_digester.parse(config_source.openStream());
        } else {
            this.log.warn((Object)("Unable to locate resource " + config_resource));
        }
    }

    public void registerClasspathQueryCrosswalk(String query_crosswalk_resource_path) throws IOException, SAXException {
        this.log.debug((Object)("registerClasspathQueryCrosswalk : " + query_crosswalk_resource_path));
        this.query_crosswalk_digester.clear();
        this.query_crosswalk_digester.push((Object)this);
        Resource r = this.ctx.getResource(query_crosswalk_resource_path);
        if (r.exists()) {
            URL config_source = r.getURL();
            this.log.debug((Object)("processing crosswalk " + config_source));
            this.query_crosswalk_digester.parse(config_source.openStream());
        } else {
            this.log.warn((Object)("Unable to locate resource " + query_crosswalk_resource_path));
        }
    }

    public void addPosting(String code, String name, String value) {
        this.log.debug((Object)("addPosting " + code + "," + name + "," + value));
        CollectionInfoTypeDBO it = this.lookupOrCreateCollectionInfoType(name, value);
        CollectionDescriptionDBO coll = this.lookupCollectionDescription(code);
        if (it != null && coll != null) {
            coll.getPostings().add(it);
            it.getCollections().add(coll);
        } else {
            this.log.error((Object)("Error loading config - coll or infotype null - coll=" + coll + ", it=" + it));
        }
    }
}

