/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.IntCollection;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.FloatKeyIntMap;
import bak.pcj.map.FloatKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractFloatKeyIntMap
implements FloatKeyIntMap {
    protected AbstractFloatKeyIntMap() {
    }

    public void clear() {
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public int remove(float key) {
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            int value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultInt();
    }

    public void putAll(FloatKeyIntMap map) {
        FloatKeyIntMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(float key) {
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public int get(float key) {
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultInt();
    }

    public boolean containsValue(int value) {
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatKeyIntMap)) {
            return false;
        }
        FloatKeyIntMap map = (FloatKeyIntMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            float k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultFloatHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultIntHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public int tget(float key) {
        int value = this.get(key);
        if (value == MapDefaults.defaultInt() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        FloatKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract IntCollection values();

    public abstract int put(float var1, int var2);

    public abstract int lget();

    public abstract FloatSet keySet();

    public abstract FloatKeyIntMapIterator entries();
}

