/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.CharCollection;
import bak.pcj.CharIterator;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.list.AbstractCharList;
import bak.pcj.list.CharDeque;
import bak.pcj.list.CharListIterator;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CharArrayDeque
extends AbstractCharList
implements CharDeque,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 10;
    private transient char[] data;
    private int size;
    private transient int first;
    private transient int last;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;

    private CharArrayDeque(int capacity, int growthPolicy, double growthFactor, int growthChunk) {
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        this.data = new char[capacity];
        this.size = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.first = 0;
        this.last = 0;
    }

    public CharArrayDeque() {
        this(10);
    }

    public CharArrayDeque(CharCollection c) {
        this(c.size());
        this.addAll(c);
    }

    public CharArrayDeque(char[] a) {
        this(a.length);
        System.arraycopy(a, 0, this.data, 0, a.length);
        this.size = a.length;
        this.first = 0;
        this.last = a.length - 1;
    }

    public CharArrayDeque(int capacity) {
        this(capacity, 1.0);
    }

    public CharArrayDeque(int capacity, double growthFactor) {
        this(capacity, 0, growthFactor, 10);
    }

    public CharArrayDeque(int capacity, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk);
    }

    private int computeCapacity(int capacity) {
        int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
        if (newcapacity < capacity) {
            newcapacity = capacity;
        }
        return newcapacity;
    }

    public int ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            capacity = this.computeCapacity(capacity);
            char[] newdata = new char[capacity];
            this.toArray(newdata);
            this.first = 0;
            this.last = this.size;
            this.data = newdata;
        }
        return capacity;
    }

    public int capacity() {
        return this.data.length;
    }

    public void add(int index, char v) {
        if (index == 0) {
            this.addFirst(v);
        } else if (index == this.size) {
            this.addLast(v);
        } else {
            if (index < 0 || index > this.size) {
                Exceptions.indexOutOfBounds(index, 0, this.size);
            }
            this.ensureCapacity(this.size + 1);
            if (this.first < this.last || this.last == 0) {
                int iidx = index + this.first;
                int end = this.last == 0 ? this.data.length : this.last;
                int block = end - iidx;
                if (this.last == 0) {
                    this.data[0] = this.data[this.data.length - 1];
                    System.arraycopy(this.data, iidx, this.data, iidx + 1, block - 1);
                    this.last = 1;
                } else {
                    System.arraycopy(this.data, iidx, this.data, iidx + 1, block);
                    if (++this.last == this.data.length) {
                        this.last = 0;
                    }
                }
                this.data[iidx] = v;
            } else {
                int iidx = (this.first + index) % this.data.length;
                if (iidx <= this.last) {
                    int block = this.last - iidx;
                    System.arraycopy(this.data, iidx, this.data, iidx + 1, block);
                    ++this.last;
                    this.data[iidx] = v;
                } else {
                    int block = iidx - this.first;
                    System.arraycopy(this.data, this.first, this.data, this.first - 1, block);
                    --this.first;
                    this.data[iidx - 1] = v;
                }
            }
            ++this.size;
        }
    }

    public char get(int index) {
        if (index < 0 || index >= this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size - 1);
        }
        return this.data[(this.first + index) % this.data.length];
    }

    public char set(int index, char v) {
        if (index < 0 || index >= this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size - 1);
        }
        int idx = (this.first + index) % this.data.length;
        char result = this.data[idx];
        this.data[idx] = v;
        return result;
    }

    public char removeElementAt(int index) {
        char result;
        if (index == 0) {
            result = this.removeFirst();
        } else if (index == this.size - 1) {
            result = this.removeLast();
        } else {
            if (index < 0 || index >= this.size) {
                Exceptions.indexOutOfBounds(index, 0, this.size - 1);
            }
            int ridx = (this.first + index) % this.data.length;
            result = this.data[ridx];
            if (this.first < this.last || this.last == 0) {
                int block1 = ridx - this.first;
                int block2 = this.size - block1 - 1;
                if (block1 < block2) {
                    System.arraycopy(this.data, this.first, this.data, this.first + 1, block1);
                    ++this.first;
                } else {
                    System.arraycopy(this.data, ridx + 1, this.data, ridx, block2);
                    if (--this.last < 0) {
                        this.last = this.data.length - 1;
                    }
                }
            } else if (ridx < this.last) {
                int block = this.last - ridx - 1;
                System.arraycopy(this.data, ridx + 1, this.data, ridx, block);
                --this.last;
            } else {
                int block = ridx - this.first;
                System.arraycopy(this.data, this.first, this.data, this.first + 1, block);
                if (++this.first == this.data.length) {
                    this.first = 0;
                }
            }
            --this.size;
        }
        return result;
    }

    public void trimToSize() {
        if (this.data.length > this.size) {
            char[] newdata = this.toArray();
            this.first = 0;
            this.last = 0;
            this.data = newdata;
        }
    }

    public Object clone() {
        try {
            CharArrayDeque c = (CharArrayDeque)super.clone();
            c.data = new char[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public char getFirst() {
        if (this.size == 0) {
            Exceptions.dequeNoFirst();
        }
        return this.data[this.first];
    }

    public char getLast() {
        if (this.size == 0) {
            Exceptions.dequeNoLast();
        }
        return this.data[this.last == 0 ? this.data.length - 1 : this.last - 1];
    }

    public void addFirst(char v) {
        this.ensureCapacity(this.size + 1);
        if (--this.first < 0) {
            this.first = this.data.length - 1;
        }
        this.data[this.first] = v;
        ++this.size;
    }

    public void addLast(char v) {
        this.ensureCapacity(this.size + 1);
        this.data[this.last] = v;
        if (++this.last == this.data.length) {
            this.last = 0;
        }
        ++this.size;
    }

    public char removeFirst() {
        if (this.size == 0) {
            Exceptions.dequeNoFirstToRemove();
        }
        char result = this.data[this.first];
        if (++this.first == this.data.length) {
            this.first = 0;
        }
        --this.size;
        return result;
    }

    public char removeLast() {
        if (this.size == 0) {
            Exceptions.dequeNoLastToRemove();
        }
        if (--this.last < 0) {
            this.last = this.data.length - 1;
        }
        --this.size;
        return this.data[this.last];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
        this.first = 0;
        this.last = 0;
    }

    public boolean contains(char v) {
        int i = 0;
        int idx = this.first;
        while (i < this.size) {
            if (this.data[idx] == v) {
                return true;
            }
            if (++idx == this.data.length) {
                idx = 0;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(char c) {
        int i = 0;
        int idx = this.first;
        while (i < this.size) {
            if (this.data[idx] == c) {
                return i;
            }
            if (++idx == this.data.length) {
                idx = 0;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        int i = this.size - 1;
        int idx = this.last - 1;
        while (i >= 0) {
            if (idx < 0) {
                idx = this.data.length - 1;
            }
            if (this.data[idx] == c) {
                return i;
            }
            --idx;
            --i;
        }
        return -1;
    }

    public boolean remove(char v) {
        int index = this.indexOf(v);
        if (index != -1) {
            this.removeElementAt(index);
            return true;
        }
        return false;
    }

    public char[] toArray(char[] a) {
        if (a == null || a.length < this.size) {
            a = new char[this.size];
        }
        if (this.last <= this.first) {
            if (this.last == 0) {
                System.arraycopy(this.data, this.first, a, 0, this.size);
            } else {
                int block1 = this.data.length - this.first;
                int block2 = this.size - block1;
                System.arraycopy(this.data, this.first, a, 0, block1);
                System.arraycopy(this.data, 0, a, block1, block2);
            }
        } else {
            System.arraycopy(this.data, this.first, a, 0, this.size);
        }
        return a;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharDeque)) {
            return false;
        }
        CharDeque s = (CharDeque)obj;
        if (this.size != s.size()) {
            return false;
        }
        CharListIterator i2 = s.listIterator();
        int i = 0;
        int idx = this.first;
        while (i < this.size) {
            if (this.data[idx] != i2.next()) {
                return false;
            }
            if (++idx == this.data.length) {
                idx = 0;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        int i = 0;
        int idx = this.first;
        while (i < this.size) {
            h = 31 * h + DefaultCharHashFunction.INSTANCE.hash(this.data[idx]);
            if (++idx == this.data.length) {
                idx = 0;
            }
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            s.writeChar(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new char[s.readInt()];
        this.first = 0;
        this.last = this.size;
        int i = 0;
        while (i < this.size) {
            this.data[i] = s.readChar();
            ++i;
        }
    }
}

