/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.DoubleCollection;
import bak.pcj.adapter.CollectionToDoubleCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyDoubleMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyDoubleMap;
import bak.pcj.map.ShortKeyDoubleMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyDoubleMapAdapter
extends AbstractShortKeyDoubleMap
implements ShortKeyDoubleMap {
    protected Map map;
    protected Double lastValue;

    public MapToShortKeyDoubleMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyDoubleMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Double)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(double value) {
        return this.map.containsValue(new Double(value));
    }

    public ShortKeyDoubleMapIterator entries() {
        return new ShortKeyDoubleMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyDoubleMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public double getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public double get(short key) {
        Double value = (Double)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public double lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public double put(short key, double value) {
        Double oldValue = this.map.put(new Short(key), new Double(value));
        return oldValue == null ? MapDefaults.defaultDouble() : oldValue;
    }

    public double remove(short key) {
        Double value = (Double)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public int size() {
        return this.map.size();
    }

    public DoubleCollection values() {
        return new CollectionToDoubleCollectionAdapter(this.map.values());
    }

    public double tget(short key) {
        Double value = (Double)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isShortKeyDoubleAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

