/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.CharCollection;
import bak.pcj.adapter.CollectionToCharCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyCharMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyCharMap;
import bak.pcj.map.ObjectKeyCharMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyCharMapAdapter
extends AbstractObjectKeyCharMap
implements ObjectKeyCharMap {
    protected Map map;
    protected Character lastValue;

    public MapToObjectKeyCharMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyCharMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Character)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(new Character(value));
    }

    public ObjectKeyCharMapIterator entries() {
        return new ObjectKeyCharMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyCharMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public char getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getValue()).charValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public char get(Object key) {
        Character value = (Character)this.map.get(key);
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public char lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.charValue();
    }

    public char put(Object key, char value) {
        Character oldValue = this.map.put(key, new Character(value));
        return oldValue == null ? MapDefaults.defaultChar() : oldValue.charValue();
    }

    public char remove(Object key) {
        Character value = (Character)this.map.remove(key);
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public int size() {
        return this.map.size();
    }

    public CharCollection values() {
        return new CollectionToCharCollectionAdapter(this.map.values());
    }

    public char tget(Object key) {
        Character value = (Character)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value.charValue();
    }

    public boolean validate() {
        return Adapter.isObjectKeyCharAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

