/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.LongCollection;
import bak.pcj.adapter.LongIteratorToIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class LongCollectionToCollectionAdapter
extends AbstractCollection {
    protected LongCollection collection;

    public LongCollectionToCollectionAdapter(LongCollection collection) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.collection.add((Long)o);
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.collection.contains((Long)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public Iterator iterator() {
        return new LongIteratorToIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.collection.remove((Long)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.collection.size();
    }

    public int hashCode() {
        return this.collection.hashCode();
    }
}

