/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.springframework.http.client.ClientHttpResponse;

public class DoiClient {
    public static final String DOI_ENTITY = "DOI";
    public static final String ALL_DOI_ENTITY = "All DOI";
    public static final String DOI_METADATA_ENTITY = "DOI metadata";
    private String serverUrl;
    private String username;
    private String password;
    private boolean testMode;
    protected GeonetHttpRequestFactory requestFactory;

    public DoiClient(String serverUrl, String username, String password) {
        this(serverUrl, username, password, true);
    }

    public DoiClient(String serverUrl, String username, String password, boolean testMode) {
        this.serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        this.username = username;
        this.password = password;
        this.testMode = testMode;
        this.requestFactory = (GeonetHttpRequestFactory)ApplicationContextHolder.get().getBean(GeonetHttpRequestFactory.class);
    }

    public void createDoi(String doi, String url) throws DoiClientException {
        String requestBody = MessageFormat.format("doi={0}\nurl={1}", doi, url);
        this.create(this.createUrl("doi"), requestBody, "text/plain;charset=UTF-8", DOI_ENTITY);
    }

    public String retrieveDoi(String doi) throws DoiClientException {
        return this.retrieve(this.createUrl("doi/" + doi), DOI_ENTITY);
    }

    public String retrieveAllDoi(String doi) throws DoiClientException {
        return this.retrieve(this.createUrl("doi"), ALL_DOI_ENTITY);
    }

    public void createDoiMetadata(String doi, String doiMetadata) throws DoiClientException {
        this.create(this.createUrl("metadata"), doiMetadata, "application/xml", DOI_METADATA_ENTITY);
    }

    public String retrieveDoiMetadata(String doi) throws DoiClientException {
        return this.retrieve(this.createUrl("metadata/" + doi), DOI_METADATA_ENTITY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteDoiMetadata(String doi) throws DoiClientException {
        ClientHttpResponse httpResponse;
        block6: {
            httpResponse = null;
            HttpDelete deleteMethod = null;
            try {
                Log.debug((String)DOI_ENTITY, (Object)("   -- URL: " + this.serverUrl + "/metadata"));
                deleteMethod = new HttpDelete(this.createUrl("metadata/" + doi));
                httpResponse = this.requestFactory.execute((HttpUriRequest)deleteMethod, (Credentials)new UsernamePasswordCredentials(this.username, this.password), AuthScope.ANY);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)DOI_ENTITY, (Object)("   -- Request status code: " + status));
                if (status != 404 && status != 200) {
                    Log.info((String)DOI_ENTITY, (Object)("Delete DOI metadata end -- Error: " + httpResponse.getStatusText()));
                    throw new DoiClientException(httpResponse.getStatusText());
                }
                Log.info((String)DOI_ENTITY, (Object)"DeleteDOI metadata end");
                if (deleteMethod == null) break block6;
            }
            catch (Exception ex) {
                try {
                    Log.error((String)DOI_ENTITY, (Object)("   -- Error (exception): " + ex.getMessage()));
                    throw new DoiClientException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (deleteMethod != null) {
                        deleteMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
            deleteMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteDoi(String doi) throws DoiClientException {
        ClientHttpResponse httpResponse;
        block6: {
            httpResponse = null;
            HttpDelete deleteMethod = null;
            try {
                Log.debug((String)DOI_ENTITY, (Object)("   -- URL: " + this.serverUrl + "/metadata"));
                deleteMethod = new HttpDelete(this.createUrl("doi/" + doi));
                httpResponse = this.requestFactory.execute((HttpUriRequest)deleteMethod, (Credentials)new UsernamePasswordCredentials(this.username, this.password), AuthScope.ANY);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)DOI_ENTITY, (Object)("   -- Request status code: " + status));
                if (status != 404 && status != 200) {
                    Log.info((String)DOI_ENTITY, (Object)("Delete DOI end -- Error: " + httpResponse.getStatusText()));
                    throw new DoiClientException(httpResponse.getStatusText());
                }
                Log.info((String)DOI_ENTITY, (Object)"DeleteDOI end");
                if (deleteMethod == null) break block6;
            }
            catch (Exception ex) {
                try {
                    Log.error((String)DOI_ENTITY, (Object)("   -- Error (exception): " + ex.getMessage()));
                    throw new DoiClientException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (deleteMethod != null) {
                        deleteMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
            deleteMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void create(String url, String body, String contentType, String entity) throws DoiClientException {
        ClientHttpResponse httpResponse;
        block6: {
            httpResponse = null;
            HttpPost postMethod = null;
            try {
                Log.debug((String)DOI_ENTITY, (Object)("   -- URL: " + url));
                postMethod = new HttpPost(url);
                postMethod.addHeader((Header)new BasicHeader("Content-Type", contentType + ";charset=UTF-8"));
                Log.debug((String)DOI_ENTITY, (Object)("   -- Request body: " + body));
                StringEntity requestEntity = new StringEntity(body, contentType, "UTF-8");
                postMethod.setEntity((HttpEntity)requestEntity);
                httpResponse = this.requestFactory.execute((HttpUriRequest)postMethod, (Credentials)new UsernamePasswordCredentials(this.username, this.password), AuthScope.ANY);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)DOI_ENTITY, (Object)("   -- Request status code: " + status));
                if (status != 201) {
                    String message = String.format("Failed to create '%s' with '%s'. Status is %d. Error is %s.", url, body, status, httpResponse.getStatusText());
                    Log.info((String)DOI_ENTITY, (Object)message);
                    throw new DoiClientException(message);
                }
                Log.info((String)DOI_ENTITY, (Object)String.format("DOI metadata created at %s.", url));
                if (postMethod == null) break block6;
            }
            catch (Exception ex) {
                try {
                    Log.error((String)DOI_ENTITY, (Object)("   -- Error (exception): " + ex.getMessage()));
                    throw new DoiClientException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (postMethod != null) {
                        postMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
            postMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
    }

    private String retrieve(String url, String entity) throws DoiClientException {
        HttpGet getMethod;
        ClientHttpResponse httpResponse;
        block12: {
            String string;
            block13: {
                int status;
                block10: {
                    String string2;
                    block11: {
                        block8: {
                            String string3;
                            block9: {
                                httpResponse = null;
                                getMethod = null;
                                Log.debug((String)DOI_ENTITY, (Object)("   -- URL: " + url));
                                getMethod = new HttpGet(url);
                                httpResponse = this.requestFactory.execute((HttpUriRequest)getMethod, (Credentials)new UsernamePasswordCredentials(this.username, this.password), AuthScope.ANY);
                                status = httpResponse.getRawStatusCode();
                                Log.debug((String)DOI_ENTITY, (Object)("   -- Request status code: " + status));
                                if (status != 200) break block8;
                                string3 = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                                if (getMethod == null) break block9;
                                getMethod.releaseConnection();
                            }
                            IOUtils.closeQuietly((Closeable)httpResponse);
                            return string3;
                        }
                        if (status != 204) break block10;
                        string2 = null;
                        if (getMethod == null) break block11;
                        getMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly((Closeable)httpResponse);
                    return string2;
                }
                if (status != 404) break block12;
                string = null;
                if (getMethod == null) break block13;
                getMethod.releaseConnection();
            }
            IOUtils.closeQuietly((Closeable)httpResponse);
            return string;
        }
        try {
            try {
                Log.info((String)DOI_ENTITY, (Object)("Retrieve DOI metadata end -- Error: " + httpResponse.getStatusText()));
                throw new DoiClientException(httpResponse.getStatusText() + CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody())));
            }
            catch (Exception ex) {
                Log.error((String)DOI_ENTITY, (Object)("   -- Error (exception): " + ex.getMessage()));
                throw new DoiClientException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            IOUtils.closeQuietly(httpResponse);
            throw throwable;
        }
    }

    public String createUrl(String service) {
        return this.serverUrl + (this.serverUrl.endsWith("/") ? "" : "/") + service;
    }
}

