/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.StringTokenizer;
import org.dlib.gui.FlexCell;

public class FlexLayout
implements LayoutManager {
    private int xgap;
    private int ygap;
    private int width;
    private int height;
    private int xnullgap = 24;
    private int ynullgap = 24;
    private FlexCell[][] cells;
    public static final int USEPREFERRED = 0;
    public static final int EXPAND = 1;
    private int[] xflags;
    private int[] yflags;
    private int[] xpref;
    private int[] ypref;

    public FlexLayout(int n, int n2) {
        this(n, n2, 4, 4);
    }

    public FlexLayout(int n, int n2, int n3, int n4) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("width & height must be >0");
        }
        this.width = n;
        this.height = n2;
        this.xgap = n3;
        this.ygap = n4;
        this.cells = new FlexCell[n][n2];
        this.xflags = new int[n];
        this.yflags = new int[n2];
        this.xpref = new int[n];
        this.ypref = new int[n2];
    }

    public void setColProp(int n, int n2) {
        this.xflags[n] = n2;
    }

    public void setRowProp(int n, int n2) {
        this.yflags[n] = n2;
    }

    public void setNullGaps(int n, int n2) {
        this.xnullgap = n;
        this.ynullgap = n2;
    }

    public void setXgap(int n) {
        this.xgap = n;
    }

    public void setYgap(int n) {
        this.ygap = n;
    }

    public int getXgap() {
        return this.xgap;
    }

    public int getYgap() {
        return this.ygap;
    }

    public int getXNullgap() {
        return this.xnullgap;
    }

    public int getYNullgap() {
        return this.ynullgap;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addLayoutComponent(String string, Component component) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        int n6 = 1;
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().toLowerCase();
            if (string2.equals("l")) {
                n3 = 0;
            }
            if (string2.equals("c")) {
                n3 = 1;
            }
            if (string2.equals("r")) {
                n3 = 2;
            }
            if (string2.equals("x")) {
                n3 = 3;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().toLowerCase();
            if (string2.equals("t")) {
                n4 = 0;
            }
            if (string2.equals("c")) {
                n4 = 1;
            }
            if (string2.equals("b")) {
                n4 = 2;
            }
            if (string2.equals("x")) {
                n4 = 3;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            n5 = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            n6 = Integer.parseInt(stringTokenizer.nextToken());
        }
        this.cells[n][n2] = new FlexCell(n3, n4, n5, n6, component);
    }

    public void removeLayoutComponent(Component component) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (this.cells[i][j].component != component) continue;
                this.cells[i][j] = null;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            this.calcMaxWidthArray();
            this.calcMaxHeightArray();
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.width; ++n) {
                n2 += this.xpref[n];
            }
            for (n = 0; n < this.height; ++n) {
                n3 += this.ypref[n];
            }
            Insets insets = container.getInsets();
            return new Dimension(insets.left + insets.right + n2 + (this.width - 1) * this.xgap, insets.top + insets.bottom + n3 + (this.height - 1) * this.ygap);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            this.calcMaxWidthArray();
            this.calcMaxHeightArray();
            Insets insets = container.getInsets();
            int n2 = container.getSize().width - insets.left - insets.right - (this.width - 1) * this.xgap;
            int n3 = container.getSize().height - insets.top - insets.bottom - (this.height - 1) * this.ygap;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            for (n = 0; n < this.width; ++n) {
                if (this.xflags[n] == 0) {
                    n4 += this.xpref[n];
                    continue;
                }
                ++n6;
            }
            if (n6 != 0 && (n8 = (n2 - n4) / n6) < 0) {
                n8 = 0;
            }
            for (n = 0; n < this.width; ++n) {
                if (this.xflags[n] != 1) continue;
                this.xpref[n] = n8;
            }
            for (n = 0; n < this.height; ++n) {
                if (this.yflags[n] == 0) {
                    n5 += this.ypref[n];
                    continue;
                }
                ++n7;
            }
            if (n7 != 0 && (n9 = (n3 - n5) / n7) < 0) {
                n9 = 0;
            }
            for (n = 0; n < this.height; ++n) {
                if (this.yflags[n] != 1) continue;
                this.ypref[n] = n9;
            }
            n = insets.left;
            int n10 = insets.top;
            for (int i = 0; i < this.height; ++i) {
                n = insets.left;
                for (int j = 0; j < this.width; ++j) {
                    int n11 = 0;
                    int n12 = 0;
                    FlexCell flexCell = this.cells[j][i];
                    if (flexCell != null) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        for (int k = j; k < j + flexCell.xext; ++k) {
                            n11 += this.xpref[k];
                        }
                        for (int k = i; k < i + flexCell.yext; ++k) {
                            n12 += this.ypref[k];
                        }
                        Dimension dimension = flexCell.component.getPreferredSize();
                        switch (flexCell.xalign) {
                            case 0: {
                                n16 = n;
                                n15 = dimension.width;
                                break;
                            }
                            case 1: {
                                n16 = n + (n11 - dimension.width) / 2;
                                n15 = dimension.width;
                                break;
                            }
                            case 2: {
                                n16 = n + n11 - dimension.width;
                                n15 = dimension.width;
                                break;
                            }
                            case 3: {
                                n16 = n;
                                n15 = n11;
                                break;
                            }
                            default: {
                                System.out.println("FlexLayout: invalid X align type");
                                n16 = n;
                                n15 = n11;
                            }
                        }
                        switch (flexCell.yalign) {
                            case 0: {
                                n14 = n10;
                                n13 = dimension.height;
                                break;
                            }
                            case 1: {
                                n14 = n10 + (n12 - dimension.height) / 2;
                                n13 = dimension.height;
                                break;
                            }
                            case 2: {
                                n14 = n10 + n12 - dimension.height;
                                n13 = dimension.height;
                                break;
                            }
                            case 3: {
                                n14 = n10;
                                n13 = n12;
                                break;
                            }
                            default: {
                                System.out.println("FlexLayout: invalid Y align type");
                                n14 = n10;
                                n13 = n12;
                            }
                        }
                        flexCell.component.setBounds(n16, n14, n15 + (flexCell.xext - 1) * this.xgap, n13 + (flexCell.yext - 1) * this.ygap);
                    }
                    n += this.xpref[j] + this.xgap;
                }
                n10 += this.ypref[i] + this.ygap;
            }
        }
    }

    private void calcMaxWidthArray() {
        for (int i = 0; i < this.width; ++i) {
            int n = 0;
            for (int j = 0; j < this.height; ++j) {
                int n2;
                FlexCell flexCell = this.cells[i][j];
                if (flexCell == null || flexCell.xext != 1 || (n2 = flexCell.component.getPreferredSize().width) <= n) continue;
                n = n2;
            }
            if (n == 0) {
                n = this.xnullgap;
            }
            this.xpref[i] = n;
        }
    }

    private void calcMaxHeightArray() {
        for (int i = 0; i < this.height; ++i) {
            int n = 0;
            for (int j = 0; j < this.width; ++j) {
                int n2;
                FlexCell flexCell = this.cells[j][i];
                if (flexCell == null || flexCell.yext != 1 || (n2 = flexCell.component.getPreferredSize().height) <= n) continue;
                n = n2;
            }
            if (n == 0) {
                n = this.ynullgap;
            }
            this.ypref[i] = n;
        }
    }
}

