/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.component.websocket.DefaultWebsocket;
import org.apache.camel.component.websocket.NodeSynchronization;
import org.apache.camel.component.websocket.WebsocketConsumer;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketComponentServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NodeSynchronization sync;
    private WebsocketConsumer consumer;
    private ConcurrentMap<String, WebsocketConsumer> consumers = new ConcurrentHashMap<String, WebsocketConsumer>();

    public WebsocketComponentServlet(NodeSynchronization sync) {
        this.sync = sync;
    }

    public WebsocketConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(WebsocketConsumer consumer) {
        this.consumer = consumer;
    }

    public void connect(WebsocketConsumer consumer) {
        this.log.debug("Connecting consumer: {}", (Object)consumer);
        this.consumers.put(consumer.getPath(), consumer);
    }

    public void disconnect(WebsocketConsumer consumer) {
        this.log.debug("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getPath());
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        return new DefaultWebsocket(this.sync, this.consumer);
    }
}

