/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.NoninvertibleTransformException;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.Position;
import it.geosolutions.jaiext.piecewise.SingleDimensionTransformation;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;

public class DefaultPassthroughPiecewiseTransform1DElement
extends DefaultPiecewiseTransform1DElement
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = -2420723761115130075L;

    public DefaultPassthroughPiecewiseTransform1DElement(CharSequence name) throws IllegalArgumentException {
        super(name, RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)true));
    }

    public DefaultPassthroughPiecewiseTransform1DElement(CharSequence name, Range valueRange) throws IllegalArgumentException {
        super(name, valueRange);
    }

    public double transform(double value) throws TransformationException {
        if (this.checkContainment(value)) {
            return value;
        }
        throw new IllegalArgumentException("Wrong value:" + value);
    }

    private boolean checkContainment(double value) throws TransformationException {
        return this.contains(value);
    }

    public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
        PiecewiseUtilities.ensureNonNull("DirectPosition", ptSrc);
        if (ptDst == null) {
            ptDst = new Position();
        }
        double value = ptSrc.getOrdinatePosition();
        this.checkContainment(value);
        ptDst.setOrdinatePosition(this.transform(value));
        return ptDst;
    }

    public int getSourceDimensions() {
        return 1;
    }

    public int getTargetDimensions() {
        return 1;
    }

    public MathTransformation inverse() throws NoninvertibleTransformException {
        return SingleDimensionTransformation.IDENTITY;
    }

    public boolean isIdentity() {
        return true;
    }
}

