/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.iterators;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;

public abstract class RdbmsValueIterator
implements ValueIterator {
    protected RdfSource _source;
    protected String[] _namespaceNames;
    protected ResultSet _resultSet;
    protected Statement _statement;
    protected Connection _databaseCon;
    protected String _query;
    protected boolean _hasNext;

    public RdbmsValueIterator(RdfSource source, String[] namespaceNames, Connection databaseCon, String query) {
        this._source = source;
        this._namespaceNames = namespaceNames;
        this._databaseCon = databaseCon;
        this._query = query;
        this._execQuery();
        if (!this._hasNext) {
            this.close();
        }
    }

    private void _execQuery() {
        try {
            this._statement = this._databaseCon.createStatement();
            this._resultSet = this._statement.executeQuery(this._query);
            this._hasNext = this._resultSet.next();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public boolean hasNext() {
        return this._hasNext;
    }

    public Value next() {
        if (this._hasNext) {
            Value result = null;
            try {
                result = this.getResult();
                this._hasNext = this._resultSet.next();
                if (!this._hasNext) {
                    this.close();
                }
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
            return result;
        }
        throw new NoSuchElementException("No more values...");
    }

    public void close() {
        if (this._databaseCon != null) {
            try {
                if (this._resultSet != null) {
                    this._resultSet.close();
                    this._resultSet = null;
                }
                if (this._statement != null) {
                    this._statement.close();
                    this._statement = null;
                }
                this._databaseCon.close();
                this._databaseCon = null;
                this._hasNext = false;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    protected abstract Value getResult();
}

