/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.BooleanExprEvaluationException;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.StringConstant;
import org.openrdf.sesame.sail.query.StringExpr;

public class Like
implements BooleanExpr {
    private StringExpr _expr;
    private String _pattern;
    private boolean _ignoreCase;

    public Like(StringExpr expr, StringConstant pattern, boolean ignoreCase) {
        this._expr = expr;
        this._pattern = pattern.getString();
        this._ignoreCase = ignoreCase;
        if (ignoreCase) {
            this._pattern = this._pattern.toLowerCase();
        }
    }

    public void getVariables(Collection variables) {
        this._expr.getVariables(variables);
    }

    public StringExpr getStringExpr() {
        return this._expr;
    }

    public String getPattern() {
        return this._pattern;
    }

    public boolean caseSensitive() {
        return !this._ignoreCase;
    }

    public boolean isTrue(RdfSource rdfSource) throws BooleanExprEvaluationException, SailQueryException {
        String snippet;
        String val = this._expr.getString();
        if (val == null) {
            throw new BooleanExprEvaluationException();
        }
        if (this._ignoreCase) {
            val = val.toLowerCase();
        }
        int valIndex = 0;
        int prevPatternIndex = -1;
        int patternIndex = this._pattern.indexOf(42);
        if (patternIndex == -1) {
            return this._pattern.equals(val);
        }
        if (patternIndex > 0) {
            snippet = this._pattern.substring(0, patternIndex);
            if (!val.startsWith(snippet)) {
                return false;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = this._pattern.indexOf(42, patternIndex + 1);
        }
        while (patternIndex != -1) {
            snippet = this._pattern.substring(prevPatternIndex + 1, patternIndex);
            valIndex = val.indexOf(snippet, valIndex);
            if (valIndex == -1) {
                return false;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = this._pattern.indexOf(42, patternIndex + 1);
        }
        snippet = this._pattern.substring(prevPatternIndex + 1);
        if (snippet.length() > 0) {
            int i;
            valIndex = val.indexOf(snippet, valIndex);
            while ((i = val.indexOf(snippet, valIndex + 1)) != -1) {
                valIndex = i;
            }
            if (valIndex == -1) {
                return false;
            }
            if ((valIndex += snippet.length()) < val.length()) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String result = this._expr.toString() + " like \"" + this._pattern + "\"";
        if (this._ignoreCase) {
            result = result + " ignore case";
        }
        return result;
    }
}

