/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.query.TableQueryResultListener;

public interface SesameRepository {
    public void performTableQuery(QueryLanguage var1, String var2, TableQueryResultListener var3) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException;

    public QueryResultsTable performTableQuery(QueryLanguage var1, String var2) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException;

    public void performGraphQuery(QueryLanguage var1, String var2, GraphQueryResultListener var3) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException;

    public Graph performGraphQuery(QueryLanguage var1, String var2) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException;

    public void addData(URL var1, String var2, RDFFormat var3, boolean var4, AdminListener var5) throws IOException, AccessDeniedException;

    public void addData(File var1, String var2, RDFFormat var3, boolean var4, AdminListener var5) throws FileNotFoundException, IOException, AccessDeniedException;

    public void addData(String var1, String var2, RDFFormat var3, boolean var4, AdminListener var5) throws IOException, AccessDeniedException;

    public void addData(SesameRepository var1, AdminListener var2) throws IOException, AccessDeniedException;

    public void addData(Reader var1, String var2, RDFFormat var3, boolean var4, AdminListener var5) throws IOException, AccessDeniedException;

    public void addData(InputStream var1, String var2, RDFFormat var3, boolean var4, AdminListener var5) throws IOException, AccessDeniedException;

    public void addGraph(Graph var1) throws IOException, AccessDeniedException;

    public void addGraph(Graph var1, boolean var2) throws IOException, AccessDeniedException;

    public void addGraph(QueryLanguage var1, String var2) throws IOException, AccessDeniedException;

    public void addGraph(QueryLanguage var1, String var2, boolean var3) throws IOException, AccessDeniedException;

    public void removeGraph(Graph var1) throws IOException, AccessDeniedException;

    public void removeGraph(QueryLanguage var1, String var2) throws IOException, AccessDeniedException;

    public InputStream extractRDF(RDFFormat var1, boolean var2, boolean var3, boolean var4, boolean var5) throws IOException, AccessDeniedException;

    public void removeStatements(Resource var1, URI var2, Value var3, AdminListener var4) throws IOException, AccessDeniedException;

    public void clear(AdminListener var1) throws IOException, AccessDeniedException;

    public String getRepositoryId();
}

