/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class Util {
    public static JTextArea createReadOnlyTextArea(String text, Color background) {
        JTextArea readOnlyText = new JTextArea(text);
        readOnlyText.setEditable(false);
        readOnlyText.getCaret().deinstall(readOnlyText);
        readOnlyText.setBackground(background);
        return readOnlyText;
    }

    public static JTextArea createTitle(String text, Color background) {
        JTextArea title = Util.createReadOnlyTextArea(text, background);
        title.setFont(new Font("Arial", 1, 12));
        return title;
    }

    public static JLabel createLabel(Icon image) {
        JLabel label = new JLabel(image);
        label.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        return label;
    }

    public static void showWarningDialog(Component parent, String warning, String title) {
        JOptionPane.showMessageDialog(parent, warning, title, 2);
    }

    public static int showYesNoDialog(Component parent, String message, String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 0);
    }

    public static Window getOwner(Component aComponent) {
        return SwingUtilities.windowForComponent(aComponent);
    }
}

