/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.binarize;

import it.geosolutions.jaiext.binarize.JaiI18N;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class BinarizeDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Binarize"}, {"LocalName", "Binarize"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", JaiI18N.getString("BinarizeDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BinarizeDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BinarizeDescriptor2")}, {"arg1Desc", JaiI18N.getString("BinarizeDescriptor3")}, {"arg2Desc", JaiI18N.getString("BinarizeDescriptor4")}};
    private static final String[] paramNames = new String[]{"threshold", "roi", "nodata"};
    private static final Class[] paramClasses = new Class[]{Double.class, ROI.class, Range.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, null, null};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public BinarizeDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock args, StringBuffer msg) {
        if (!super.validateSources(modeName, args, msg)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage source = (RenderedImage)args.getSource(0);
        int numBands = source.getSampleModel().getNumBands();
        if (numBands != 1) {
            msg.append(this.getName() + " " + JaiI18N.getString("BinarizeDescriptor1"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, Double threshold, ROI roi, Range nodata, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Binarize", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("threshold", (Object)threshold);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        return JAI.create((String)"Binarize", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, Double threshold, ROI roi, Range nodata, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Binarize", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("threshold", (Object)threshold);
        pb.setParameter("roi", (Object)roi);
        pb.setParameter("nodata", (Object)nodata);
        return JAI.createRenderable((String)"Binarize", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

