/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfPCell;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.config.layout.BorderConfig;
import org.mapfish.print.config.layout.HorizontalAlign;
import org.mapfish.print.config.layout.VerticalAlign;
import org.mapfish.print.utils.PJsonObject;

public class CellConfig
extends BorderConfig {
    private Double paddingLeft = null;
    private Double paddingRight = null;
    private Double paddingTop = null;
    private Double paddingBottom = null;
    private String backgroundColor = null;
    private HorizontalAlign align = null;
    private VerticalAlign vertAlign = null;

    protected void apply(PdfPCell cell, RenderingContext context, PJsonObject params) {
        if (this.paddingLeft != null) {
            cell.setPaddingLeft(this.paddingLeft.floatValue());
        }
        if (this.paddingRight != null) {
            cell.setPaddingRight(this.paddingRight.floatValue());
        }
        if (this.paddingTop != null) {
            cell.setPaddingTop(this.paddingTop.floatValue());
        }
        if (this.paddingBottom != null) {
            cell.setPaddingBottom(this.paddingBottom.floatValue());
        }
        if (this.borderWidthLeft != null) {
            cell.setBorderWidthLeft(this.borderWidthLeft.floatValue());
        }
        if (this.borderWidthRight != null) {
            cell.setBorderWidthRight(this.borderWidthRight.floatValue());
        }
        if (this.borderWidthTop != null) {
            cell.setBorderWidthTop(this.borderWidthTop.floatValue());
        }
        if (this.borderWidthBottom != null) {
            cell.setBorderWidthBottom(this.borderWidthBottom.floatValue());
        }
        if (this.getBorderColorLeftVal(context, params) != null) {
            cell.setBorderColorLeft(this.getBorderColorLeftVal(context, params));
        }
        if (this.getBorderColorRightVal(context, params) != null) {
            cell.setBorderColorRight(this.getBorderColorRightVal(context, params));
        }
        if (this.getBorderColorTopVal(context, params) != null) {
            cell.setBorderColorTop(this.getBorderColorTopVal(context, params));
        }
        if (this.getBorderColorBottomVal(context, params) != null) {
            cell.setBorderColorBottom(this.getBorderColorBottomVal(context, params));
        }
        if (this.getBackgroundColorVal(context, params) != null) {
            cell.setBackgroundColor(this.getBackgroundColorVal(context, params));
        }
        if (this.align != null) {
            cell.setHorizontalAlignment(this.align.getCode());
        }
        if (this.vertAlign != null) {
            cell.setVerticalAlignment(this.vertAlign.getCode());
        }
    }

    public void setPadding(double padding) {
        this.setPaddingLeft(padding);
        this.setPaddingRight(padding);
        this.setPaddingTop(padding);
        this.setPaddingBottom(padding);
    }

    public void setPaddingLeft(double paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingRight(double paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingTop(double paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingBottom(double paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public BaseColor getBackgroundColorVal(RenderingContext context, PJsonObject params) {
        return ColorWrapper.convertColor(PDFUtils.evalString(context, params, this.backgroundColor, null));
    }

    public void setAlign(HorizontalAlign align) {
        this.align = align;
    }

    public void setVertAlign(VerticalAlign vertAlign) {
        this.vertAlign = vertAlign;
    }
}

